/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.overlay;

import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.SurfaceTexture;
import android.opengl.GLES20;
import android.view.Surface;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.internal.Issue514Workaround;
import com.otaliastudios.cameraview.internal.egl.EglViewport;
import com.otaliastudios.cameraview.overlay.Overlay;
import com.otaliastudios.cameraview.size.Size;

public class OverlayDrawer {
    private static final String TAG = OverlayDrawer.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private Overlay mOverlay;
    @VisibleForTesting
    int mTextureId;
    private SurfaceTexture mSurfaceTexture;
    private Surface mSurface;
    private float[] mTransform = new float[16];
    @VisibleForTesting
    EglViewport mViewport;
    private Issue514Workaround mIssue514Workaround;
    private final Object mIssue514WorkaroundLock = new Object();

    public OverlayDrawer(@NonNull Overlay overlay, @NonNull Size size) {
        this.mOverlay = overlay;
        this.mViewport = new EglViewport();
        this.mTextureId = this.mViewport.createTexture();
        this.mSurfaceTexture = new SurfaceTexture(this.mTextureId);
        this.mSurfaceTexture.setDefaultBufferSize(size.getWidth(), size.getHeight());
        this.mSurface = new Surface(this.mSurfaceTexture);
        this.mIssue514Workaround = new Issue514Workaround(this.mTextureId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void draw(@NonNull Overlay.Target target) {
        try {
            Canvas surfaceCanvas = this.mSurface.lockCanvas(null);
            surfaceCanvas.drawColor(0, PorterDuff.Mode.CLEAR);
            this.mOverlay.drawOn(target, surfaceCanvas);
            this.mSurface.unlockCanvasAndPost(surfaceCanvas);
        }
        catch (Surface.OutOfResourcesException e) {
            LOG.w(new Object[]{"Got Surface.OutOfResourcesException while drawing video overlays", e});
        }
        Object object = this.mIssue514WorkaroundLock;
        synchronized (object) {
            this.mIssue514Workaround.beforeOverlayUpdateTexImage();
            this.mSurfaceTexture.updateTexImage();
        }
        this.mSurfaceTexture.getTransformMatrix(this.mTransform);
    }

    public float[] getTransform() {
        return this.mTransform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void render() {
        GLES20.glDisable((int)2884);
        GLES20.glDisable((int)2929);
        GLES20.glEnable((int)3042);
        GLES20.glBlendFunc((int)770, (int)771);
        Object object = this.mIssue514WorkaroundLock;
        synchronized (object) {
            this.mViewport.drawFrame(this.mTextureId, this.mTransform);
        }
    }

    public void release() {
        if (this.mIssue514Workaround != null) {
            this.mIssue514Workaround.end();
            this.mIssue514Workaround = null;
        }
        if (this.mSurfaceTexture != null) {
            this.mSurfaceTexture.release();
            this.mSurfaceTexture = null;
        }
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        if (this.mViewport != null) {
            this.mViewport.release();
            this.mViewport = null;
        }
    }
}

