/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal.egl;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.filter.Filter;
import com.otaliastudios.cameraview.filter.NoFilter;
import com.otaliastudios.cameraview.internal.GlUtils;

public class EglViewport {
    private static final CameraLogger LOG = CameraLogger.create(EglViewport.class.getSimpleName());
    private int mProgramHandle = -1;
    private int mTextureTarget = 36197;
    private int mTextureUnit = 33984;
    private Filter mFilter;
    private Filter mPendingFilter;

    public EglViewport() {
        this(new NoFilter());
    }

    public EglViewport(@NonNull Filter filter) {
        this.mFilter = filter;
        this.createProgram();
    }

    private void createProgram() {
        this.mProgramHandle = GlUtils.createProgram(this.mFilter.getVertexShader(), this.mFilter.getFragmentShader());
        this.mFilter.onCreate(this.mProgramHandle);
    }

    public void release() {
        if (this.mProgramHandle != -1) {
            this.mFilter.onDestroy();
            GLES20.glDeleteProgram((int)this.mProgramHandle);
            this.mProgramHandle = -1;
        }
    }

    public int createTexture() {
        int[] textures = new int[1];
        GLES20.glGenTextures((int)1, (int[])textures, (int)0);
        GlUtils.checkError("glGenTextures");
        int texId = textures[0];
        GLES20.glActiveTexture((int)this.mTextureUnit);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)texId);
        GlUtils.checkError("glBindTexture " + texId);
        GLES20.glTexParameterf((int)36197, (int)10241, (float)9728.0f);
        GLES20.glTexParameterf((int)36197, (int)10240, (float)9729.0f);
        GLES20.glTexParameteri((int)36197, (int)10242, (int)33071);
        GLES20.glTexParameteri((int)36197, (int)10243, (int)33071);
        GlUtils.checkError("glTexParameter");
        return texId;
    }

    public void setFilter(@NonNull Filter filter) {
        this.mPendingFilter = filter;
    }

    public void drawFrame(int textureId, float[] textureMatrix) {
        if (this.mPendingFilter != null) {
            this.release();
            this.mFilter = this.mPendingFilter;
            this.mPendingFilter = null;
            this.createProgram();
        }
        GlUtils.checkError("draw start");
        GLES20.glUseProgram((int)this.mProgramHandle);
        GlUtils.checkError("glUseProgram");
        GLES20.glActiveTexture((int)this.mTextureUnit);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)textureId);
        this.mFilter.draw(textureMatrix);
        GLES20.glBindTexture((int)this.mTextureTarget, (int)0);
        GLES20.glUseProgram((int)0);
    }
}

