/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.internal;

import android.annotation.SuppressLint;
import android.media.MediaCodecInfo;
import android.media.MediaCodecList;
import android.os.Build;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.size.Size;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class DeviceEncoders {
    private static final String TAG = DeviceEncoders.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    @VisibleForTesting
    static boolean ENABLED = Build.VERSION.SDK_INT >= 21;
    public static final int MODE_TAKE_FIRST = 0;
    public static final int MODE_PREFER_HARDWARE = 1;
    private final MediaCodecInfo mVideoEncoder;
    private final MediaCodecInfo mAudioEncoder;
    private final MediaCodecInfo.VideoCapabilities mVideoCapabilities;
    private final MediaCodecInfo.AudioCapabilities mAudioCapabilities;

    @SuppressLint(value={"NewApi"})
    public DeviceEncoders(@NonNull String videoType, @NonNull String audioType, int mode) {
        if (ENABLED) {
            List<MediaCodecInfo> encoders = this.getDeviceEncoders();
            this.mVideoEncoder = this.findDeviceEncoder(encoders, videoType, mode);
            LOG.i("Enabled. Found video encoder:", this.mVideoEncoder.getName());
            this.mAudioEncoder = this.findDeviceEncoder(encoders, audioType, mode);
            LOG.i("Enabled. Found audio encoder:", this.mAudioEncoder.getName());
            this.mVideoCapabilities = this.mVideoEncoder.getCapabilitiesForType(videoType).getVideoCapabilities();
            this.mAudioCapabilities = this.mAudioEncoder.getCapabilitiesForType(audioType).getAudioCapabilities();
        } else {
            this.mVideoEncoder = null;
            this.mAudioEncoder = null;
            this.mVideoCapabilities = null;
            this.mAudioCapabilities = null;
            LOG.i("Disabled.");
        }
    }

    @NonNull
    @SuppressLint(value={"NewApi"})
    @VisibleForTesting
    List<MediaCodecInfo> getDeviceEncoders() {
        MediaCodecInfo[] array;
        ArrayList<MediaCodecInfo> results = new ArrayList<MediaCodecInfo>();
        for (MediaCodecInfo info : array = new MediaCodecList(0).getCodecInfos()) {
            if (!info.isEncoder()) continue;
            results.add(info);
        }
        return results;
    }

    @SuppressLint(value={"NewApi"})
    @VisibleForTesting
    boolean isHardwareEncoder(@NonNull String encoder) {
        boolean isSoftwareEncoder = (encoder = encoder.toLowerCase()).startsWith("omx.google.") || encoder.startsWith("c2.android.") || !encoder.startsWith("omx.") && !encoder.startsWith("c2.");
        return !isSoftwareEncoder;
    }

    @SuppressLint(value={"NewApi"})
    @NonNull
    @VisibleForTesting
    MediaCodecInfo findDeviceEncoder(@NonNull List<MediaCodecInfo> encoders, @NonNull String mimeType, int mode) {
        ArrayList<MediaCodecInfo> results = new ArrayList<MediaCodecInfo>();
        block0: for (MediaCodecInfo encoder : encoders) {
            String[] types;
            for (String type : types = encoder.getSupportedTypes()) {
                if (!type.equalsIgnoreCase(mimeType)) continue;
                results.add(encoder);
                continue block0;
            }
        }
        LOG.i("findDeviceEncoder -", "type:", mimeType, "encoders:", results.size());
        if (mode == 1) {
            Collections.sort(results, new Comparator<MediaCodecInfo>(){

                @Override
                public int compare(MediaCodecInfo o1, MediaCodecInfo o2) {
                    boolean hw1 = DeviceEncoders.this.isHardwareEncoder(o1.getName());
                    boolean hw2 = DeviceEncoders.this.isHardwareEncoder(o2.getName());
                    if (hw1 && hw2) {
                        return 0;
                    }
                    if (hw1) {
                        return -1;
                    }
                    if (hw2) {
                        return 1;
                    }
                    return 0;
                }
            });
        }
        if (results.isEmpty()) {
            throw new RuntimeException("No encoders for type:" + mimeType);
        }
        return (MediaCodecInfo)results.get(0);
    }

    @SuppressLint(value={"NewApi"})
    @NonNull
    public Size getSupportedVideoSize(@NonNull Size size) {
        if (!ENABLED) {
            return size;
        }
        int width = size.getWidth();
        int height = size.getHeight();
        double aspect = (double)width / (double)height;
        if ((Integer)this.mVideoCapabilities.getSupportedWidths().getUpper() < width) {
            width = (Integer)this.mVideoCapabilities.getSupportedWidths().getUpper();
            height = (int)Math.round((double)width / aspect);
        }
        if ((Integer)this.mVideoCapabilities.getSupportedHeights().getUpper() < height) {
            height = (Integer)this.mVideoCapabilities.getSupportedHeights().getUpper();
            width = (int)Math.round(aspect * (double)height);
        }
        while (width % this.mVideoCapabilities.getWidthAlignment() != 0) {
            --width;
        }
        while (height % this.mVideoCapabilities.getHeightAlignment() != 0) {
            --height;
        }
        if (!this.mVideoCapabilities.getSupportedWidths().contains((Comparable)Integer.valueOf(width))) {
            throw new RuntimeException("Width not supported after adjustment. Desired:" + width + " Range:" + this.mVideoCapabilities.getSupportedWidths());
        }
        if (!this.mVideoCapabilities.getSupportedHeights().contains((Comparable)Integer.valueOf(height))) {
            throw new RuntimeException("Height not supported after adjustment. Desired:" + height + " Range:" + this.mVideoCapabilities.getSupportedHeights());
        }
        if (!this.mVideoCapabilities.isSizeSupported(width, height)) {
            throw new RuntimeException("Size not supported for unknown reason. Might be an aspect ratio issue. Desired size:" + new Size(width, height));
        }
        Size adjusted = new Size(width, height);
        LOG.i("getSupportedVideoSize -", "inputSize:", size, "adjustedSize:", adjusted);
        return adjusted;
    }

    @SuppressLint(value={"NewApi"})
    public int getSupportedVideoBitRate(int bitRate) {
        if (!ENABLED) {
            return bitRate;
        }
        int newBitRate = (Integer)this.mVideoCapabilities.getBitrateRange().clamp((Comparable)Integer.valueOf(bitRate));
        LOG.i("getSupportedVideoBitRate -", "inputRate:", bitRate, "adjustedRate:", newBitRate);
        return newBitRate;
    }

    @SuppressLint(value={"NewApi"})
    public int getSupportedVideoFrameRate(@NonNull Size size, int frameRate) {
        if (!ENABLED) {
            return frameRate;
        }
        int newFrameRate = (int)((Double)this.mVideoCapabilities.getSupportedFrameRatesFor(size.getWidth(), size.getHeight()).clamp((Comparable)Double.valueOf(frameRate))).doubleValue();
        LOG.i("getSupportedVideoFrameRate -", "inputRate:", frameRate, "adjustedRate:", newFrameRate);
        return newFrameRate;
    }

    @SuppressLint(value={"NewApi"})
    public int getSupportedAudioBitRate(int bitRate) {
        if (!ENABLED) {
            return bitRate;
        }
        int newBitRate = (Integer)this.mAudioCapabilities.getBitrateRange().clamp((Comparable)Integer.valueOf(bitRate));
        LOG.i("getSupportedAudioBitRate -", "inputRate:", bitRate, "adjustedRate:", newBitRate);
        return newBitRate;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public String getVideoEncoder() {
        if (this.mVideoEncoder != null) {
            return this.mVideoEncoder.getName();
        }
        return null;
    }

    @SuppressLint(value={"NewApi"})
    @Nullable
    public String getAudioEncoder() {
        if (this.mAudioEncoder != null) {
            return this.mAudioEncoder.getName();
        }
        return null;
    }
}

