/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.gesture;

import android.os.Build;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import androidx.annotation.NonNull;
import com.otaliastudios.cameraview.gesture.Gesture;
import com.otaliastudios.cameraview.gesture.GestureFinder;

public class PinchGestureFinder
extends GestureFinder {
    private static final float ADD_SENSITIVITY = 2.0f;
    private ScaleGestureDetector mDetector;
    private boolean mNotify;
    private float mFactor = 0.0f;

    public PinchGestureFinder(@NonNull GestureFinder.Controller controller) {
        super(controller, 2);
        this.setGesture(Gesture.PINCH);
        this.mDetector = new ScaleGestureDetector(controller.getContext(), (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector detector) {
                PinchGestureFinder.this.mNotify = true;
                PinchGestureFinder.this.mFactor = (detector.getScaleFactor() - 1.0f) * 2.0f;
                return true;
            }
        });
        if (Build.VERSION.SDK_INT >= 19) {
            this.mDetector.setQuickScaleEnabled(false);
        }
    }

    @Override
    protected boolean handleTouchEvent(@NonNull MotionEvent event) {
        if (event.getAction() == 0) {
            this.mNotify = false;
        }
        this.mDetector.onTouchEvent(event);
        if (this.mNotify) {
            this.getPoint((int)0).x = event.getX(0);
            this.getPoint((int)0).y = event.getY(0);
            if (event.getPointerCount() > 1) {
                this.getPoint((int)1).x = event.getX(1);
                this.getPoint((int)1).y = event.getY(1);
            }
            return true;
        }
        return false;
    }

    @Override
    public float getValue(float currValue, float minValue, float maxValue) {
        float add = this.getFactor();
        return currValue + (add *= maxValue - minValue);
    }

    protected float getFactor() {
        return this.mFactor;
    }
}

