/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.filter;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.filter.Filter;
import com.otaliastudios.cameraview.filter.NoFilter;
import com.otaliastudios.cameraview.filter.OneParameterFilter;
import com.otaliastudios.cameraview.filter.TwoParameterFilter;
import com.otaliastudios.cameraview.internal.GlUtils;
import com.otaliastudios.cameraview.size.Size;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class MultiFilter
implements Filter,
OneParameterFilter,
TwoParameterFilter {
    @VisibleForTesting
    final List<Filter> filters = new ArrayList<Filter>();
    @VisibleForTesting
    final Map<Filter, State> states = new HashMap<Filter, State>();
    private final Object lock = new Object();
    private Size size = null;
    private float parameter1 = 0.0f;
    private float parameter2 = 0.0f;

    public MultiFilter(Filter ... filters) {
        this(Arrays.asList(filters));
    }

    public MultiFilter(@NonNull Collection<Filter> filters) {
        for (Filter filter : filters) {
            this.addFilter(filter);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addFilter(@NonNull Filter filter) {
        if (filter instanceof MultiFilter) {
            MultiFilter multiFilter = (MultiFilter)filter;
            for (Filter multiChild : multiFilter.filters) {
                this.addFilter(multiChild);
            }
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (!this.filters.contains(filter)) {
                this.filters.add(filter);
                this.states.put(filter, new State());
            }
        }
    }

    private void maybeCreate(@NonNull Filter filter, boolean isFirst) {
        State state = this.states.get(filter);
        if (!state.isCreated) {
            state.isCreated = true;
            String shader = filter.getFragmentShader();
            if (!isFirst) {
                shader = shader.replace("samplerExternalOES ", "sampler2D ");
            }
            state.programHandle = GlUtils.createProgram(filter.getVertexShader(), shader);
            filter.onCreate(state.programHandle);
        }
    }

    private void maybeDestroy(@NonNull Filter filter) {
        State state = this.states.get(filter);
        if (state.isCreated) {
            state.isCreated = false;
            filter.onDestroy();
            GLES20.glDeleteProgram((int)state.programHandle);
            state.programHandle = -1;
        }
    }

    private void maybeCreateFramebuffer(@NonNull Filter filter, boolean isLast) {
        if (isLast) {
            return;
        }
        State state = this.states.get(filter);
        if (!state.isFramebufferCreated) {
            state.isFramebufferCreated = true;
            int[] framebufferArray = new int[1];
            int[] textureArray = new int[1];
            GLES20.glGenFramebuffers((int)1, (int[])framebufferArray, (int)0);
            GLES20.glGenTextures((int)1, (int[])textureArray, (int)0);
            state.framebufferId = framebufferArray[0];
            state.textureId = textureArray[0];
            GLES20.glBindTexture((int)3553, (int)state.textureId);
            GLES20.glTexImage2D((int)3553, (int)0, (int)6408, (int)state.size.getWidth(), (int)state.size.getHeight(), (int)0, (int)6408, (int)5121, null);
            GLES20.glTexParameterf((int)3553, (int)10240, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10241, (float)9729.0f);
            GLES20.glTexParameterf((int)3553, (int)10242, (float)33071.0f);
            GLES20.glTexParameterf((int)3553, (int)10243, (float)33071.0f);
            GLES20.glBindFramebuffer((int)36160, (int)state.framebufferId);
            GLES20.glFramebufferTexture2D((int)36160, (int)36064, (int)3553, (int)state.textureId, (int)0);
            int status = GLES20.glCheckFramebufferStatus((int)36160);
            if (status != 36053) {
                throw new RuntimeException("Invalid framebuffer generation. Error:" + status);
            }
            GLES20.glBindTexture((int)3553, (int)0);
            GLES20.glBindFramebuffer((int)36160, (int)0);
        }
    }

    private void maybeDestroyFramebuffer(@NonNull Filter filter) {
        State state = this.states.get(filter);
        if (state.isFramebufferCreated) {
            state.isFramebufferCreated = false;
            GLES20.glDeleteFramebuffers((int)1, (int[])new int[]{state.framebufferId}, (int)0);
            state.framebufferId = -1;
            GLES20.glDeleteTextures((int)1, (int[])new int[]{state.textureId}, (int)0);
            state.textureId = -1;
        }
    }

    private void maybeSetSize(@NonNull Filter filter) {
        State state = this.states.get(filter);
        if (this.size != null && !this.size.equals(state.size)) {
            state.size = this.size;
            filter.setSize(this.size.getWidth(), this.size.getHeight());
        }
    }

    @Override
    @NonNull
    public String getVertexShader() {
        return new NoFilter().getVertexShader();
    }

    @Override
    @NonNull
    public String getFragmentShader() {
        return new NoFilter().getFragmentShader();
    }

    @Override
    public void onCreate(int programHandle) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onDestroy() {
        Object object = this.lock;
        synchronized (object) {
            for (Filter filter : this.filters) {
                this.maybeDestroyFramebuffer(filter);
                this.maybeDestroy(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setSize(int width, int height) {
        this.size = new Size(width, height);
        Object object = this.lock;
        synchronized (object) {
            for (Filter filter : this.filters) {
                this.maybeSetSize(filter);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void draw(float[] transformMatrix) {
        Object object = this.lock;
        synchronized (object) {
            for (int i = 0; i < this.filters.size(); ++i) {
                boolean isFirst = i == 0;
                boolean isLast = i == this.filters.size() - 1;
                Filter filter = this.filters.get(i);
                State state = this.states.get(filter);
                this.maybeSetSize(filter);
                this.maybeCreate(filter, isFirst);
                this.maybeCreateFramebuffer(filter, isLast);
                GLES20.glUseProgram((int)state.programHandle);
                if (!isLast) {
                    GLES20.glBindFramebuffer((int)36160, (int)state.framebufferId);
                    GLES20.glClearColor((float)0.0f, (float)0.0f, (float)0.0f, (float)0.0f);
                } else {
                    GLES20.glBindFramebuffer((int)36160, (int)0);
                }
                if (isFirst) {
                    filter.draw(transformMatrix);
                } else {
                    filter.draw(GlUtils.IDENTITY_MATRIX);
                }
                if (!isLast) {
                    GLES20.glBindTexture((int)3553, (int)state.textureId);
                } else {
                    GLES20.glBindTexture((int)3553, (int)0);
                }
                GLES20.glUseProgram((int)0);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NonNull
    public Filter copy() {
        Object object = this.lock;
        synchronized (object) {
            MultiFilter copy = new MultiFilter(new Filter[0]);
            for (Filter filter : this.filters) {
                copy.addFilter(filter.copy());
            }
            return copy;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter1(float parameter1) {
        this.parameter1 = parameter1;
        Object object = this.lock;
        synchronized (object) {
            for (Filter filter : this.filters) {
                if (!(filter instanceof OneParameterFilter)) continue;
                ((OneParameterFilter)filter).setParameter1(parameter1);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setParameter2(float parameter2) {
        this.parameter2 = parameter2;
        Object object = this.lock;
        synchronized (object) {
            for (Filter filter : this.filters) {
                if (!(filter instanceof TwoParameterFilter)) continue;
                ((TwoParameterFilter)filter).setParameter2(parameter2);
            }
        }
    }

    @Override
    public float getParameter1() {
        return this.parameter1;
    }

    @Override
    public float getParameter2() {
        return this.parameter2;
    }

    @VisibleForTesting
    static class State {
        @VisibleForTesting
        boolean isCreated = false;
        @VisibleForTesting
        boolean isFramebufferCreated = false;
        @VisibleForTesting
        Size size = null;
        private int programHandle = -1;
        private int framebufferId = -1;
        private int textureId = -1;

        State() {
        }
    }
}

