/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.filter;

import android.opengl.GLES20;
import androidx.annotation.NonNull;
import androidx.annotation.VisibleForTesting;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.filter.Filter;
import com.otaliastudios.cameraview.filter.OneParameterFilter;
import com.otaliastudios.cameraview.filter.TwoParameterFilter;
import com.otaliastudios.cameraview.internal.GlUtils;
import com.otaliastudios.cameraview.size.Size;
import java.nio.Buffer;
import java.nio.FloatBuffer;

public abstract class BaseFilter
implements Filter {
    private static final String TAG = BaseFilter.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private static final String DEFAULT_VERTEX_POSITION_NAME = "aPosition";
    private static final String DEFAULT_VERTEX_TEXTURE_COORDINATE_NAME = "aTextureCoord";
    private static final String DEFAULT_VERTEX_MVP_MATRIX_NAME = "uMVPMatrix";
    private static final String DEFAULT_VERTEX_TRANSFORM_MATRIX_NAME = "uTexMatrix";
    private static final String DEFAULT_FRAGMENT_TEXTURE_COORDINATE_NAME = "vTextureCoord";
    private FloatBuffer vertexPosition = GlUtils.floatBuffer(new float[]{-1.0f, -1.0f, 1.0f, -1.0f, -1.0f, 1.0f, 1.0f, 1.0f});
    private FloatBuffer textureCoordinates = GlUtils.floatBuffer(new float[]{0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 1.0f, 1.0f});
    private int vertexModelViewProjectionMatrixLocation = -1;
    private int vertexTranformMatrixLocation = -1;
    private int vertexPositionLocation = -1;
    private int vertexTextureCoordinateLocation = -1;
    @VisibleForTesting
    int programHandle = -1;
    @VisibleForTesting
    Size size;
    protected String vertexPositionName = "aPosition";
    protected String vertexTextureCoordinateName = "aTextureCoord";
    protected String vertexModelViewProjectionMatrixName = "uMVPMatrix";
    protected String vertexTransformMatrixName = "uTexMatrix";
    protected String fragmentTextureCoordinateName = "vTextureCoord";

    @NonNull
    private static String createDefaultVertexShader(@NonNull String vertexPositionName, @NonNull String vertexTextureCoordinateName, @NonNull String vertexModelViewProjectionMatrixName, @NonNull String vertexTransformMatrixName, @NonNull String fragmentTextureCoordinateName) {
        return "uniform mat4 " + vertexModelViewProjectionMatrixName + ";\nuniform mat4 " + vertexTransformMatrixName + ";\nattribute vec4 " + vertexPositionName + ";\nattribute vec4 " + vertexTextureCoordinateName + ";\nvarying vec2 " + fragmentTextureCoordinateName + ";\nvoid main() {\n    gl_Position = " + vertexModelViewProjectionMatrixName + " * " + vertexPositionName + ";\n    vTextureCoord = (" + vertexTransformMatrixName + " * " + vertexTextureCoordinateName + ").xy;\n}\n";
    }

    @NonNull
    private static String createDefaultFragmentShader(@NonNull String fragmentTextureCoordinateName) {
        return "#extension GL_OES_EGL_image_external : require\nprecision mediump float;\nvarying vec2 " + fragmentTextureCoordinateName + ";\nuniform samplerExternalOES sTexture;\nvoid main() {\n  gl_FragColor = texture2D(sTexture, " + fragmentTextureCoordinateName + ");\n}\n";
    }

    @NonNull
    protected String createDefaultVertexShader() {
        return BaseFilter.createDefaultVertexShader(this.vertexPositionName, this.vertexTextureCoordinateName, this.vertexModelViewProjectionMatrixName, this.vertexTransformMatrixName, this.fragmentTextureCoordinateName);
    }

    @NonNull
    protected String createDefaultFragmentShader() {
        return BaseFilter.createDefaultFragmentShader(this.fragmentTextureCoordinateName);
    }

    @Override
    public void onCreate(int programHandle) {
        this.programHandle = programHandle;
        this.vertexPositionLocation = GLES20.glGetAttribLocation((int)programHandle, (String)this.vertexPositionName);
        GlUtils.checkLocation(this.vertexPositionLocation, this.vertexPositionName);
        this.vertexTextureCoordinateLocation = GLES20.glGetAttribLocation((int)programHandle, (String)this.vertexTextureCoordinateName);
        GlUtils.checkLocation(this.vertexTextureCoordinateLocation, this.vertexTextureCoordinateName);
        this.vertexModelViewProjectionMatrixLocation = GLES20.glGetUniformLocation((int)programHandle, (String)this.vertexModelViewProjectionMatrixName);
        GlUtils.checkLocation(this.vertexModelViewProjectionMatrixLocation, this.vertexModelViewProjectionMatrixName);
        this.vertexTranformMatrixLocation = GLES20.glGetUniformLocation((int)programHandle, (String)this.vertexTransformMatrixName);
        GlUtils.checkLocation(this.vertexTranformMatrixLocation, this.vertexTransformMatrixName);
    }

    @Override
    public void onDestroy() {
        this.programHandle = -1;
        this.vertexPositionLocation = -1;
        this.vertexTextureCoordinateLocation = -1;
        this.vertexModelViewProjectionMatrixLocation = -1;
        this.vertexTranformMatrixLocation = -1;
    }

    @Override
    @NonNull
    public String getVertexShader() {
        return this.createDefaultVertexShader();
    }

    @Override
    public void setSize(int width, int height) {
        this.size = new Size(width, height);
    }

    @Override
    public void draw(float[] transformMatrix) {
        if (this.programHandle == -1) {
            LOG.w("Filter.draw() called after destroying the filter. This can happen rarely because of threading.");
        } else {
            this.onPreDraw(transformMatrix);
            this.onDraw();
            this.onPostDraw();
        }
    }

    protected void onPreDraw(float[] transformMatrix) {
        GLES20.glUniformMatrix4fv((int)this.vertexModelViewProjectionMatrixLocation, (int)1, (boolean)false, (float[])GlUtils.IDENTITY_MATRIX, (int)0);
        GlUtils.checkError("glUniformMatrix4fv");
        GLES20.glUniformMatrix4fv((int)this.vertexTranformMatrixLocation, (int)1, (boolean)false, (float[])transformMatrix, (int)0);
        GlUtils.checkError("glUniformMatrix4fv");
        GLES20.glEnableVertexAttribArray((int)this.vertexPositionLocation);
        GlUtils.checkError("glEnableVertexAttribArray: " + this.vertexPositionLocation);
        GLES20.glVertexAttribPointer((int)this.vertexPositionLocation, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.vertexPosition);
        GlUtils.checkError("glVertexAttribPointer");
        GLES20.glEnableVertexAttribArray((int)this.vertexTextureCoordinateLocation);
        GlUtils.checkError("glEnableVertexAttribArray");
        GLES20.glVertexAttribPointer((int)this.vertexTextureCoordinateLocation, (int)2, (int)5126, (boolean)false, (int)8, (Buffer)this.textureCoordinates);
        GlUtils.checkError("glVertexAttribPointer");
    }

    protected void onDraw() {
        GLES20.glDrawArrays((int)5, (int)0, (int)4);
        GlUtils.checkError("glDrawArrays");
    }

    protected void onPostDraw() {
        GLES20.glDisableVertexAttribArray((int)this.vertexPositionLocation);
        GLES20.glDisableVertexAttribArray((int)this.vertexTextureCoordinateLocation);
    }

    @Override
    @NonNull
    public final BaseFilter copy() {
        BaseFilter copy = this.onCopy();
        if (this.size != null) {
            copy.setSize(this.size.getWidth(), this.size.getHeight());
        }
        if (this instanceof OneParameterFilter) {
            ((OneParameterFilter)((Object)copy)).setParameter1(((OneParameterFilter)((Object)this)).getParameter1());
        }
        if (this instanceof TwoParameterFilter) {
            ((TwoParameterFilter)((Object)copy)).setParameter2(((TwoParameterFilter)((Object)this)).getParameter2());
        }
        return copy;
    }

    protected BaseFilter onCopy() {
        try {
            return (BaseFilter)this.getClass().newInstance();
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Filters should have a public no-arguments constructor.", e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Filters should have a public no-arguments constructor.", e);
        }
    }
}

