/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview.engine;

import android.content.Context;
import android.graphics.PointF;
import android.location.Location;
import android.os.Handler;
import android.os.Looper;
import androidx.annotation.CallSuper;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import androidx.annotation.WorkerThread;
import com.google.android.gms.tasks.Continuation;
import com.google.android.gms.tasks.OnCompleteListener;
import com.google.android.gms.tasks.OnFailureListener;
import com.google.android.gms.tasks.SuccessContinuation;
import com.google.android.gms.tasks.Task;
import com.google.android.gms.tasks.TaskCompletionSource;
import com.otaliastudios.cameraview.CameraException;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.PictureResult;
import com.otaliastudios.cameraview.VideoResult;
import com.otaliastudios.cameraview.controls.Audio;
import com.otaliastudios.cameraview.controls.Facing;
import com.otaliastudios.cameraview.controls.Flash;
import com.otaliastudios.cameraview.controls.Hdr;
import com.otaliastudios.cameraview.controls.Mode;
import com.otaliastudios.cameraview.controls.VideoCodec;
import com.otaliastudios.cameraview.controls.WhiteBalance;
import com.otaliastudios.cameraview.engine.Mapper;
import com.otaliastudios.cameraview.engine.Step;
import com.otaliastudios.cameraview.engine.offset.Angles;
import com.otaliastudios.cameraview.engine.offset.Reference;
import com.otaliastudios.cameraview.frame.Frame;
import com.otaliastudios.cameraview.frame.FrameManager;
import com.otaliastudios.cameraview.gesture.Gesture;
import com.otaliastudios.cameraview.internal.utils.Op;
import com.otaliastudios.cameraview.internal.utils.WorkerHandler;
import com.otaliastudios.cameraview.overlay.Overlay;
import com.otaliastudios.cameraview.picture.PictureRecorder;
import com.otaliastudios.cameraview.preview.CameraPreview;
import com.otaliastudios.cameraview.size.AspectRatio;
import com.otaliastudios.cameraview.size.Size;
import com.otaliastudios.cameraview.size.SizeSelector;
import com.otaliastudios.cameraview.size.SizeSelectors;
import com.otaliastudios.cameraview.video.VideoRecorder;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;

public abstract class CameraEngine
implements CameraPreview.SurfaceCallback,
PictureRecorder.PictureResultListener,
VideoRecorder.VideoResultListener {
    private static final String TAG = CameraEngine.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    public static final int STATE_STOPPING = -1;
    public static final int STATE_STOPPED = 0;
    public static final int STATE_STARTING = 1;
    public static final int STATE_STARTED = 2;
    protected WorkerHandler mHandler;
    protected final Callback mCallback;
    protected CameraPreview mPreview;
    protected CameraOptions mCameraOptions;
    protected Mapper mMapper;
    protected PictureRecorder mPictureRecorder;
    protected VideoRecorder mVideoRecorder;
    protected Size mCaptureSize;
    protected Size mPreviewStreamSize;
    protected Flash mFlash;
    protected WhiteBalance mWhiteBalance;
    protected VideoCodec mVideoCodec;
    protected Hdr mHdr;
    protected Location mLocation;
    protected float mZoomValue;
    protected float mExposureCorrectionValue;
    protected boolean mPlaySounds;
    @VisibleForTesting
    Handler mCrashHandler;
    private final FrameManager mFrameManager;
    private final Angles mAngles;
    @Nullable
    private SizeSelector mPreviewStreamSizeSelector;
    private SizeSelector mPictureSizeSelector;
    private SizeSelector mVideoSizeSelector;
    private Facing mFacing;
    private Mode mMode;
    private Audio mAudio;
    private long mVideoMaxSize;
    private int mVideoMaxDuration;
    private int mVideoBitRate;
    private int mAudioBitRate;
    private boolean mHasFrameProcessors;
    private long mAutoFocusResetDelayMillis;
    private int mSnapshotMaxWidth = Integer.MAX_VALUE;
    private int mSnapshotMaxHeight = Integer.MAX_VALUE;
    private Overlay overlay;
    private final Step.Callback mStepCallback = new Step.Callback(){

        @Override
        @NonNull
        public Executor getExecutor() {
            return CameraEngine.this.mHandler.getExecutor();
        }

        @Override
        public void handleException(@NonNull Exception exception) {
            CameraEngine.this.handleException(Thread.currentThread(), exception, false);
        }
    };
    @VisibleForTesting
    Step mEngineStep = new Step("engine", this.mStepCallback);
    private Step mBindStep = new Step("bind", this.mStepCallback);
    private Step mPreviewStep = new Step("preview", this.mStepCallback);
    private Step mAllStep = new Step("all", this.mStepCallback);
    @VisibleForTesting(otherwise=4)
    Op<Void> mZoomOp = new Op();
    @VisibleForTesting(otherwise=4)
    Op<Void> mExposureCorrectionOp = new Op();
    @VisibleForTesting(otherwise=4)
    Op<Void> mFlashOp = new Op();
    @VisibleForTesting(otherwise=4)
    Op<Void> mWhiteBalanceOp = new Op();
    @VisibleForTesting(otherwise=4)
    Op<Void> mHdrOp = new Op();
    @VisibleForTesting(otherwise=4)
    Op<Void> mLocationOp = new Op();
    @VisibleForTesting(otherwise=4)
    Op<Void> mPlaySoundsOp = new Op();

    protected CameraEngine(@NonNull Callback callback) {
        this.mCallback = callback;
        this.mCrashHandler = new Handler(Looper.getMainLooper());
        this.mHandler = WorkerHandler.get("CameraViewEngine");
        this.mHandler.getThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new CrashExceptionHandler());
        this.mFrameManager = this.instantiateFrameManager();
        this.mAngles = new Angles();
    }

    public void setPreview(@NonNull CameraPreview cameraPreview) {
        if (this.mPreview != null) {
            this.mPreview.setSurfaceCallback(null);
        }
        this.mPreview = cameraPreview;
        this.mPreview.setSurfaceCallback(this);
    }

    private void handleException(@NonNull Thread thread, final @NonNull Throwable throwable, boolean fromExceptionHandler) {
        if (!(throwable instanceof CameraException)) {
            LOG.e("uncaughtException:", "Unexpected exception:", throwable);
            this.mCrashHandler.post(new Runnable(){

                @Override
                public void run() {
                    CameraEngine.this.destroy();
                    if (throwable instanceof RuntimeException) {
                        throw (RuntimeException)throwable;
                    }
                    throw new RuntimeException(throwable);
                }
            });
            return;
        }
        CameraException cameraException = (CameraException)throwable;
        LOG.e("uncaughtException:", "Got CameraException:", cameraException, "on engine state:", this.getEngineStateName());
        if (fromExceptionHandler) {
            thread.interrupt();
            this.mHandler = WorkerHandler.get("CameraViewEngine");
            this.mHandler.getThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new CrashExceptionHandler());
        }
        this.mCallback.dispatchError(cameraException);
        if (cameraException.isUnrecoverable()) {
            this.stop(true);
        }
    }

    public final int getEngineState() {
        return this.mEngineStep.getState();
    }

    public final int getBindState() {
        return this.mBindStep.getState();
    }

    public final int getPreviewState() {
        return this.mPreviewStep.getState();
    }

    @NonNull
    private String getEngineStateName() {
        return this.mEngineStep.getStateName();
    }

    private boolean canStartEngine() {
        return this.mEngineStep.isStoppingOrStopped();
    }

    private boolean needsStopEngine() {
        return this.mEngineStep.isStartedOrStarting();
    }

    private boolean canStartBind() {
        return this.mEngineStep.isStarted() && this.mPreview != null && this.mPreview.hasSurface() && this.mBindStep.isStoppingOrStopped();
    }

    private boolean needsStopBind() {
        return this.mBindStep.isStartedOrStarting();
    }

    private boolean canStartPreview() {
        return this.mEngineStep.isStarted() && this.mBindStep.isStarted() && this.mPreviewStep.isStoppingOrStopped();
    }

    private boolean needsStopPreview() {
        return this.mPreviewStep.isStartedOrStarting();
    }

    @NonNull
    @WorkerThread
    private Task<Void> startEngine() {
        if (this.canStartEngine()) {
            this.mEngineStep.doStart(false, new Callable<Task<Void>>(){

                @Override
                public Task<Void> call() {
                    if (!CameraEngine.this.collectCameraInfo(CameraEngine.this.mFacing)) {
                        LOG.e("onStartEngine:", "No camera available for facing", CameraEngine.this.mFacing);
                        throw new CameraException(6);
                    }
                    return CameraEngine.this.onStartEngine();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    CameraEngine.this.mCallback.dispatchOnCameraOpened(CameraEngine.this.mCameraOptions);
                }
            });
        }
        return this.mEngineStep.getTask();
    }

    @NonNull
    @WorkerThread
    private Task<Void> stopEngine(boolean swallowExceptions) {
        if (this.needsStopEngine()) {
            this.mEngineStep.doStop(swallowExceptions, new Callable<Task<Void>>(){

                @Override
                public Task<Void> call() {
                    return CameraEngine.this.onStopEngine();
                }
            }, new Runnable(){

                @Override
                public void run() {
                    CameraEngine.this.mCallback.dispatchOnCameraClosed();
                }
            });
        }
        return this.mEngineStep.getTask();
    }

    @NonNull
    @WorkerThread
    protected abstract Task<Void> onStartEngine();

    @NonNull
    @WorkerThread
    protected abstract Task<Void> onStopEngine();

    @NonNull
    @WorkerThread
    private Task<Void> startBind() {
        if (this.canStartBind()) {
            this.mBindStep.doStart(false, new Callable<Task<Void>>(){

                @Override
                public Task<Void> call() {
                    return CameraEngine.this.onStartBind();
                }
            });
        }
        return this.mBindStep.getTask();
    }

    @NonNull
    @WorkerThread
    private Task<Void> stopBind(boolean swallowExceptions) {
        if (this.needsStopBind()) {
            this.mBindStep.doStop(swallowExceptions, new Callable<Task<Void>>(){

                @Override
                public Task<Void> call() {
                    return CameraEngine.this.onStopBind();
                }
            });
        }
        return this.mBindStep.getTask();
    }

    @NonNull
    @WorkerThread
    protected abstract Task<Void> onStartBind();

    @NonNull
    @WorkerThread
    protected abstract Task<Void> onStopBind();

    protected void restartBind() {
        LOG.i("restartBind", "posting.");
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                LOG.w("restartBind", "executing stopPreview.");
                CameraEngine.this.stopPreview(false).continueWithTask(CameraEngine.this.mHandler.getExecutor(), (Continuation)new Continuation<Void, Task<Void>>(){

                    public Task<Void> then(@NonNull Task<Void> task) {
                        LOG.w("restartBind", "executing stopBind.");
                        return CameraEngine.this.stopBind(false);
                    }
                }).onSuccessTask(CameraEngine.this.mHandler.getExecutor(), (SuccessContinuation)new SuccessContinuation<Void, Void>(){

                    @NonNull
                    public Task<Void> then(@Nullable Void aVoid) {
                        LOG.w("restartBind", "executing startBind.");
                        return CameraEngine.this.startBind();
                    }
                }).onSuccessTask(CameraEngine.this.mHandler.getExecutor(), (SuccessContinuation)new SuccessContinuation<Void, Void>(){

                    @NonNull
                    public Task<Void> then(@Nullable Void aVoid) {
                        LOG.w("restartBind", "executing startPreview.");
                        return CameraEngine.this.startPreview();
                    }
                });
            }
        });
    }

    @NonNull
    @WorkerThread
    private Task<Void> startPreview() {
        LOG.i("startPreview", "canStartPreview:", this.canStartPreview());
        if (this.canStartPreview()) {
            this.mPreviewStep.doStart(false, new Callable<Task<Void>>(){

                @Override
                public Task<Void> call() {
                    return CameraEngine.this.onStartPreview();
                }
            });
        }
        return this.mPreviewStep.getTask();
    }

    @NonNull
    @WorkerThread
    private Task<Void> stopPreview(boolean swallowExceptions) {
        LOG.i("stopPreview", "needsStopPreview:", this.needsStopPreview(), "swallowExceptions:", swallowExceptions);
        if (this.needsStopPreview()) {
            this.mPreviewStep.doStop(swallowExceptions, new Callable<Task<Void>>(){

                @Override
                public Task<Void> call() {
                    return CameraEngine.this.onStopPreview();
                }
            });
        }
        return this.mPreviewStep.getTask();
    }

    protected void restartPreview() {
        LOG.i("restartPreview", "posting.");
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                LOG.i("restartPreview", "executing.");
                CameraEngine.this.stopPreview(false);
                CameraEngine.this.startPreview();
            }
        });
    }

    @NonNull
    @WorkerThread
    protected abstract Task<Void> onStartPreview();

    @NonNull
    @WorkerThread
    protected abstract Task<Void> onStopPreview();

    @Override
    public final void onSurfaceAvailable() {
        LOG.i("onSurfaceAvailable:", "Size is", this.getPreviewSurfaceSize(Reference.VIEW));
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                CameraEngine.this.startBind().onSuccessTask(CameraEngine.this.mHandler.getExecutor(), (SuccessContinuation)new SuccessContinuation<Void, Void>(){

                    @NonNull
                    public Task<Void> then(@Nullable Void aVoid) {
                        return CameraEngine.this.startPreview();
                    }
                });
            }
        });
    }

    @Override
    public final void onSurfaceChanged() {
        LOG.i("onSurfaceChanged:", "Size is", this.getPreviewSurfaceSize(Reference.VIEW), "Posting.");
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                LOG.i("onSurfaceChanged:", "Engine started?", CameraEngine.this.mEngineStep.isStarted(), "Bind started?", CameraEngine.this.mBindStep.isStarted());
                if (!CameraEngine.this.mEngineStep.isStarted()) {
                    return;
                }
                if (!CameraEngine.this.mBindStep.isStarted()) {
                    return;
                }
                Size newSize = CameraEngine.this.computePreviewStreamSize();
                if (newSize.equals(CameraEngine.this.mPreviewStreamSize)) {
                    LOG.i("onSurfaceChanged:", "The computed preview size is identical. No op.");
                } else {
                    LOG.i("onSurfaceChanged:", "Computed a new preview size. Calling onPreviewStreamSizeChanged().");
                    CameraEngine.this.mPreviewStreamSize = newSize;
                    CameraEngine.this.onPreviewStreamSizeChanged();
                }
            }
        });
    }

    @WorkerThread
    protected abstract void onPreviewStreamSizeChanged();

    @Override
    public final void onSurfaceDestroyed() {
        LOG.i("onSurfaceDestroyed");
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                CameraEngine.this.stopPreview(false).onSuccessTask(CameraEngine.this.mHandler.getExecutor(), (SuccessContinuation)new SuccessContinuation<Void, Void>(){

                    @NonNull
                    public Task<Void> then(@Nullable Void aVoid) {
                        return CameraEngine.this.stopBind(false);
                    }
                });
            }
        });
    }

    public void destroy() {
        LOG.i("destroy:", "state:", this.getEngineStateName(), "thread:", Thread.currentThread());
        this.mHandler.getThread().setUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new NoOpExceptionHandler());
        final CountDownLatch latch = new CountDownLatch(1);
        this.stop(true).addOnCompleteListener(this.mHandler.getExecutor(), (OnCompleteListener)new OnCompleteListener<Void>(){

            public void onComplete(@NonNull Task<Void> task) {
                latch.countDown();
            }
        });
        try {
            boolean success = latch.await(3L, TimeUnit.SECONDS);
            if (!success) {
                LOG.e("Probably some deadlock in destroy.", "Current thread:", Thread.currentThread(), "Handler thread: ", this.mHandler.getThread());
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    protected final void restart() {
        LOG.i("Restart:", "calling stop and start");
        this.stop();
        this.start();
    }

    @NonNull
    public Task<Void> start() {
        LOG.i("Start:", "posting runnable. State:", this.getEngineStateName());
        final TaskCompletionSource outTask = new TaskCompletionSource();
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                LOG.w("Start:", "executing runnable. AllState is", CameraEngine.this.mAllStep.getState());
                CameraEngine.this.mAllStep.doStart(false, new Callable<Task<Void>>(){

                    @Override
                    public Task<Void> call() {
                        return CameraEngine.this.startEngine().addOnFailureListener(CameraEngine.this.mHandler.getExecutor(), new OnFailureListener(){

                            public void onFailure(@NonNull Exception e) {
                                outTask.trySetException(e);
                            }
                        }).onSuccessTask(CameraEngine.this.mHandler.getExecutor(), (SuccessContinuation)new SuccessContinuation<Void, Void>(){

                            @NonNull
                            public Task<Void> then(@Nullable Void aVoid) {
                                outTask.trySetResult(null);
                                return CameraEngine.this.startBind();
                            }
                        }).onSuccessTask(CameraEngine.this.mHandler.getExecutor(), (SuccessContinuation)new SuccessContinuation<Void, Void>(){

                            @NonNull
                            public Task<Void> then(@Nullable Void aVoid) {
                                return CameraEngine.this.startPreview();
                            }
                        });
                    }
                });
            }
        });
        return outTask.getTask();
    }

    @NonNull
    public Task<Void> stop() {
        return this.stop(false);
    }

    @NonNull
    private Task<Void> stop(final boolean swallowExceptions) {
        LOG.i("Stop:", "posting runnable. State:", this.getEngineStateName());
        final TaskCompletionSource outTask = new TaskCompletionSource();
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                LOG.w("Stop:", "executing runnable. AllState is", CameraEngine.this.mAllStep.getState());
                CameraEngine.this.mAllStep.doStop(swallowExceptions, new Callable<Task<Void>>(){

                    @Override
                    public Task<Void> call() {
                        return CameraEngine.this.stopPreview(swallowExceptions).continueWithTask(CameraEngine.this.mHandler.getExecutor(), (Continuation)new Continuation<Void, Task<Void>>(){

                            public Task<Void> then(@NonNull Task<Void> task) {
                                return CameraEngine.this.stopBind(swallowExceptions);
                            }
                        }).continueWithTask(CameraEngine.this.mHandler.getExecutor(), (Continuation)new Continuation<Void, Task<Void>>(){

                            public Task<Void> then(@NonNull Task<Void> task) {
                                return CameraEngine.this.stopEngine(swallowExceptions);
                            }
                        }).continueWithTask(CameraEngine.this.mHandler.getExecutor(), (Continuation)new Continuation<Void, Task<Void>>(){

                            public Task<Void> then(@NonNull Task<Void> task) {
                                if (task.isSuccessful()) {
                                    outTask.trySetResult(null);
                                } else {
                                    outTask.trySetException(task.getException());
                                }
                                return task;
                            }
                        });
                    }
                });
            }
        });
        return outTask.getTask();
    }

    public final void setOverlay(@Nullable Overlay overlay) {
        this.overlay = overlay;
    }

    @Nullable
    public final Overlay getOverlay() {
        return this.overlay;
    }

    public final Angles getAngles() {
        return this.mAngles;
    }

    public final void setPreviewStreamSizeSelector(@Nullable SizeSelector selector) {
        this.mPreviewStreamSizeSelector = selector;
    }

    @Nullable
    public final SizeSelector getPreviewStreamSizeSelector() {
        return this.mPreviewStreamSizeSelector;
    }

    public final void setPictureSizeSelector(@NonNull SizeSelector selector) {
        this.mPictureSizeSelector = selector;
    }

    @NonNull
    public final SizeSelector getPictureSizeSelector() {
        return this.mPictureSizeSelector;
    }

    public final void setVideoSizeSelector(@NonNull SizeSelector selector) {
        this.mVideoSizeSelector = selector;
    }

    @NonNull
    public final SizeSelector getVideoSizeSelector() {
        return this.mVideoSizeSelector;
    }

    public final void setVideoMaxSize(long videoMaxSizeBytes) {
        this.mVideoMaxSize = videoMaxSizeBytes;
    }

    public final long getVideoMaxSize() {
        return this.mVideoMaxSize;
    }

    public final void setVideoMaxDuration(int videoMaxDurationMillis) {
        this.mVideoMaxDuration = videoMaxDurationMillis;
    }

    public final int getVideoMaxDuration() {
        return this.mVideoMaxDuration;
    }

    public final void setVideoCodec(@NonNull VideoCodec codec) {
        this.mVideoCodec = codec;
    }

    public final VideoCodec getVideoCodec() {
        return this.mVideoCodec;
    }

    public final void setVideoBitRate(int videoBitRate) {
        this.mVideoBitRate = videoBitRate;
    }

    public final int getVideoBitRate() {
        return this.mVideoBitRate;
    }

    public final void setAudioBitRate(int audioBitRate) {
        this.mAudioBitRate = audioBitRate;
    }

    public final int getAudioBitRate() {
        return this.mAudioBitRate;
    }

    public final void setSnapshotMaxWidth(int maxWidth) {
        this.mSnapshotMaxWidth = maxWidth;
    }

    public int getSnapshotMaxWidth() {
        return this.mSnapshotMaxWidth;
    }

    public final void setSnapshotMaxHeight(int maxHeight) {
        this.mSnapshotMaxHeight = maxHeight;
    }

    public int getSnapshotMaxHeight() {
        return this.mSnapshotMaxHeight;
    }

    public final void setAutoFocusResetDelay(long delayMillis) {
        this.mAutoFocusResetDelayMillis = delayMillis;
    }

    public final long getAutoFocusResetDelay() {
        return this.mAutoFocusResetDelayMillis;
    }

    public final void setFacing(final @NonNull Facing facing) {
        final Facing old = this.mFacing;
        if (facing != old) {
            this.mFacing = facing;
            this.mHandler.run(new Runnable(){

                @Override
                public void run() {
                    if (CameraEngine.this.getEngineState() < 2) {
                        return;
                    }
                    if (CameraEngine.this.collectCameraInfo(facing)) {
                        CameraEngine.this.restart();
                    } else {
                        CameraEngine.this.mFacing = old;
                    }
                }
            });
        }
    }

    @NonNull
    public final Facing getFacing() {
        return this.mFacing;
    }

    public final void setAudio(@NonNull Audio audio) {
        if (this.mAudio != audio) {
            if (this.isTakingVideo()) {
                LOG.w("Audio setting was changed while recording. Changes will take place starting from next video");
            }
            this.mAudio = audio;
        }
    }

    @NonNull
    public final Audio getAudio() {
        return this.mAudio;
    }

    public final void setMode(@NonNull Mode mode) {
        if (mode != this.mMode) {
            this.mMode = mode;
            this.mHandler.run(new Runnable(){

                @Override
                public void run() {
                    if (CameraEngine.this.getEngineState() == 2) {
                        CameraEngine.this.restart();
                    }
                }
            });
        }
    }

    @NonNull
    public final Mode getMode() {
        return this.mMode;
    }

    @NonNull
    public final FrameManager getFrameManager() {
        return this.mFrameManager;
    }

    @Nullable
    public final CameraOptions getCameraOptions() {
        return this.mCameraOptions;
    }

    @NonNull
    public final Flash getFlash() {
        return this.mFlash;
    }

    @NonNull
    public final WhiteBalance getWhiteBalance() {
        return this.mWhiteBalance;
    }

    @NonNull
    public final Hdr getHdr() {
        return this.mHdr;
    }

    @Nullable
    public final Location getLocation() {
        return this.mLocation;
    }

    public final float getZoomValue() {
        return this.mZoomValue;
    }

    public final float getExposureCorrectionValue() {
        return this.mExposureCorrectionValue;
    }

    @CallSuper
    public void setHasFrameProcessors(boolean hasFrameProcessors) {
        this.mHasFrameProcessors = hasFrameProcessors;
    }

    public final boolean hasFrameProcessors() {
        return this.mHasFrameProcessors;
    }

    protected final boolean shouldResetAutoFocus() {
        return this.mAutoFocusResetDelayMillis > 0L && this.mAutoFocusResetDelayMillis != Long.MAX_VALUE;
    }

    protected abstract boolean collectCameraInfo(@NonNull Facing var1);

    @NonNull
    protected abstract FrameManager instantiateFrameManager();

    public abstract void setZoom(float var1, @Nullable PointF[] var2, boolean var3);

    public abstract void setExposureCorrection(float var1, @NonNull float[] var2, @Nullable PointF[] var3, boolean var4);

    public abstract void setFlash(@NonNull Flash var1);

    public abstract void setWhiteBalance(@NonNull WhiteBalance var1);

    public abstract void setHdr(@NonNull Hdr var1);

    public abstract void setLocation(@Nullable Location var1);

    public abstract void startAutoFocus(@Nullable Gesture var1, @NonNull PointF var2);

    public abstract void setPlaySounds(boolean var1);

    public final boolean isTakingPicture() {
        return this.mPictureRecorder != null;
    }

    public void takePicture(final @NonNull PictureResult.Stub stub) {
        LOG.v("takePicture", "scheduling");
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                LOG.v("takePicture", "performing. BindState:", CameraEngine.this.getBindState(), "isTakingPicture:", CameraEngine.this.isTakingPicture());
                if (CameraEngine.this.mMode == Mode.VIDEO) {
                    throw new IllegalStateException("Can't take hq pictures while in VIDEO mode");
                }
                if (CameraEngine.this.getBindState() < 2) {
                    return;
                }
                if (CameraEngine.this.isTakingPicture()) {
                    return;
                }
                stub.isSnapshot = false;
                stub.location = CameraEngine.this.mLocation;
                stub.facing = CameraEngine.this.mFacing;
                CameraEngine.this.onTakePicture(stub);
            }
        });
    }

    public final void takePictureSnapshot(final @NonNull PictureResult.Stub stub) {
        LOG.v("takePictureSnapshot", "scheduling");
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                LOG.v("takePictureSnapshot", "performing. BindState:", CameraEngine.this.getBindState(), "isTakingPicture:", CameraEngine.this.isTakingPicture());
                if (CameraEngine.this.getBindState() < 2) {
                    return;
                }
                if (CameraEngine.this.isTakingPicture()) {
                    return;
                }
                stub.location = CameraEngine.this.mLocation;
                stub.isSnapshot = true;
                stub.facing = CameraEngine.this.mFacing;
                AspectRatio ratio = AspectRatio.of(CameraEngine.this.getPreviewSurfaceSize(Reference.OUTPUT));
                CameraEngine.this.onTakePictureSnapshot(stub, ratio);
            }
        });
    }

    @Override
    public void onPictureShutter(boolean didPlaySound) {
        this.mCallback.onShutter(!didPlaySound);
    }

    @Override
    public void onPictureResult(@Nullable PictureResult.Stub result, @Nullable Exception error) {
        this.mPictureRecorder = null;
        if (result != null) {
            this.mCallback.dispatchOnPictureTaken(result);
        } else {
            LOG.e("onPictureResult", "result is null: something went wrong.", error);
            this.mCallback.dispatchError(new CameraException(error, 4));
        }
    }

    public final boolean isTakingVideo() {
        return this.mVideoRecorder != null && this.mVideoRecorder.isRecording();
    }

    public final void takeVideo(final @NonNull VideoResult.Stub stub, final @NonNull File file) {
        LOG.v("takeVideo", "scheduling");
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                LOG.v("takeVideo", "performing. BindState:", CameraEngine.this.getBindState(), "isTakingVideo:", CameraEngine.this.isTakingVideo());
                if (CameraEngine.this.getBindState() < 2) {
                    return;
                }
                if (CameraEngine.this.isTakingVideo()) {
                    return;
                }
                if (CameraEngine.this.mMode == Mode.PICTURE) {
                    throw new IllegalStateException("Can't record video while in PICTURE mode");
                }
                stub.file = file;
                stub.isSnapshot = false;
                stub.videoCodec = CameraEngine.this.mVideoCodec;
                stub.location = CameraEngine.this.mLocation;
                stub.facing = CameraEngine.this.mFacing;
                stub.audio = CameraEngine.this.mAudio;
                stub.maxSize = CameraEngine.this.mVideoMaxSize;
                stub.maxDuration = CameraEngine.this.mVideoMaxDuration;
                stub.videoBitRate = CameraEngine.this.mVideoBitRate;
                stub.audioBitRate = CameraEngine.this.mAudioBitRate;
                CameraEngine.this.onTakeVideo(stub);
            }
        });
    }

    public final void takeVideoSnapshot(final @NonNull VideoResult.Stub stub, final @NonNull File file) {
        LOG.v("takeVideoSnapshot", "scheduling");
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                LOG.v("takeVideoSnapshot", "performing. BindState:", CameraEngine.this.getBindState(), "isTakingVideo:", CameraEngine.this.isTakingVideo());
                if (CameraEngine.this.getBindState() < 2) {
                    return;
                }
                if (CameraEngine.this.isTakingVideo()) {
                    return;
                }
                stub.file = file;
                stub.isSnapshot = true;
                stub.videoCodec = CameraEngine.this.mVideoCodec;
                stub.location = CameraEngine.this.mLocation;
                stub.facing = CameraEngine.this.mFacing;
                stub.videoBitRate = CameraEngine.this.mVideoBitRate;
                stub.audioBitRate = CameraEngine.this.mAudioBitRate;
                stub.audio = CameraEngine.this.mAudio;
                stub.maxSize = CameraEngine.this.mVideoMaxSize;
                stub.maxDuration = CameraEngine.this.mVideoMaxDuration;
                AspectRatio ratio = AspectRatio.of(CameraEngine.this.getPreviewSurfaceSize(Reference.OUTPUT));
                CameraEngine.this.onTakeVideoSnapshot(stub, ratio);
            }
        });
    }

    public final void stopVideo() {
        LOG.i("stopVideo", "posting");
        this.mHandler.run(new Runnable(){

            @Override
            public void run() {
                LOG.i("stopVideo", "executing.", "isTakingVideo?", CameraEngine.this.isTakingVideo());
                CameraEngine.this.onStopVideo();
            }
        });
    }

    protected void onStopVideo() {
        if (this.mVideoRecorder != null) {
            this.mVideoRecorder.stop(false);
            this.mVideoRecorder = null;
        }
    }

    @Override
    @CallSuper
    public void onVideoResult(@Nullable VideoResult.Stub result, @Nullable Exception exception) {
        this.mVideoRecorder = null;
        if (result != null) {
            this.mCallback.dispatchOnVideoTaken(result);
        } else {
            LOG.e("onVideoResult", "result is null: something went wrong.", exception);
            this.mCallback.dispatchError(new CameraException(exception, 5));
        }
    }

    @Override
    public void onVideoRecordingStart() {
        this.mCallback.dispatchOnVideoRecordingStart();
    }

    @Override
    public void onVideoRecordingEnd() {
        this.mCallback.dispatchOnVideoRecordingEnd();
    }

    @WorkerThread
    protected abstract void onTakePicture(@NonNull PictureResult.Stub var1);

    @WorkerThread
    protected abstract void onTakePictureSnapshot(@NonNull PictureResult.Stub var1, @NonNull AspectRatio var2);

    @WorkerThread
    protected abstract void onTakeVideoSnapshot(@NonNull VideoResult.Stub var1, @NonNull AspectRatio var2);

    @WorkerThread
    protected abstract void onTakeVideo(@NonNull VideoResult.Stub var1);

    @Nullable
    public final Size getPictureSize(@NonNull Reference reference) {
        Size size = this.mCaptureSize;
        if (size == null || this.mMode == Mode.VIDEO) {
            return null;
        }
        return this.getAngles().flip(Reference.SENSOR, reference) ? size.flip() : size;
    }

    @Nullable
    public final Size getVideoSize(@NonNull Reference reference) {
        Size size = this.mCaptureSize;
        if (size == null || this.mMode == Mode.PICTURE) {
            return null;
        }
        return this.getAngles().flip(Reference.SENSOR, reference) ? size.flip() : size;
    }

    @Nullable
    public final Size getPreviewStreamSize(@NonNull Reference reference) {
        Size size = this.mPreviewStreamSize;
        if (size == null) {
            return null;
        }
        return this.getAngles().flip(Reference.SENSOR, reference) ? size.flip() : size;
    }

    @Nullable
    private Size getPreviewSurfaceSize(@NonNull Reference reference) {
        CameraPreview preview = this.mPreview;
        if (preview == null) {
            return null;
        }
        return this.getAngles().flip(Reference.VIEW, reference) ? preview.getSurfaceSize().flip() : preview.getSurfaceSize();
    }

    @Nullable
    public final Size getUncroppedSnapshotSize(@NonNull Reference reference) {
        Size baseSize = this.getPreviewStreamSize(reference);
        if (baseSize == null) {
            return null;
        }
        boolean flip = this.getAngles().flip(reference, Reference.VIEW);
        int maxWidth = flip ? this.mSnapshotMaxHeight : this.mSnapshotMaxWidth;
        int maxHeight = flip ? this.mSnapshotMaxWidth : this.mSnapshotMaxHeight;
        float baseRatio = AspectRatio.of(baseSize).toFloat();
        float maxValuesRatio = AspectRatio.of(maxWidth, maxHeight).toFloat();
        if (maxValuesRatio >= baseRatio) {
            int outHeight = Math.min(baseSize.getHeight(), maxHeight);
            int outWidth = (int)Math.floor((float)outHeight * baseRatio);
            return new Size(outWidth, outHeight);
        }
        int outWidth = Math.min(baseSize.getWidth(), maxWidth);
        int outHeight = (int)Math.floor((float)outWidth / baseRatio);
        return new Size(outWidth, outHeight);
    }

    @NonNull
    protected final Size computeCaptureSize() {
        return this.computeCaptureSize(this.mMode);
    }

    protected final Size computeCaptureSize(@NonNull Mode mode) {
        Collection<Size> sizes;
        SizeSelector selector;
        boolean flip = this.getAngles().flip(Reference.SENSOR, Reference.VIEW);
        if (mode == Mode.PICTURE) {
            selector = this.mPictureSizeSelector;
            sizes = this.mCameraOptions.getSupportedPictureSizes();
        } else {
            selector = this.mVideoSizeSelector;
            sizes = this.mCameraOptions.getSupportedVideoSizes();
        }
        selector = SizeSelectors.or(selector, SizeSelectors.biggest());
        ArrayList<Size> list = new ArrayList<Size>(sizes);
        Size result = selector.select(list).get(0);
        if (!list.contains(result)) {
            throw new RuntimeException("SizeSelectors must not return Sizes other than those in the input list.");
        }
        LOG.i("computeCaptureSize:", "result:", result, "flip:", flip, "mode:", mode);
        if (flip) {
            result = result.flip();
        }
        return result;
    }

    @NonNull
    protected abstract List<Size> getPreviewStreamAvailableSizes();

    @NonNull
    protected final Size computePreviewStreamSize() {
        List<Size> previewSizes = this.getPreviewStreamAvailableSizes();
        boolean flip = this.getAngles().flip(Reference.SENSOR, Reference.VIEW);
        ArrayList<Size> sizes = new ArrayList<Size>(previewSizes.size());
        for (Size size : previewSizes) {
            sizes.add(flip ? size.flip() : size);
        }
        Size targetMinSize = this.getPreviewSurfaceSize(Reference.VIEW);
        if (targetMinSize == null) {
            throw new IllegalStateException("targetMinSize should not be null here.");
        }
        AspectRatio targetRatio = AspectRatio.of(this.mCaptureSize.getWidth(), this.mCaptureSize.getHeight());
        if (flip) {
            targetRatio = targetRatio.flip();
        }
        LOG.i("computePreviewStreamSize:", "targetRatio:", targetRatio, "targetMinSize:", targetMinSize);
        SizeSelector matchRatio = SizeSelectors.and(SizeSelectors.aspectRatio(targetRatio, 0.0f), SizeSelectors.biggest());
        SizeSelector matchSize = SizeSelectors.and(SizeSelectors.minHeight(targetMinSize.getHeight()), SizeSelectors.minWidth(targetMinSize.getWidth()), SizeSelectors.smallest());
        SizeSelector matchAll = SizeSelectors.or(SizeSelectors.and(matchRatio, matchSize), matchSize, matchRatio, SizeSelectors.biggest());
        SizeSelector selector = this.mPreviewStreamSizeSelector != null ? SizeSelectors.or(this.mPreviewStreamSizeSelector, matchAll) : matchAll;
        Size result = selector.select(sizes).get(0);
        if (!sizes.contains(result)) {
            throw new RuntimeException("SizeSelectors must not return Sizes other than those in the input list.");
        }
        if (flip) {
            result = result.flip();
        }
        LOG.i("computePreviewStreamSize:", "result:", result, "flip:", flip);
        return result;
    }

    private static class NoOpExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private NoOpExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread t, Throwable e) {
        }
    }

    private class CrashExceptionHandler
    implements Thread.UncaughtExceptionHandler {
        private CrashExceptionHandler() {
        }

        @Override
        public void uncaughtException(Thread thread, Throwable throwable) {
            CameraEngine.this.handleException(thread, throwable, true);
        }
    }

    public static interface Callback {
        @NonNull
        public Context getContext();

        public void dispatchOnCameraOpened(CameraOptions var1);

        public void dispatchOnCameraClosed();

        public void onCameraPreviewStreamSizeChanged();

        public void onShutter(boolean var1);

        public void dispatchOnVideoTaken(VideoResult.Stub var1);

        public void dispatchOnPictureTaken(PictureResult.Stub var1);

        public void dispatchOnFocusStart(@Nullable Gesture var1, @NonNull PointF var2);

        public void dispatchOnFocusEnd(@Nullable Gesture var1, boolean var2, @NonNull PointF var3);

        public void dispatchOnZoomChanged(float var1, @Nullable PointF[] var2);

        public void dispatchOnExposureCorrectionChanged(float var1, @NonNull float[] var2, @Nullable PointF[] var3);

        public void dispatchFrame(@NonNull Frame var1);

        public void dispatchError(CameraException var1);

        public void dispatchOnVideoRecordingStart();

        public void dispatchOnVideoRecordingEnd();
    }
}

