/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.annotation.TargetApi;
import android.content.Context;
import android.graphics.SurfaceTexture;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import com.otaliastudios.cameraview.CameraPreview;
import com.otaliastudios.cameraview.R;

class TextureCameraPreview
extends CameraPreview<TextureView, SurfaceTexture> {
    private Surface mSurface;

    TextureCameraPreview(Context context, ViewGroup parent, CameraPreview.SurfaceCallback callback) {
        super(context, parent, callback);
    }

    @Override
    @NonNull
    protected TextureView onCreateView(Context context, ViewGroup parent) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.texture_view, parent, false);
        parent.addView(root, 0);
        TextureView texture = (TextureView)root.findViewById(R.id.texture_view);
        texture.setSurfaceTextureListener(new TextureView.SurfaceTextureListener(){

            public void onSurfaceTextureAvailable(SurfaceTexture surface, int width, int height) {
                TextureCameraPreview.this.onSurfaceAvailable(width, height);
            }

            public void onSurfaceTextureSizeChanged(SurfaceTexture surface, int width, int height) {
                TextureCameraPreview.this.onSurfaceSizeChanged(width, height);
            }

            public boolean onSurfaceTextureDestroyed(SurfaceTexture surface) {
                TextureCameraPreview.this.onSurfaceDestroyed();
                return true;
            }

            public void onSurfaceTextureUpdated(SurfaceTexture surface) {
            }
        });
        return texture;
    }

    @Override
    Surface getSurface() {
        if (this.mSurface == null) {
            this.mSurface = new Surface(this.getOutput());
        }
        return this.mSurface;
    }

    @Override
    Class<SurfaceTexture> getOutputClass() {
        return SurfaceTexture.class;
    }

    @Override
    SurfaceTexture getOutput() {
        return ((TextureView)this.getView()).getSurfaceTexture();
    }

    @Override
    @TargetApi(value=15)
    void setDesiredSize(int width, int height) {
        super.setDesiredSize(width, height);
        if (((TextureView)this.getView()).getSurfaceTexture() != null) {
            ((TextureView)this.getView()).getSurfaceTexture().setDefaultBufferSize(width, height);
        }
    }
}

