/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.support.annotation.NonNull;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;

class Task<T> {
    private CountDownLatch mLatch;
    private T mResult;
    private int mCount;

    Task() {
    }

    private boolean listening() {
        return this.mLatch != null;
    }

    void listen() {
        if (this.listening()) {
            throw new RuntimeException("Should not happen.");
        }
        this.mResult = null;
        this.mLatch = new CountDownLatch(1);
    }

    void start() {
        if (!this.listening()) {
            ++this.mCount;
        }
    }

    void end(T result) {
        if (this.mCount > 0) {
            --this.mCount;
            return;
        }
        if (this.listening()) {
            this.mResult = result;
            this.mLatch.countDown();
        }
    }

    T await(long millis) {
        return this.await(millis, TimeUnit.MILLISECONDS);
    }

    T await() {
        return this.await(1L, TimeUnit.MINUTES);
    }

    private T await(long time, @NonNull TimeUnit unit) {
        try {
            this.mLatch.await(time, unit);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        T result = this.mResult;
        this.mResult = null;
        this.mLatch = null;
        return result;
    }
}

