/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.LayoutInflater;
import android.view.Surface;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.ViewGroup;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraPreview;
import com.otaliastudios.cameraview.R;

class SurfaceCameraPreview
extends CameraPreview<View, SurfaceHolder> {
    private static final CameraLogger LOG = CameraLogger.create(SurfaceCameraPreview.class.getSimpleName());
    private SurfaceView mSurfaceView;

    SurfaceCameraPreview(Context context, ViewGroup parent, CameraPreview.SurfaceCallback callback) {
        super(context, parent, callback);
    }

    @Override
    @NonNull
    protected View onCreateView(Context context, ViewGroup parent) {
        View root = LayoutInflater.from((Context)context).inflate(R.layout.surface_view, parent, false);
        parent.addView(root, 0);
        this.mSurfaceView = (SurfaceView)root.findViewById(R.id.surface_view);
        SurfaceHolder holder = this.mSurfaceView.getHolder();
        holder.setType(3);
        holder.addCallback(new SurfaceHolder.Callback(){
            private boolean mFirstTime = true;

            public void surfaceCreated(SurfaceHolder holder) {
                LOG.i("callback:", "surfaceCreated");
            }

            public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
                LOG.i("callback:", "surfaceChanged", "w:", width, "h:", height, "firstTime:", this.mFirstTime);
                if (this.mFirstTime) {
                    SurfaceCameraPreview.this.onSurfaceAvailable(width, height);
                    this.mFirstTime = false;
                } else {
                    SurfaceCameraPreview.this.onSurfaceSizeChanged(width, height);
                }
            }

            public void surfaceDestroyed(SurfaceHolder holder) {
                LOG.i("callback:", "surfaceDestroyed");
                SurfaceCameraPreview.this.onSurfaceDestroyed();
                this.mFirstTime = true;
            }
        });
        return root.findViewById(R.id.surface_view_root);
    }

    @Override
    Surface getSurface() {
        return this.getOutput().getSurface();
    }

    @Override
    SurfaceHolder getOutput() {
        return this.mSurfaceView.getHolder();
    }

    @Override
    Class<SurfaceHolder> getOutputClass() {
        return SurfaceHolder.class;
    }

    @Override
    boolean supportsCropping() {
        return false;
    }

    @Override
    protected void applyCrop(float scaleX, float scaleY) {
    }
}

