/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.os.Build;
import com.otaliastudios.cameraview.Facing;
import com.otaliastudios.cameraview.Flash;
import com.otaliastudios.cameraview.Hdr;
import com.otaliastudios.cameraview.WhiteBalance;
import java.util.HashMap;

abstract class Mapper {
    Mapper() {
    }

    abstract <T> T map(Flash var1);

    abstract <T> T map(Facing var1);

    abstract <T> T map(WhiteBalance var1);

    abstract <T> T map(Hdr var1);

    abstract <T> Flash unmapFlash(T var1);

    abstract <T> Facing unmapFacing(T var1);

    abstract <T> WhiteBalance unmapWhiteBalance(T var1);

    abstract <T> Hdr unmapHdr(T var1);

    static class Mapper2
    extends Mapper {
        Mapper2() {
        }

        @Override
        <T> T map(WhiteBalance whiteBalance) {
            return null;
        }

        @Override
        <T> T map(Flash flash) {
            return null;
        }

        @Override
        <T> Flash unmapFlash(T cameraConstant) {
            return null;
        }

        @Override
        <T> WhiteBalance unmapWhiteBalance(T cameraConstant) {
            return null;
        }

        @Override
        <T> T map(Facing facing) {
            return null;
        }

        @Override
        <T> Facing unmapFacing(T cameraConstant) {
            return null;
        }

        @Override
        <T> T map(Hdr hdr) {
            return null;
        }

        @Override
        <T> Hdr unmapHdr(T cameraConstant) {
            return null;
        }
    }

    static class Mapper1
    extends Mapper {
        private static final HashMap<Flash, String> FLASH = new HashMap();
        private static final HashMap<WhiteBalance, String> WB = new HashMap();
        private static final HashMap<Facing, Integer> FACING = new HashMap();
        private static final HashMap<Hdr, String> HDR = new HashMap();

        Mapper1() {
        }

        @Override
        <T> T map(Flash flash) {
            return (T)FLASH.get((Object)flash);
        }

        @Override
        <T> T map(Facing facing) {
            return (T)FACING.get((Object)facing);
        }

        @Override
        <T> T map(WhiteBalance whiteBalance) {
            return (T)WB.get((Object)whiteBalance);
        }

        @Override
        <T> T map(Hdr hdr) {
            return (T)HDR.get((Object)hdr);
        }

        private <T> T reverseLookup(HashMap<T, ?> map, Object object) {
            for (T value : map.keySet()) {
                if (!map.get(value).equals(object)) continue;
                return value;
            }
            return null;
        }

        @Override
        <T> Flash unmapFlash(T cameraConstant) {
            return this.reverseLookup(FLASH, cameraConstant);
        }

        @Override
        <T> Facing unmapFacing(T cameraConstant) {
            return this.reverseLookup(FACING, cameraConstant);
        }

        @Override
        <T> WhiteBalance unmapWhiteBalance(T cameraConstant) {
            return this.reverseLookup(WB, cameraConstant);
        }

        @Override
        <T> Hdr unmapHdr(T cameraConstant) {
            return this.reverseLookup(HDR, cameraConstant);
        }

        static {
            FLASH.put(Flash.OFF, "off");
            FLASH.put(Flash.ON, "on");
            FLASH.put(Flash.AUTO, "auto");
            FLASH.put(Flash.TORCH, "torch");
            FACING.put(Facing.BACK, 0);
            FACING.put(Facing.FRONT, 1);
            WB.put(WhiteBalance.AUTO, "auto");
            WB.put(WhiteBalance.INCANDESCENT, "incandescent");
            WB.put(WhiteBalance.FLUORESCENT, "fluorescent");
            WB.put(WhiteBalance.DAYLIGHT, "daylight");
            WB.put(WhiteBalance.CLOUDY, "cloudy-daylight");
            HDR.put(Hdr.OFF, "auto");
            if (Build.VERSION.SDK_INT >= 17) {
                HDR.put(Hdr.ON, "hdr");
            } else {
                HDR.put(Hdr.ON, "hdr");
            }
        }
    }
}

