/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.TypedArray;
import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.YuvImage;
import android.location.Location;
import android.media.MediaActionSound;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import com.otaliastudios.cameraview.AspectRatio;
import com.otaliastudios.cameraview.Audio;
import com.otaliastudios.cameraview.Camera1;
import com.otaliastudios.cameraview.CameraController;
import com.otaliastudios.cameraview.CameraListener;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.CameraPreview;
import com.otaliastudios.cameraview.CropHelper;
import com.otaliastudios.cameraview.ExtraProperties;
import com.otaliastudios.cameraview.Facing;
import com.otaliastudios.cameraview.Flash;
import com.otaliastudios.cameraview.Gesture;
import com.otaliastudios.cameraview.GestureAction;
import com.otaliastudios.cameraview.GestureLayout;
import com.otaliastudios.cameraview.Grid;
import com.otaliastudios.cameraview.GridLinesLayout;
import com.otaliastudios.cameraview.Hdr;
import com.otaliastudios.cameraview.OrientationHelper;
import com.otaliastudios.cameraview.PinchGestureLayout;
import com.otaliastudios.cameraview.R;
import com.otaliastudios.cameraview.ScrollGestureLayout;
import com.otaliastudios.cameraview.SessionType;
import com.otaliastudios.cameraview.Size;
import com.otaliastudios.cameraview.SurfaceCameraPreview;
import com.otaliastudios.cameraview.TapGestureLayout;
import com.otaliastudios.cameraview.TextureCameraPreview;
import com.otaliastudios.cameraview.VideoQuality;
import com.otaliastudios.cameraview.WhiteBalance;
import com.otaliastudios.cameraview.WorkerHandler;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;

public class CameraView
extends FrameLayout {
    private static final String TAG = CameraView.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    public static final int PERMISSION_REQUEST_CODE = 16;
    static final int DEFAULT_JPEG_QUALITY = 100;
    static final boolean DEFAULT_CROP_OUTPUT = false;
    static final boolean DEFAULT_PLAY_SOUNDS = true;
    private int mJpegQuality;
    private boolean mCropOutput;
    private float mZoomValue;
    private float mExposureCorrectionValue;
    private boolean mPlaySounds;
    private HashMap<Gesture, GestureAction> mGestureMap = new HashMap(4);
    CameraCallbacks mCameraCallbacks;
    private CameraPreview mCameraPreview;
    private OrientationHelper mOrientationHelper;
    private CameraController mCameraController;
    private ArrayList<CameraListener> mListeners = new ArrayList(2);
    private MediaActionSound mSound;
    GridLinesLayout mGridLinesLayout;
    PinchGestureLayout mPinchGestureLayout;
    TapGestureLayout mTapGestureLayout;
    ScrollGestureLayout mScrollGestureLayout;
    private boolean mKeepScreenOn;
    private Handler mUiHandler;
    private WorkerHandler mWorkerHandler;

    public CameraView(@NonNull Context context) {
        super(context, null);
        this.init(context, null);
    }

    public CameraView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init(context, attrs);
    }

    private void init(@NonNull Context context, @Nullable AttributeSet attrs) {
        this.setWillNotDraw(false);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.CameraView, 0, 0);
        int jpegQuality = a.getInteger(R.styleable.CameraView_cameraJpegQuality, 100);
        boolean cropOutput = a.getBoolean(R.styleable.CameraView_cameraCropOutput, false);
        boolean playSounds = a.getBoolean(R.styleable.CameraView_cameraPlaySounds, true);
        Facing facing = Facing.fromValue(a.getInteger(R.styleable.CameraView_cameraFacing, Facing.DEFAULT.value()));
        Flash flash = Flash.fromValue(a.getInteger(R.styleable.CameraView_cameraFlash, Flash.DEFAULT.value()));
        Grid grid = Grid.fromValue(a.getInteger(R.styleable.CameraView_cameraGrid, Grid.DEFAULT.value()));
        WhiteBalance whiteBalance = WhiteBalance.fromValue(a.getInteger(R.styleable.CameraView_cameraWhiteBalance, WhiteBalance.DEFAULT.value()));
        VideoQuality videoQuality = VideoQuality.fromValue(a.getInteger(R.styleable.CameraView_cameraVideoQuality, VideoQuality.DEFAULT.value()));
        SessionType sessionType = SessionType.fromValue(a.getInteger(R.styleable.CameraView_cameraSessionType, SessionType.DEFAULT.value()));
        Hdr hdr = Hdr.fromValue(a.getInteger(R.styleable.CameraView_cameraHdr, Hdr.DEFAULT.value()));
        Audio audio = Audio.fromValue(a.getInteger(R.styleable.CameraView_cameraAudio, Audio.DEFAULT.value()));
        GestureAction tapGesture = GestureAction.fromValue(a.getInteger(R.styleable.CameraView_cameraGestureTap, GestureAction.DEFAULT_TAP.value()));
        GestureAction longTapGesture = GestureAction.fromValue(a.getInteger(R.styleable.CameraView_cameraGestureLongTap, GestureAction.DEFAULT_LONG_TAP.value()));
        GestureAction pinchGesture = GestureAction.fromValue(a.getInteger(R.styleable.CameraView_cameraGesturePinch, GestureAction.DEFAULT_PINCH.value()));
        GestureAction scrollHorizontalGesture = GestureAction.fromValue(a.getInteger(R.styleable.CameraView_cameraGestureScrollHorizontal, GestureAction.DEFAULT_SCROLL_HORIZONTAL.value()));
        GestureAction scrollVerticalGesture = GestureAction.fromValue(a.getInteger(R.styleable.CameraView_cameraGestureScrollVertical, GestureAction.DEFAULT_SCROLL_VERTICAL.value()));
        a.recycle();
        this.mCameraCallbacks = new Callbacks();
        this.mCameraController = this.instantiateCameraController(this.mCameraCallbacks);
        this.mUiHandler = new Handler(Looper.getMainLooper());
        this.mWorkerHandler = WorkerHandler.get("CameraViewWorker");
        this.mGridLinesLayout = new GridLinesLayout(context);
        this.mPinchGestureLayout = new PinchGestureLayout(context);
        this.mTapGestureLayout = new TapGestureLayout(context);
        this.mScrollGestureLayout = new ScrollGestureLayout(context);
        this.addView(this.mGridLinesLayout);
        this.addView((View)this.mPinchGestureLayout);
        this.addView((View)this.mTapGestureLayout);
        this.addView((View)this.mScrollGestureLayout);
        this.setCropOutput(cropOutput);
        this.setJpegQuality(jpegQuality);
        this.setPlaySounds(playSounds);
        this.setFacing(facing);
        this.setFlash(flash);
        this.setSessionType(sessionType);
        this.setVideoQuality(videoQuality);
        this.setWhiteBalance(whiteBalance);
        this.setGrid(grid);
        this.setHdr(hdr);
        this.setAudio(audio);
        this.mapGesture(Gesture.TAP, tapGesture);
        this.mapGesture(Gesture.LONG_TAP, longTapGesture);
        this.mapGesture(Gesture.PINCH, pinchGesture);
        this.mapGesture(Gesture.SCROLL_HORIZONTAL, scrollHorizontalGesture);
        this.mapGesture(Gesture.SCROLL_VERTICAL, scrollVerticalGesture);
        if (!this.isInEditMode()) {
            this.mOrientationHelper = new OrientationHelper(context, this.mCameraCallbacks);
        }
    }

    protected CameraController instantiateCameraController(CameraCallbacks callbacks) {
        return new Camera1(callbacks);
    }

    protected CameraPreview instantiatePreview(Context context, ViewGroup container) {
        LOG.w("preview:", "isHardwareAccelerated:", this.isHardwareAccelerated());
        return this.isHardwareAccelerated() ? new TextureCameraPreview(context, container, null) : new SurfaceCameraPreview(context, container, null);
    }

    void instantiatePreview() {
        this.mCameraPreview = this.instantiatePreview(this.getContext(), (ViewGroup)this);
        this.mCameraController.setPreview(this.mCameraPreview);
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (this.mCameraPreview == null) {
            this.instantiatePreview();
        }
        if (!this.isInEditMode()) {
            this.mOrientationHelper.enable(this.getContext());
        }
    }

    protected void onDetachedFromWindow() {
        if (!this.isInEditMode()) {
            this.mOrientationHelper.disable();
        }
        super.onDetachedFromWindow();
    }

    private String ms(int mode) {
        switch (mode) {
            case -2147483648: {
                return "AT_MOST";
            }
            case 0x40000000: {
                return "EXACTLY";
            }
            case 0: {
                return "UNSPECIFIED";
            }
        }
        return null;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int height;
        int width;
        Size previewSize = this.getPreviewSize();
        if (previewSize == null) {
            LOG.w("onMeasure:", "surface is not ready. Calling default behavior.");
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
        int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
        int widthValue = View.MeasureSpec.getSize((int)widthMeasureSpec);
        int heightValue = View.MeasureSpec.getSize((int)heightMeasureSpec);
        boolean flip = this.mCameraController.shouldFlipSizes();
        float previewWidth = flip ? (float)previewSize.getHeight() : (float)previewSize.getWidth();
        float previewHeight = flip ? (float)previewSize.getWidth() : (float)previewSize.getHeight();
        ViewGroup.LayoutParams lp = this.getLayoutParams();
        if (!this.mCameraPreview.supportsCropping()) {
            if (widthMode == 0x40000000) {
                widthMode = Integer.MIN_VALUE;
            }
            if (heightMode == 0x40000000) {
                heightMode = Integer.MIN_VALUE;
            }
        } else {
            if (widthMode == Integer.MIN_VALUE && lp.width == -1) {
                widthMode = 0x40000000;
            }
            if (heightMode == Integer.MIN_VALUE && lp.height == -1) {
                heightMode = 0x40000000;
            }
        }
        LOG.i("onMeasure:", "requested dimensions are", "(" + widthValue + "[" + this.ms(widthMode) + "]x" + heightValue + "[" + this.ms(heightMode) + "])");
        LOG.i("onMeasure:", "previewSize is", "(" + previewWidth + "x" + previewHeight + ")");
        if (widthMode == 0x40000000 && heightMode == 0x40000000) {
            LOG.w("onMeasure:", "both are MATCH_PARENT or fixed value. We adapt.", "This means CROP_CENTER.", "(" + widthValue + "x" + heightValue + ")");
            super.onMeasure(widthMeasureSpec, heightMeasureSpec);
            return;
        }
        if (widthMode == 0 && heightMode == 0) {
            LOG.i("onMeasure:", "both are completely free.", "We respect that and extend to the whole preview size.", "(" + previewWidth + "x" + previewHeight + ")");
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)((int)previewWidth), (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)((int)previewHeight), (int)0x40000000));
            return;
        }
        float ratio = previewHeight / previewWidth;
        if (widthMode == 0 || heightMode == 0) {
            int width2;
            int height2;
            boolean freeWidth;
            boolean bl = freeWidth = widthMode == 0;
            if (freeWidth) {
                height2 = heightValue;
                width2 = (int)((float)height2 / ratio);
            } else {
                width2 = widthValue;
                height2 = (int)((float)width2 * ratio);
            }
            LOG.i("onMeasure:", "one dimension was free, we adapted it to fit the aspect ratio.", "(" + width2 + "x" + height2 + ")");
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width2, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height2, (int)0x40000000));
            return;
        }
        if (widthMode == 0x40000000 || heightMode == 0x40000000) {
            int width3;
            int height3;
            boolean freeWidth;
            boolean bl = freeWidth = widthMode == Integer.MIN_VALUE;
            if (freeWidth) {
                height3 = heightValue;
                width3 = Math.min((int)((float)height3 / ratio), widthValue);
            } else {
                width3 = widthValue;
                height3 = Math.min((int)((float)width3 * ratio), heightValue);
            }
            LOG.i("onMeasure:", "one dimension was EXACTLY, another AT_MOST.", "We have TRIED to fit the aspect ratio, but it's not guaranteed.", "(" + width3 + "x" + height3 + ")");
            super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width3, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height3, (int)0x40000000));
            return;
        }
        float atMostRatio = (float)heightValue / (float)widthValue;
        if (atMostRatio >= ratio) {
            width = widthValue;
            height = (int)((float)width * ratio);
        } else {
            height = heightValue;
            width = (int)((float)height / ratio);
        }
        LOG.i("onMeasure:", "both dimension were AT_MOST.", "We fit the preview aspect ratio.", "(" + width + "x" + height + ")");
        super.onMeasure(View.MeasureSpec.makeMeasureSpec((int)width, (int)0x40000000), View.MeasureSpec.makeMeasureSpec((int)height, (int)0x40000000));
    }

    public boolean mapGesture(@NonNull Gesture gesture, GestureAction action) {
        GestureAction none = GestureAction.NONE;
        if (gesture.isAssignableTo(action)) {
            this.mGestureMap.put(gesture, action);
            switch (gesture) {
                case PINCH: {
                    this.mPinchGestureLayout.enable(this.mGestureMap.get((Object)Gesture.PINCH) != none);
                    break;
                }
                case TAP: 
                case LONG_TAP: {
                    this.mTapGestureLayout.enable(this.mGestureMap.get((Object)Gesture.TAP) != none || this.mGestureMap.get((Object)Gesture.LONG_TAP) != none);
                    break;
                }
                case SCROLL_HORIZONTAL: 
                case SCROLL_VERTICAL: {
                    this.mScrollGestureLayout.enable(this.mGestureMap.get((Object)Gesture.SCROLL_HORIZONTAL) != none || this.mGestureMap.get((Object)Gesture.SCROLL_VERTICAL) != none);
                }
            }
            return true;
        }
        this.mapGesture(gesture, none);
        return false;
    }

    public void clearGesture(@NonNull Gesture gesture) {
        this.mapGesture(gesture, GestureAction.NONE);
    }

    public GestureAction getGestureAction(@NonNull Gesture gesture) {
        return this.mGestureMap.get((Object)gesture);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        return true;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isStarted()) {
            return true;
        }
        CameraOptions options = this.mCameraController.getCameraOptions();
        if (this.mPinchGestureLayout.onTouchEvent(event)) {
            LOG.i("onTouchEvent", "pinch!");
            this.onGesture(this.mPinchGestureLayout, options);
        } else if (this.mScrollGestureLayout.onTouchEvent(event)) {
            LOG.i("onTouchEvent", "scroll!");
            this.onGesture(this.mScrollGestureLayout, options);
        } else if (this.mTapGestureLayout.onTouchEvent(event)) {
            LOG.i("onTouchEvent", "tap!");
            this.onGesture(this.mTapGestureLayout, options);
        }
        return true;
    }

    private boolean onGesture(GestureLayout source, @NonNull CameraOptions options) {
        Gesture gesture = source.getGestureType();
        GestureAction action = this.mGestureMap.get((Object)gesture);
        PointF[] points = source.getPoints();
        switch (action) {
            case CAPTURE: {
                return this.mCameraController.capturePicture();
            }
            case FOCUS: 
            case FOCUS_WITH_MARKER: {
                return this.mCameraController.startAutoFocus(gesture, points[0]);
            }
            case ZOOM: {
                float oldValue = this.mZoomValue;
                float newValue = source.scaleValue(oldValue, 0.0f, 1.0f);
                if (!this.mCameraController.setZoom(newValue)) break;
                this.mZoomValue = newValue;
                this.mCameraCallbacks.dispatchOnZoomChanged(newValue, points);
                return true;
            }
            case EXPOSURE_CORRECTION: {
                float oldValue = this.mExposureCorrectionValue;
                float minValue = options.getExposureCorrectionMinValue();
                float maxValue = options.getExposureCorrectionMaxValue();
                float newValue = source.scaleValue(oldValue, minValue, maxValue);
                float[] bounds = new float[]{minValue, maxValue};
                if (!this.mCameraController.setExposureCorrection(newValue)) break;
                this.mExposureCorrectionValue = newValue;
                this.mCameraCallbacks.dispatchOnExposureCorrectionChanged(newValue, bounds, points);
                return true;
            }
        }
        return false;
    }

    public boolean isStarted() {
        return this.mCameraController.getState() >= 2;
    }

    private boolean isStopped() {
        return this.mCameraController.getState() == 0;
    }

    public void start() {
        if (!this.isEnabled()) {
            return;
        }
        if (this.checkPermissions(this.getSessionType(), this.getAudio())) {
            this.mOrientationHelper.enable(this.getContext());
            this.mCameraController.start();
        }
    }

    @SuppressLint(value={"NewApi"})
    protected boolean checkPermissions(SessionType sessionType, Audio audio) {
        this.checkPermissionsManifestOrThrow(sessionType, audio);
        if (Build.VERSION.SDK_INT < 23) {
            return true;
        }
        Context c = this.getContext();
        boolean needsCamera = true;
        boolean needsAudio = sessionType == SessionType.VIDEO && audio == Audio.ON;
        needsCamera = needsCamera && c.checkSelfPermission("android.permission.CAMERA") != 0;
        boolean bl = needsAudio = needsAudio && c.checkSelfPermission("android.permission.RECORD_AUDIO") != 0;
        if (needsCamera || needsAudio) {
            this.requestPermissions(needsCamera, needsAudio);
            return false;
        }
        return true;
    }

    private void checkPermissionsManifestOrThrow(SessionType sessionType, Audio audio) {
        if (sessionType == SessionType.VIDEO && audio == Audio.ON) {
            try {
                PackageManager manager = this.getContext().getPackageManager();
                PackageInfo info = manager.getPackageInfo(this.getContext().getPackageName(), 4096);
                for (String requestedPermission : info.requestedPermissions) {
                    if (!requestedPermission.equals("android.permission.RECORD_AUDIO")) continue;
                    return;
                }
                LOG.e("Permission error:", "When the session type is set to video,", "the RECORD_AUDIO permission should be added to the app manifest file.");
                throw new IllegalStateException(CameraLogger.lastMessage);
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                // empty catch block
            }
        }
    }

    public void stop() {
        this.mCameraController.stop();
    }

    public void destroy() {
        this.clearCameraListeners();
        this.mCameraController.stopImmediately();
    }

    @Nullable
    public CameraOptions getCameraOptions() {
        return this.mCameraController.getCameraOptions();
    }

    @Nullable
    public ExtraProperties getExtraProperties() {
        return this.mCameraController.getExtraProperties();
    }

    public void setExposureCorrection(float EVvalue) {
        CameraOptions options = this.getCameraOptions();
        if (options != null) {
            float min = options.getExposureCorrectionMinValue();
            float max = options.getExposureCorrectionMaxValue();
            if (EVvalue < min) {
                EVvalue = min;
            }
            if (EVvalue > max) {
                EVvalue = max;
            }
            if (this.mCameraController.setExposureCorrection(EVvalue)) {
                this.mExposureCorrectionValue = EVvalue;
            }
        }
    }

    public float getExposureCorrection() {
        return this.mExposureCorrectionValue;
    }

    public void setZoom(float zoom) {
        if (zoom < 0.0f) {
            zoom = 0.0f;
        }
        if (zoom > 1.0f) {
            zoom = 1.0f;
        }
        if (this.mCameraController.setZoom(zoom)) {
            this.mZoomValue = zoom;
        }
    }

    public float getZoom() {
        return this.mZoomValue;
    }

    public void setGrid(Grid gridMode) {
        this.mGridLinesLayout.setGridMode(gridMode);
    }

    public Grid getGrid() {
        return this.mGridLinesLayout.getGridMode();
    }

    public void setHdr(Hdr hdr) {
        this.mCameraController.setHdr(hdr);
    }

    public Hdr getHdr() {
        return this.mCameraController.getHdr();
    }

    public void setLocation(double latitude, double longitude) {
        Location location = new Location("Unknown");
        location.setTime(System.currentTimeMillis());
        location.setAltitude(0.0);
        location.setLatitude(latitude);
        location.setLongitude(longitude);
        this.mCameraController.setLocation(location);
    }

    public void setLocation(Location location) {
        this.mCameraController.setLocation(location);
    }

    @Nullable
    public Location getLocation() {
        return this.mCameraController.getLocation();
    }

    public void setWhiteBalance(WhiteBalance whiteBalance) {
        this.mCameraController.setWhiteBalance(whiteBalance);
    }

    public WhiteBalance getWhiteBalance() {
        return this.mCameraController.getWhiteBalance();
    }

    public void setFacing(Facing facing) {
        this.mCameraController.setFacing(facing);
    }

    public Facing getFacing() {
        return this.mCameraController.getFacing();
    }

    public Facing toggleFacing() {
        Facing facing = this.mCameraController.getFacing();
        switch (facing) {
            case BACK: {
                this.setFacing(Facing.FRONT);
                break;
            }
            case FRONT: {
                this.setFacing(Facing.BACK);
            }
        }
        return this.mCameraController.getFacing();
    }

    public void setFlash(Flash flash) {
        this.mCameraController.setFlash(flash);
    }

    public Flash getFlash() {
        return this.mCameraController.getFlash();
    }

    public Flash toggleFlash() {
        Flash flash = this.mCameraController.getFlash();
        switch (flash) {
            case OFF: {
                this.setFlash(Flash.ON);
                break;
            }
            case ON: {
                this.setFlash(Flash.AUTO);
                break;
            }
            case AUTO: 
            case TORCH: {
                this.setFlash(Flash.OFF);
            }
        }
        return this.mCameraController.getFlash();
    }

    public void setAudio(Audio audio) {
        if (audio == this.getAudio() || this.isStopped()) {
            this.mCameraController.setAudio(audio);
        } else if (this.checkPermissions(this.getSessionType(), audio)) {
            this.mCameraController.setAudio(audio);
        } else {
            this.stop();
        }
    }

    public Audio getAudio() {
        return this.mCameraController.getAudio();
    }

    public void startAutoFocus(float x, float y) {
        if (x < 0.0f || x > (float)this.getWidth()) {
            throw new IllegalArgumentException("x should be >= 0 and <= getWidth()");
        }
        if (y < 0.0f || y > (float)this.getHeight()) {
            throw new IllegalArgumentException("y should be >= 0 and <= getHeight()");
        }
        this.mCameraController.startAutoFocus(null, new PointF(x, y));
    }

    public void setSessionType(SessionType sessionType) {
        if (sessionType == this.getSessionType() || this.isStopped()) {
            this.mCameraController.setSessionType(sessionType);
        } else if (this.checkPermissions(sessionType, this.getAudio())) {
            this.mCameraController.setSessionType(sessionType);
        } else {
            this.stop();
        }
    }

    public SessionType getSessionType() {
        return this.mCameraController.getSessionType();
    }

    public void setVideoQuality(VideoQuality videoQuality) {
        this.mCameraController.setVideoQuality(videoQuality);
    }

    public VideoQuality getVideoQuality() {
        return this.mCameraController.getVideoQuality();
    }

    public void setJpegQuality(int jpegQuality) {
        if (jpegQuality <= 0 || jpegQuality > 100) {
            throw new IllegalArgumentException("JPEG quality should be > 0 and <= 100");
        }
        this.mJpegQuality = jpegQuality;
    }

    public int getJpegQuality() {
        return this.mJpegQuality;
    }

    public void setCropOutput(boolean cropOutput) {
        this.mCropOutput = cropOutput;
    }

    public boolean getCropOutput() {
        return this.mCropOutput;
    }

    @Deprecated
    public void setCameraListener(CameraListener cameraListener) {
        this.mListeners.clear();
        this.addCameraListener(cameraListener);
    }

    public void addCameraListener(CameraListener cameraListener) {
        if (cameraListener != null) {
            this.mListeners.add(cameraListener);
        }
    }

    public void removeCameraListener(CameraListener cameraListener) {
        if (cameraListener != null) {
            this.mListeners.remove(cameraListener);
        }
    }

    public void clearCameraListeners() {
        this.mListeners.clear();
    }

    public void capturePicture() {
        if (!this.mCameraController.capturePicture() || this.mPlaySounds) {
            // empty if block
        }
    }

    public void captureSnapshot() {
        if (this.mCameraController.captureSnapshot() && this.mPlaySounds) {
            this.playSound(0);
        }
    }

    @Deprecated
    public void startCapturingVideo() {
        this.startCapturingVideo(null);
    }

    public void startCapturingVideo(File file) {
        if (file == null) {
            file = new File(this.getContext().getFilesDir(), "video.mp4");
        }
        if (this.mCameraController.startVideo(file)) {
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    CameraView.this.mKeepScreenOn = CameraView.this.getKeepScreenOn();
                    if (!CameraView.this.mKeepScreenOn) {
                        CameraView.this.setKeepScreenOn(true);
                    }
                }
            });
        }
    }

    public void startCapturingVideo(File file, long durationMillis) {
        if (durationMillis < 500L) {
            throw new IllegalArgumentException("Video duration can't be < 500 milliseconds");
        }
        this.startCapturingVideo(file);
        this.mUiHandler.postDelayed(new Runnable(){

            @Override
            public void run() {
                CameraView.this.stopCapturingVideo();
            }
        }, durationMillis);
    }

    public void stopCapturingVideo() {
        if (this.mCameraController.endVideo()) {
            this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (CameraView.this.getKeepScreenOn() != CameraView.this.mKeepScreenOn) {
                        CameraView.this.setKeepScreenOn(CameraView.this.mKeepScreenOn);
                    }
                }
            });
        }
    }

    @Nullable
    public Size getPreviewSize() {
        return this.mCameraController != null ? this.mCameraController.getPreviewSize() : null;
    }

    @Nullable
    public Size getCaptureSize() {
        return this.mCameraController != null ? this.mCameraController.getCaptureSize() : null;
    }

    @Nullable
    public Size getSnapshotSize() {
        return this.getPreviewSize();
    }

    @TargetApi(value=23)
    private void requestPermissions(boolean requestCamera, boolean requestAudio) {
        Activity activity = null;
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                activity = (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        ArrayList<String> permissions = new ArrayList<String>();
        if (requestCamera) {
            permissions.add("android.permission.CAMERA");
        }
        if (requestAudio) {
            permissions.add("android.permission.RECORD_AUDIO");
        }
        if (activity != null) {
            activity.requestPermissions(permissions.toArray(new String[permissions.size()]), 16);
        }
    }

    @SuppressLint(value={"NewApi"})
    private void playSound(int soundType) {
        if (this.mPlaySounds) {
            if (this.mSound == null) {
                this.mSound = new MediaActionSound();
            }
            this.mSound.play(soundType);
        }
    }

    public void setPlaySounds(boolean playSounds) {
        this.mPlaySounds = playSounds && Build.VERSION.SDK_INT >= 16;
    }

    public boolean getPlaySounds() {
        return this.mPlaySounds;
    }

    @Deprecated
    public void setFocus(int focus) {
    }

    @Deprecated
    public int getFocus() {
        return 0;
    }

    @Deprecated
    public void setCaptureMethod(int method) {
    }

    @Deprecated
    public void setPermissionPolicy(int permissions) {
    }

    @Deprecated
    public void setZoomMode(int zoom) {
    }

    @Deprecated
    public int getZoomMode() {
        return 0;
    }

    private class Callbacks
    implements CameraCallbacks {
        private CameraLogger mLogger = CameraLogger.create(CameraCallbacks.class.getSimpleName());
        private Integer mDisplayOffset;
        private Integer mDeviceOrientation;

        Callbacks() {
        }

        @Override
        public void dispatchOnCameraOpened(final CameraOptions options) {
            this.mLogger.i("dispatchOnCameraOpened", options);
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onCameraOpened(options);
                    }
                }
            });
        }

        @Override
        public void dispatchOnCameraClosed() {
            this.mLogger.i("dispatchOnCameraClosed");
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onCameraClosed();
                    }
                }
            });
        }

        @Override
        public void onCameraPreviewSizeChanged() {
            this.mLogger.i("onCameraPreviewSizeChanged");
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    CameraView.this.requestLayout();
                }
            });
        }

        @Override
        public void processImage(final byte[] jpeg, final boolean consistentWithView, boolean flipHorizontally) {
            this.mLogger.i("processImage");
            CameraView.this.mWorkerHandler.post(new Runnable(){

                @Override
                public void run() {
                    byte[] jpeg2 = jpeg;
                    if (CameraView.this.mCropOutput && CameraView.this.mCameraPreview.isCropping()) {
                        int w = consistentWithView ? CameraView.this.getWidth() : CameraView.this.getHeight();
                        int h = consistentWithView ? CameraView.this.getHeight() : CameraView.this.getWidth();
                        AspectRatio targetRatio = AspectRatio.of(w, h);
                        Callbacks.this.mLogger.i("processImage", "is consistent?", consistentWithView);
                        Callbacks.this.mLogger.i("processImage", "viewWidth?", CameraView.this.getWidth(), "viewHeight?", CameraView.this.getHeight());
                        jpeg2 = CropHelper.cropToJpeg(jpeg, targetRatio, CameraView.this.mJpegQuality);
                    }
                    Callbacks.this.dispatchOnPictureTaken(jpeg2);
                }
            });
        }

        @Override
        public void processSnapshot(final YuvImage yuv, final boolean consistentWithView, boolean flipHorizontally) {
            this.mLogger.i("processSnapshot");
            CameraView.this.mWorkerHandler.post(new Runnable(){

                @Override
                public void run() {
                    byte[] jpeg;
                    if (CameraView.this.mCropOutput && CameraView.this.mCameraPreview.isCropping()) {
                        int w = consistentWithView ? CameraView.this.getWidth() : CameraView.this.getHeight();
                        int h = consistentWithView ? CameraView.this.getHeight() : CameraView.this.getWidth();
                        AspectRatio targetRatio = AspectRatio.of(w, h);
                        Callbacks.this.mLogger.i("processSnapshot", "is consistent?", consistentWithView);
                        Callbacks.this.mLogger.i("processSnapshot", "viewWidth?", CameraView.this.getWidth(), "viewHeight?", CameraView.this.getHeight());
                        jpeg = CropHelper.cropToJpeg(yuv, targetRatio, CameraView.this.mJpegQuality);
                    } else {
                        ByteArrayOutputStream out = new ByteArrayOutputStream();
                        yuv.compressToJpeg(new Rect(0, 0, yuv.getWidth(), yuv.getHeight()), CameraView.this.mJpegQuality, (OutputStream)out);
                        jpeg = out.toByteArray();
                    }
                    Callbacks.this.dispatchOnPictureTaken(jpeg);
                }
            });
        }

        private void dispatchOnPictureTaken(byte[] jpeg) {
            this.mLogger.i("dispatchOnPictureTaken");
            final byte[] data = jpeg;
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onPictureTaken(data);
                    }
                }
            });
        }

        @Override
        public void dispatchOnVideoTaken(final File video) {
            this.mLogger.i("dispatchOnVideoTaken", video);
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onVideoTaken(video);
                    }
                }
            });
        }

        @Override
        public void dispatchOnFocusStart(final @Nullable Gesture gesture, final PointF point) {
            this.mLogger.i(new Object[]{"dispatchOnFocusStart", gesture, point});
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (gesture != null && CameraView.this.mGestureMap.get((Object)gesture) == GestureAction.FOCUS_WITH_MARKER) {
                        CameraView.this.mTapGestureLayout.onFocusStart(point);
                    }
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onFocusStart(point);
                    }
                }
            });
        }

        @Override
        public void dispatchOnFocusEnd(final @Nullable Gesture gesture, final boolean success, final PointF point) {
            this.mLogger.i(new Object[]{"dispatchOnFocusEnd", gesture, success, point});
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    if (success && CameraView.this.mPlaySounds) {
                        CameraView.this.playSound(1);
                    }
                    if (gesture != null && CameraView.this.mGestureMap.get((Object)gesture) == GestureAction.FOCUS_WITH_MARKER) {
                        CameraView.this.mTapGestureLayout.onFocusEnd(success);
                    }
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onFocusEnd(success, point);
                    }
                }
            });
        }

        @Override
        public void onDisplayOffsetChanged(int displayOffset) {
            this.mLogger.i("onDisplayOffsetChanged", displayOffset);
            CameraView.this.mCameraController.onDisplayOffset(displayOffset);
            this.mDisplayOffset = displayOffset;
            if (this.mDeviceOrientation != null) {
                int value = (this.mDeviceOrientation + this.mDisplayOffset) % 360;
                this.dispatchOnOrientationChanged(value);
            }
        }

        @Override
        public void onDeviceOrientationChanged(int deviceOrientation) {
            this.mLogger.i("onDeviceOrientationChanged", deviceOrientation);
            CameraView.this.mCameraController.onDeviceOrientation(deviceOrientation);
            this.mDeviceOrientation = deviceOrientation;
            if (this.mDisplayOffset != null) {
                int value = (this.mDeviceOrientation + this.mDisplayOffset) % 360;
                this.dispatchOnOrientationChanged(value);
            }
        }

        private void dispatchOnOrientationChanged(final int value) {
            this.mLogger.i("dispatchOnOrientationChanged", value);
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onOrientationChanged(value);
                    }
                }
            });
        }

        @Override
        public void dispatchOnZoomChanged(final float newValue, final PointF[] fingers) {
            this.mLogger.i("dispatchOnZoomChanged", Float.valueOf(newValue));
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onZoomChanged(newValue, new float[]{0.0f, 1.0f}, fingers);
                    }
                }
            });
        }

        @Override
        public void dispatchOnExposureCorrectionChanged(final float newValue, final float[] bounds, final PointF[] fingers) {
            this.mLogger.i("dispatchOnExposureCorrectionChanged", Float.valueOf(newValue));
            CameraView.this.mUiHandler.post(new Runnable(){

                @Override
                public void run() {
                    for (CameraListener listener : CameraView.this.mListeners) {
                        listener.onExposureCorrectionChanged(newValue, bounds, fingers);
                    }
                }
            });
        }
    }

    static interface CameraCallbacks
    extends OrientationHelper.Callbacks {
        public void dispatchOnCameraOpened(CameraOptions var1);

        public void dispatchOnCameraClosed();

        public void onCameraPreviewSizeChanged();

        public void processImage(byte[] var1, boolean var2, boolean var3);

        public void processSnapshot(YuvImage var1, boolean var2, boolean var3);

        public void dispatchOnVideoTaken(File var1);

        public void dispatchOnFocusStart(@Nullable Gesture var1, PointF var2);

        public void dispatchOnFocusEnd(@Nullable Gesture var1, boolean var2, PointF var3);

        public void dispatchOnZoomChanged(float var1, PointF[] var2);

        public void dispatchOnExposureCorrectionChanged(float var1, float[] var2, PointF[] var3);
    }
}

