/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.content.Context;
import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import com.otaliastudios.cameraview.Gesture;
import com.otaliastudios.cameraview.GestureLayout;
import com.otaliastudios.cameraview.R;

class TapGestureLayout
extends GestureLayout {
    private GestureDetector mDetector;
    private boolean mNotify;
    private FrameLayout mFocusMarkerContainer;
    private ImageView mFocusMarkerFill;
    private final Runnable mFocusMarkerHideRunnable = new Runnable(){

        @Override
        public void run() {
            TapGestureLayout.this.onFocusEnd(false);
        }
    };

    public TapGestureLayout(Context context) {
        super(context);
    }

    @Override
    protected void onInitialize(Context context) {
        super.onInitialize(context);
        this.mPoints = new PointF[]{new PointF(0.0f, 0.0f)};
        this.mDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onSingleTapUp(MotionEvent e) {
                TapGestureLayout.this.mNotify = true;
                TapGestureLayout.this.mType = Gesture.TAP;
                return true;
            }

            public void onLongPress(MotionEvent e) {
                TapGestureLayout.this.mNotify = true;
                TapGestureLayout.this.mType = Gesture.LONG_TAP;
            }
        });
        this.mDetector.setIsLongpressEnabled(true);
        LayoutInflater.from((Context)this.getContext()).inflate(R.layout.layout_focus_marker, (ViewGroup)this);
        this.mFocusMarkerContainer = (FrameLayout)this.findViewById(R.id.focusMarkerContainer);
        this.mFocusMarkerFill = (ImageView)this.findViewById(R.id.fill);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnabled) {
            return false;
        }
        if (event.getAction() == 0) {
            this.mNotify = false;
        }
        this.mDetector.onTouchEvent(event);
        if (this.mNotify) {
            this.mPoints[0].x = event.getX();
            this.mPoints[0].y = event.getY();
            return true;
        }
        return false;
    }

    @Override
    public float scaleValue(float currValue, float minValue, float maxValue) {
        return 0.0f;
    }

    public void onFocusStart(PointF point) {
        this.removeCallbacks(this.mFocusMarkerHideRunnable);
        this.mFocusMarkerContainer.clearAnimation();
        this.mFocusMarkerFill.clearAnimation();
        float x = (int)(point.x - (float)(this.mFocusMarkerContainer.getWidth() / 2));
        float y = (int)(point.y - (float)(this.mFocusMarkerContainer.getWidth() / 2));
        this.mFocusMarkerContainer.setTranslationX(x);
        this.mFocusMarkerContainer.setTranslationY(y);
        this.mFocusMarkerContainer.setScaleX(1.36f);
        this.mFocusMarkerContainer.setScaleY(1.36f);
        this.mFocusMarkerContainer.setAlpha(1.0f);
        this.mFocusMarkerFill.setScaleX(0.0f);
        this.mFocusMarkerFill.setScaleY(0.0f);
        this.mFocusMarkerFill.setAlpha(1.0f);
        TapGestureLayout.animate((View)this.mFocusMarkerContainer, 1.0f, 1.0f, 300L, 0L, null);
        TapGestureLayout.animate((View)this.mFocusMarkerFill, 1.0f, 1.0f, 300L, 0L, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

            public void onAnimationEnd(Animator animation) {
                super.onAnimationEnd(animation);
                TapGestureLayout.this.postDelayed(TapGestureLayout.this.mFocusMarkerHideRunnable, 2000L);
            }
        });
    }

    public void onFocusEnd(boolean success) {
        if (success) {
            TapGestureLayout.animate((View)this.mFocusMarkerContainer, 1.0f, 0.0f, 500L, 0L, null);
            TapGestureLayout.animate((View)this.mFocusMarkerFill, 1.0f, 0.0f, 500L, 0L, null);
        } else {
            TapGestureLayout.animate((View)this.mFocusMarkerFill, 0.0f, 0.0f, 500L, 0L, null);
            TapGestureLayout.animate((View)this.mFocusMarkerContainer, 1.36f, 1.0f, 500L, 0L, (Animator.AnimatorListener)new AnimatorListenerAdapter(){

                public void onAnimationEnd(Animator animation) {
                    super.onAnimationEnd(animation);
                    TapGestureLayout.animate((View)TapGestureLayout.this.mFocusMarkerContainer, 1.36f, 0.0f, 200L, 1000L, null);
                }
            });
        }
    }

    private static void animate(View view, float scale, float alpha, long duration, long delay, Animator.AnimatorListener listener) {
        view.animate().scaleX(scale).scaleY(scale).alpha(alpha).setDuration(duration).setStartDelay(delay).setListener(listener).start();
    }
}

