/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.content.Context;
import android.graphics.PointF;
import android.view.GestureDetector;
import android.view.MotionEvent;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.Gesture;
import com.otaliastudios.cameraview.GestureLayout;

class ScrollGestureLayout
extends GestureLayout {
    private static final String TAG = ScrollGestureLayout.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private GestureDetector mDetector;
    private boolean mNotify;
    private float mDistance;

    public ScrollGestureLayout(Context context) {
        super(context);
    }

    @Override
    protected void onInitialize(Context context) {
        super.onInitialize(context);
        this.mPoints = new PointF[]{new PointF(0.0f, 0.0f), new PointF(0.0f, 0.0f)};
        this.mDetector = new GestureDetector(context, (GestureDetector.OnGestureListener)new GestureDetector.SimpleOnGestureListener(){

            public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
                boolean horizontal;
                LOG.i("onScroll:", "distanceX=" + distanceX, "distanceY=" + distanceY);
                if (e1.getX() != ScrollGestureLayout.this.mPoints[0].x || e1.getY() != ScrollGestureLayout.this.mPoints[0].y) {
                    horizontal = Math.abs(distanceX) >= Math.abs(distanceY);
                    ScrollGestureLayout.this.mType = horizontal ? Gesture.SCROLL_HORIZONTAL : Gesture.SCROLL_VERTICAL;
                    ScrollGestureLayout.this.mPoints[0].set(e1.getX(), e1.getY());
                } else {
                    horizontal = ScrollGestureLayout.this.mType == Gesture.SCROLL_HORIZONTAL;
                }
                ScrollGestureLayout.this.mPoints[1].set(e2.getX(), e2.getY());
                ScrollGestureLayout.this.mDistance = horizontal ? distanceX / (float)ScrollGestureLayout.this.getWidth() : distanceY / (float)ScrollGestureLayout.this.getHeight();
                ScrollGestureLayout.this.mDistance = horizontal ? -ScrollGestureLayout.this.mDistance : ScrollGestureLayout.this.mDistance;
                ScrollGestureLayout.this.mNotify = true;
                return true;
            }
        });
        this.mDetector.setIsLongpressEnabled(false);
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnabled) {
            return false;
        }
        if (event.getAction() == 0) {
            this.mNotify = false;
        }
        this.mDetector.onTouchEvent(event);
        if (this.mNotify) {
            LOG.i("Notifying a gesture of type", this.mType.name());
        }
        return this.mNotify;
    }

    @Override
    public float scaleValue(float currValue, float minValue, float maxValue) {
        float delta = this.mDistance;
        delta *= maxValue - minValue;
        float newValue = currValue + (delta *= 2.0f);
        if (newValue < minValue) {
            newValue = minValue;
        }
        if (newValue > maxValue) {
            newValue = maxValue;
        }
        LOG.i("curr=" + currValue, "min=" + minValue, "max=" + maxValue, "out=" + newValue);
        return newValue;
    }
}

