/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.content.Context;
import android.graphics.PointF;
import android.os.Build;
import android.view.MotionEvent;
import android.view.ScaleGestureDetector;
import com.otaliastudios.cameraview.Gesture;
import com.otaliastudios.cameraview.GestureLayout;

class PinchGestureLayout
extends GestureLayout {
    private static final float ADD_SENSITIVITY = 2.0f;
    ScaleGestureDetector mDetector;
    private boolean mNotify;
    private float mAdditionFactor = 0.0f;

    public PinchGestureLayout(Context context) {
        super(context);
    }

    @Override
    protected void onInitialize(Context context) {
        super.onInitialize(context);
        this.mPoints = new PointF[]{new PointF(0.0f, 0.0f), new PointF(0.0f, 0.0f)};
        this.mDetector = new ScaleGestureDetector(context, (ScaleGestureDetector.OnScaleGestureListener)new ScaleGestureDetector.SimpleOnScaleGestureListener(){

            public boolean onScale(ScaleGestureDetector detector) {
                PinchGestureLayout.this.mNotify = true;
                PinchGestureLayout.this.mAdditionFactor = (detector.getScaleFactor() - 1.0f) * 2.0f;
                return true;
            }
        });
        if (Build.VERSION.SDK_INT >= 19) {
            this.mDetector.setQuickScaleEnabled(false);
        }
        this.mType = Gesture.PINCH;
    }

    @Override
    public boolean onTouchEvent(MotionEvent event) {
        if (!this.mEnabled) {
            return false;
        }
        if (event.getAction() == 0) {
            this.mNotify = false;
        }
        this.mDetector.onTouchEvent(event);
        if (this.mNotify) {
            this.mPoints[0].x = event.getX(0);
            this.mPoints[0].y = event.getY(0);
            if (event.getPointerCount() > 1) {
                this.mPoints[1].x = event.getX(1);
                this.mPoints[1].y = event.getY(1);
            }
            return true;
        }
        return false;
    }

    @Override
    public float scaleValue(float currValue, float minValue, float maxValue) {
        float add = this.mAdditionFactor;
        float newValue = currValue + (add *= maxValue - minValue);
        if (newValue < minValue) {
            newValue = minValue;
        }
        if (newValue > maxValue) {
            newValue = maxValue;
        }
        return newValue;
    }
}

