/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.content.Context;
import android.support.annotation.NonNull;
import android.util.SparseIntArray;
import android.view.Display;
import android.view.OrientationEventListener;
import android.view.WindowManager;

class OrientationHelper {
    private static final SparseIntArray DISPLAY_ORIENTATIONS = new SparseIntArray();
    final OrientationEventListener mListener;
    Display mDisplay;
    private final Callbacks mCallbacks;
    int mLastKnownDisplayOffset = -1;
    int mLastOrientation = -1;

    OrientationHelper(Context context, @NonNull Callbacks callbacks) {
        this.mCallbacks = callbacks;
        this.mListener = new OrientationEventListener(context, 3){

            public void onOrientationChanged(int orientation) {
                int offset;
                int or = 0;
                if (orientation == -1) {
                    or = 0;
                } else if (orientation >= 315 || orientation < 45) {
                    or = 0;
                } else if (orientation >= 45 && orientation < 135) {
                    or = 90;
                } else if (orientation >= 135 && orientation < 225) {
                    or = 180;
                } else if (orientation >= 225 && orientation < 315) {
                    or = 270;
                }
                if (or != OrientationHelper.this.mLastOrientation) {
                    OrientationHelper.this.mLastOrientation = or;
                    OrientationHelper.this.mCallbacks.onDeviceOrientationChanged(OrientationHelper.this.mLastOrientation);
                }
                if (OrientationHelper.this.mDisplay != null && OrientationHelper.this.mLastKnownDisplayOffset != (offset = OrientationHelper.this.mDisplay.getRotation())) {
                    OrientationHelper.this.mLastKnownDisplayOffset = offset;
                    OrientationHelper.this.mCallbacks.onDisplayOffsetChanged(DISPLAY_ORIENTATIONS.get(offset));
                }
            }
        };
    }

    void enable(Context context) {
        this.mDisplay = ((WindowManager)context.getSystemService("window")).getDefaultDisplay();
        this.mListener.enable();
        this.mLastKnownDisplayOffset = DISPLAY_ORIENTATIONS.get(this.mDisplay.getRotation());
        this.mCallbacks.onDisplayOffsetChanged(this.mLastKnownDisplayOffset);
    }

    void disable() {
        this.mListener.disable();
        this.mDisplay = null;
    }

    static {
        DISPLAY_ORIENTATIONS.put(0, 0);
        DISPLAY_ORIENTATIONS.put(1, 90);
        DISPLAY_ORIENTATIONS.put(2, 180);
        DISPLAY_ORIENTATIONS.put(3, 270);
    }

    static interface Callbacks {
        public void onDisplayOffsetChanged(int var1);

        public void onDeviceOrientationChanged(int var1);
    }
}

