/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import com.otaliastudios.cameraview.Grid;
import com.otaliastudios.cameraview.Task;

class GridLinesLayout
extends View {
    private Grid gridMode;
    private Drawable horiz;
    private Drawable vert;
    private final float width;
    Task<Integer> drawTask = new Task();
    private static final float GOLDEN_RATIO_INV = 0.618034f;

    public GridLinesLayout(@NonNull Context context) {
        this(context, null);
    }

    public GridLinesLayout(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.horiz = new ColorDrawable(-1);
        this.horiz.setAlpha(160);
        this.vert = new ColorDrawable(-1);
        this.vert.setAlpha(160);
        this.width = TypedValue.applyDimension((int)1, (float)0.9f, (DisplayMetrics)context.getResources().getDisplayMetrics());
    }

    protected void onLayout(boolean changed, int left, int top, int right, int bottom) {
        super.onLayout(changed, left, top, right, bottom);
        this.horiz.setBounds(left, 0, right, (int)this.width);
        this.vert.setBounds(0, top, (int)this.width, bottom);
    }

    public Grid getGridMode() {
        return this.gridMode;
    }

    public void setGridMode(Grid gridMode) {
        this.gridMode = gridMode;
        this.postInvalidate();
    }

    private int getLineCount() {
        switch (this.gridMode) {
            case OFF: {
                return 0;
            }
            case DRAW_3X3: {
                return 2;
            }
            case DRAW_PHI: {
                return 2;
            }
            case DRAW_4X4: {
                return 3;
            }
        }
        return 0;
    }

    private float getLinePosition(int lineNumber) {
        int lineCount = this.getLineCount();
        if (this.gridMode == Grid.DRAW_PHI) {
            float delta = 0.38196602f;
            return lineNumber == 1 ? delta : 1.0f - delta;
        }
        return 1.0f / (float)(lineCount + 1) * ((float)lineNumber + 1.0f);
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        this.drawTask.start();
        int count = this.getLineCount();
        for (int n = 0; n < count; ++n) {
            float pos = this.getLinePosition(n);
            canvas.translate(0.0f, pos * (float)this.getHeight());
            this.horiz.draw(canvas);
            canvas.translate(0.0f, -pos * (float)this.getHeight());
            canvas.translate(pos * (float)this.getWidth(), 0.0f);
            this.vert.draw(canvas);
            canvas.translate(-pos * (float)this.getWidth(), 0.0f);
        }
        this.drawTask.end(count);
    }
}

