/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.annotation.TargetApi;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.util.SizeF;

public class ExtraProperties {
    private float verticalViewingAngle;
    private float horizontalViewingAngle;

    ExtraProperties(Camera.Parameters params) {
        this.verticalViewingAngle = params.getVerticalViewAngle();
        this.horizontalViewingAngle = params.getHorizontalViewAngle();
    }

    @TargetApi(value=21)
    ExtraProperties(CameraCharacteristics chars) {
        float[] maxFocus = (float[])chars.get(CameraCharacteristics.LENS_INFO_AVAILABLE_FOCAL_LENGTHS);
        SizeF size = (SizeF)chars.get(CameraCharacteristics.SENSOR_INFO_PHYSICAL_SIZE);
        this.verticalViewingAngle = (float)Math.toDegrees(2.0 * Math.atan(size.getWidth() / (maxFocus[0] * 2.0f)));
        this.horizontalViewingAngle = (float)Math.toDegrees(2.0 * Math.atan(size.getHeight() / (maxFocus[0] * 2.0f)));
    }

    public float getHorizontalViewingAngle() {
        return this.horizontalViewingAngle;
    }

    public float getVerticalViewingAngle() {
        return this.verticalViewingAngle;
    }
}

