/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.graphics.YuvImage;
import com.otaliastudios.cameraview.AspectRatio;
import com.otaliastudios.cameraview.CameraUtils;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;

class CropHelper {
    CropHelper() {
    }

    static byte[] cropToJpeg(YuvImage yuv, AspectRatio targetRatio, int jpegCompression) {
        Rect crop = CropHelper.computeCrop(yuv.getWidth(), yuv.getHeight(), targetRatio);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        yuv.compressToJpeg(crop, jpegCompression, (OutputStream)out);
        return out.toByteArray();
    }

    static byte[] cropToJpeg(byte[] jpeg, AspectRatio targetRatio, int jpegCompression) {
        Bitmap image = CameraUtils.decodeBitmap(jpeg);
        Rect cropRect = CropHelper.computeCrop(image.getWidth(), image.getHeight(), targetRatio);
        Bitmap crop = Bitmap.createBitmap((Bitmap)image, (int)cropRect.left, (int)cropRect.top, (int)cropRect.width(), (int)cropRect.height());
        image.recycle();
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        crop.compress(Bitmap.CompressFormat.JPEG, jpegCompression, (OutputStream)out);
        return out.toByteArray();
    }

    private static Rect computeCrop(int currentWidth, int currentHeight, AspectRatio targetRatio) {
        int x;
        int y;
        int width;
        int height;
        AspectRatio currentRatio = AspectRatio.of(currentWidth, currentHeight);
        if (currentRatio.toFloat() > targetRatio.toFloat()) {
            height = currentHeight;
            width = (int)((float)height * targetRatio.toFloat());
            y = 0;
            x = (currentWidth - width) / 2;
        } else {
            width = currentWidth;
            height = (int)((float)width / targetRatio.toFloat());
            y = (currentHeight - height) / 2;
            x = 0;
        }
        return new Rect(x, y, x + width, y + height);
    }
}

