/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.content.Context;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Matrix;
import android.hardware.Camera;
import android.os.Handler;
import android.support.annotation.UiThread;
import android.support.media.ExifInterface;
import com.otaliastudios.cameraview.Facing;
import com.otaliastudios.cameraview.Mapper;
import com.otaliastudios.cameraview.WorkerHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;

public class CameraUtils {
    public static boolean hasCameras(Context context) {
        PackageManager manager = context.getPackageManager();
        return manager.hasSystemFeature("android.hardware.camera") || manager.hasSystemFeature("android.hardware.camera.front");
    }

    public static boolean hasCameraFacing(Context context, Facing facing) {
        int internal = (Integer)new Mapper.Mapper1().map(facing);
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != internal) continue;
            return true;
        }
        return false;
    }

    public static void decodeBitmap(final byte[] source, final BitmapCallback callback) {
        final Handler ui = new Handler();
        WorkerHandler.run(new Runnable(){

            @Override
            public void run() {
                final Bitmap bitmap = CameraUtils.decodeBitmap(source);
                ui.post(new Runnable(){

                    @Override
                    public void run() {
                        callback.onBitmapReady(bitmap);
                    }
                });
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Bitmap decodeBitmap(byte[] source) {
        boolean flip;
        int orientation;
        ByteArrayInputStream stream = null;
        try {
            stream = new ByteArrayInputStream(source);
            ExifInterface exif = new ExifInterface((InputStream)stream);
            Integer exifOrientation = exif.getAttributeInt("Orientation", 1);
            switch (exifOrientation) {
                case 1: 
                case 2: {
                    orientation = 0;
                    break;
                }
                case 3: 
                case 4: {
                    orientation = 180;
                    break;
                }
                case 5: 
                case 6: {
                    orientation = 90;
                    break;
                }
                case 7: 
                case 8: {
                    orientation = 270;
                    break;
                }
                default: {
                    orientation = 0;
                }
            }
            flip = exifOrientation == 2 || exifOrientation == 4 || exifOrientation == 5 || exifOrientation == 7;
        }
        catch (IOException e) {
            e.printStackTrace();
            orientation = 0;
            flip = false;
        }
        finally {
            if (stream != null) {
                try {
                    ((InputStream)stream).close();
                }
                catch (Exception e) {}
            }
        }
        Bitmap bitmap = BitmapFactory.decodeByteArray((byte[])source, (int)0, (int)source.length);
        if (orientation != 0 || flip) {
            Matrix matrix = new Matrix();
            matrix.setRotate((float)orientation);
            Bitmap temp = bitmap;
            bitmap = Bitmap.createBitmap((Bitmap)bitmap, (int)0, (int)0, (int)bitmap.getWidth(), (int)bitmap.getHeight(), (Matrix)matrix, (boolean)true);
            temp.recycle();
        }
        return bitmap;
    }

    public static interface BitmapCallback {
        @UiThread
        public void onBitmapReady(Bitmap var1);
    }
}

