/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.content.Context;
import android.support.annotation.NonNull;
import android.view.Surface;
import android.view.View;
import android.view.ViewGroup;
import com.otaliastudios.cameraview.AspectRatio;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.Size;
import com.otaliastudios.cameraview.Task;

abstract class CameraPreview<T extends View, Output> {
    private static final CameraLogger LOG = CameraLogger.create(CameraPreview.class.getSimpleName());
    Task<Void> mCropTask = new Task();
    private SurfaceCallback mSurfaceCallback;
    private T mView;
    private boolean mCropping;
    private int mSurfaceWidth;
    private int mSurfaceHeight;
    private int mDesiredWidth;
    private int mDesiredHeight;

    CameraPreview(Context context, ViewGroup parent, SurfaceCallback callback) {
        this.mView = this.onCreateView(context, parent);
        this.mSurfaceCallback = callback;
    }

    @NonNull
    protected abstract T onCreateView(Context var1, ViewGroup var2);

    abstract Surface getSurface();

    @NonNull
    final T getView() {
        return this.mView;
    }

    abstract Class<Output> getOutputClass();

    abstract Output getOutput();

    void setDesiredSize(int width, int height) {
        LOG.i("setDesiredSize:", "desiredW=", width, "desiredH=", height);
        this.mDesiredWidth = width;
        this.mDesiredHeight = height;
        this.crop();
    }

    final Size getDesiredSize() {
        return new Size(this.mDesiredWidth, this.mDesiredHeight);
    }

    final Size getSurfaceSize() {
        return new Size(this.mSurfaceWidth, this.mSurfaceHeight);
    }

    final void setSurfaceCallback(SurfaceCallback callback) {
        this.mSurfaceCallback = callback;
        if (this.mSurfaceWidth != 0 || this.mSurfaceHeight != 0) {
            this.mSurfaceCallback.onSurfaceAvailable();
        }
    }

    protected final void onSurfaceAvailable(int width, int height) {
        LOG.i("onSurfaceAvailable:", "w=", width, "h=", height);
        this.mSurfaceWidth = width;
        this.mSurfaceHeight = height;
        this.crop();
        this.mSurfaceCallback.onSurfaceAvailable();
    }

    protected final void onSurfaceSizeChanged(int width, int height) {
        LOG.i("onSurfaceSizeChanged:", "w=", width, "h=", height);
        if (width != this.mSurfaceWidth || height != this.mSurfaceHeight) {
            this.mSurfaceWidth = width;
            this.mSurfaceHeight = height;
            this.crop();
            this.mSurfaceCallback.onSurfaceChanged();
        }
    }

    protected final void onSurfaceDestroyed() {
        this.mSurfaceWidth = 0;
        this.mSurfaceHeight = 0;
    }

    final boolean isReady() {
        return this.mSurfaceWidth > 0 && this.mSurfaceHeight > 0;
    }

    private final void crop() {
        this.mCropTask.start();
        if (!this.supportsCropping()) {
            this.mCropTask.end(null);
            return;
        }
        this.getView().post(new Runnable(){

            @Override
            public void run() {
                if (CameraPreview.this.mDesiredHeight == 0 || CameraPreview.this.mDesiredWidth == 0 || CameraPreview.this.mSurfaceHeight == 0 || CameraPreview.this.mSurfaceWidth == 0) {
                    CameraPreview.this.mCropTask.end(null);
                    return;
                }
                float scaleX = 1.0f;
                float scaleY = 1.0f;
                AspectRatio current = AspectRatio.of(CameraPreview.this.mSurfaceWidth, CameraPreview.this.mSurfaceHeight);
                AspectRatio target = AspectRatio.of(CameraPreview.this.mDesiredWidth, CameraPreview.this.mDesiredHeight);
                if (current.toFloat() >= target.toFloat()) {
                    scaleY = current.toFloat() / target.toFloat();
                } else {
                    scaleX = target.toFloat() / current.toFloat();
                }
                CameraPreview.this.applyCrop(scaleX, scaleY);
                CameraPreview.this.mCropping = scaleX > 1.02f || scaleY > 1.02f;
                LOG.i("crop:", "applied scaleX=", Float.valueOf(scaleX));
                LOG.i("crop:", "applied scaleY=", Float.valueOf(scaleY));
                CameraPreview.this.mCropTask.end(null);
            }
        });
    }

    protected void applyCrop(float scaleX, float scaleY) {
        this.getView().setScaleX(scaleX);
        this.getView().setScaleY(scaleY);
    }

    boolean supportsCropping() {
        return true;
    }

    boolean isCropping() {
        return this.mCropping;
    }

    static interface SurfaceCallback {
        public void onSurfaceAvailable();

        public void onSurfaceChanged();
    }
}

