/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.annotation.TargetApi;
import android.hardware.Camera;
import android.hardware.camera2.CameraCharacteristics;
import android.support.annotation.NonNull;
import com.otaliastudios.cameraview.Facing;
import com.otaliastudios.cameraview.Flash;
import com.otaliastudios.cameraview.GestureAction;
import com.otaliastudios.cameraview.Hdr;
import com.otaliastudios.cameraview.Mapper;
import com.otaliastudios.cameraview.WhiteBalance;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class CameraOptions {
    private Set<WhiteBalance> supportedWhiteBalance = new HashSet<WhiteBalance>(5);
    private Set<Facing> supportedFacing = new HashSet<Facing>(2);
    private Set<Flash> supportedFlash = new HashSet<Flash>(4);
    private Set<Hdr> supportedHdr = new HashSet<Hdr>(2);
    private boolean zoomSupported;
    private boolean videoSnapshotSupported;
    private boolean exposureCorrectionSupported;
    private float exposureCorrectionMinValue;
    private float exposureCorrectionMaxValue;
    private boolean autoFocusSupported;

    CameraOptions(Camera.Parameters params) {
        Enum value;
        Mapper.Mapper1 mapper = new Mapper.Mapper1();
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            value = ((Mapper)mapper).unmapFacing(cameraInfo.facing);
            if (value == null) continue;
            this.supportedFacing.add((Facing)value);
        }
        List strings = params.getSupportedWhiteBalance();
        if (strings != null) {
            for (String string : strings) {
                value = ((Mapper)mapper).unmapWhiteBalance(string);
                if (value == null) continue;
                this.supportedWhiteBalance.add((WhiteBalance)value);
            }
        }
        if ((strings = params.getSupportedFlashModes()) != null) {
            for (String string : strings) {
                value = ((Mapper)mapper).unmapFlash(string);
                if (value == null) continue;
                this.supportedFlash.add((Flash)value);
            }
        }
        if ((strings = params.getSupportedSceneModes()) != null) {
            for (String string : strings) {
                value = ((Mapper)mapper).unmapHdr(string);
                if (value == null) continue;
                this.supportedHdr.add((Hdr)value);
            }
        }
        this.zoomSupported = params.isZoomSupported();
        this.videoSnapshotSupported = params.isVideoSnapshotSupported();
        this.autoFocusSupported = params.getSupportedFocusModes().contains("auto");
        float step = params.getExposureCompensationStep();
        this.exposureCorrectionMinValue = (float)params.getMinExposureCompensation() * step;
        this.exposureCorrectionMaxValue = (float)params.getMaxExposureCompensation() * step;
        this.exposureCorrectionSupported = params.getMinExposureCompensation() != 0 || params.getMaxExposureCompensation() != 0;
    }

    @TargetApi(value=21)
    CameraOptions(CameraCharacteristics params) {
    }

    public boolean supports(Facing facing) {
        return this.getSupportedFacing().contains((Object)facing);
    }

    public boolean supports(Flash flash) {
        return this.getSupportedFlash().contains((Object)flash);
    }

    public boolean supports(WhiteBalance whiteBalance) {
        return this.getSupportedWhiteBalance().contains((Object)whiteBalance);
    }

    public boolean supports(Hdr hdr) {
        return this.getSupportedHdr().contains((Object)hdr);
    }

    public boolean supports(GestureAction action) {
        switch (action) {
            case FOCUS: 
            case FOCUS_WITH_MARKER: {
                return this.isAutoFocusSupported();
            }
            case CAPTURE: 
            case NONE: {
                return true;
            }
            case ZOOM: {
                return this.isZoomSupported();
            }
            case EXPOSURE_CORRECTION: {
                return this.isExposureCorrectionSupported();
            }
        }
        return false;
    }

    @NonNull
    public Set<Facing> getSupportedFacing() {
        return Collections.unmodifiableSet(this.supportedFacing);
    }

    @NonNull
    public Set<Flash> getSupportedFlash() {
        return Collections.unmodifiableSet(this.supportedFlash);
    }

    @NonNull
    public Set<WhiteBalance> getSupportedWhiteBalance() {
        return Collections.unmodifiableSet(this.supportedWhiteBalance);
    }

    @NonNull
    public Set<Hdr> getSupportedHdr() {
        return Collections.unmodifiableSet(this.supportedHdr);
    }

    public boolean isZoomSupported() {
        return this.zoomSupported;
    }

    public boolean isVideoSnapshotSupported() {
        return this.videoSnapshotSupported;
    }

    public boolean isAutoFocusSupported() {
        return this.autoFocusSupported;
    }

    public boolean isExposureCorrectionSupported() {
        return this.exposureCorrectionSupported;
    }

    public float getExposureCorrectionMinValue() {
        return this.exposureCorrectionMinValue;
    }

    public float getExposureCorrectionMaxValue() {
        return this.exposureCorrectionMaxValue;
    }
}

