/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.util.Log;

public final class CameraLogger {
    public static final int LEVEL_VERBOSE = 0;
    public static final int LEVEL_WARNING = 1;
    public static final int LEVEL_ERROR = 2;
    private static int level = 2;
    static String lastMessage;
    static String lastTag;
    private String mTag;

    public static void setLogLevel(int logLevel) {
        level = logLevel;
    }

    static CameraLogger create(String tag) {
        return new CameraLogger(tag);
    }

    private CameraLogger(String tag) {
        this.mTag = tag;
    }

    public void i(String message) {
        if (this.should(0)) {
            Log.i((String)this.mTag, (String)message);
            lastMessage = message;
            lastTag = this.mTag;
        }
    }

    public void w(String message) {
        if (this.should(1)) {
            Log.w((String)this.mTag, (String)message);
            lastMessage = message;
            lastTag = this.mTag;
        }
    }

    public void e(String message) {
        if (this.should(2)) {
            Log.w((String)this.mTag, (String)message);
            lastMessage = message;
            lastTag = this.mTag;
        }
    }

    private boolean should(int messageLevel) {
        return level <= messageLevel;
    }

    private String string(int messageLevel, Object ... ofData) {
        String message = "";
        if (this.should(messageLevel)) {
            for (Object o : ofData) {
                message = message + String.valueOf(o);
                message = message + " ";
            }
        }
        return message.trim();
    }

    public void i(Object ... data) {
        this.i(this.string(0, data));
    }

    public void w(Object ... data) {
        this.w(this.string(1, data));
    }

    public void e(Object ... data) {
        this.e(this.string(2, data));
    }
}

