/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.graphics.PointF;
import android.location.Location;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import com.otaliastudios.cameraview.Audio;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.CameraPreview;
import com.otaliastudios.cameraview.CameraView;
import com.otaliastudios.cameraview.ExtraProperties;
import com.otaliastudios.cameraview.Facing;
import com.otaliastudios.cameraview.Flash;
import com.otaliastudios.cameraview.Gesture;
import com.otaliastudios.cameraview.Hdr;
import com.otaliastudios.cameraview.SessionType;
import com.otaliastudios.cameraview.Size;
import com.otaliastudios.cameraview.VideoQuality;
import com.otaliastudios.cameraview.WhiteBalance;
import com.otaliastudios.cameraview.WorkerHandler;
import java.io.File;

abstract class CameraController
implements CameraPreview.SurfaceCallback {
    private static final String TAG = CameraController.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    static final int STATE_STOPPING = -1;
    static final int STATE_STOPPED = 0;
    static final int STATE_STARTING = 1;
    static final int STATE_STARTED = 2;
    protected final CameraView.CameraCallbacks mCameraCallbacks;
    protected CameraPreview mPreview;
    protected Facing mFacing;
    protected Flash mFlash;
    protected WhiteBalance mWhiteBalance;
    protected VideoQuality mVideoQuality;
    protected SessionType mSessionType;
    protected Hdr mHdr;
    protected Location mLocation;
    protected Audio mAudio;
    protected Size mCaptureSize;
    protected Size mPreviewSize;
    protected ExtraProperties mExtraProperties;
    protected CameraOptions mOptions;
    protected int mDisplayOffset;
    protected int mDeviceOrientation;
    protected int mState = 0;
    protected WorkerHandler mHandler;

    CameraController(CameraView.CameraCallbacks callback) {
        this.mCameraCallbacks = callback;
        this.mHandler = WorkerHandler.get("CameraViewController");
        this.mHandler.getThread().setUncaughtExceptionHandler(new Thread.UncaughtExceptionHandler(){

            @Override
            public void uncaughtException(Thread thread, Throwable throwable) {
                LOG.w("Interrupting thread, due to exception.", throwable);
                thread.interrupt();
                LOG.w("Interrupted thread. Posting a stopImmediately.", CameraController.this.ss());
                CameraController.this.mHandler = WorkerHandler.get("CameraViewController");
                CameraController.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        CameraController.this.stopImmediately();
                    }
                });
            }
        });
    }

    void setPreview(CameraPreview cameraPreview) {
        this.mPreview = cameraPreview;
        this.mPreview.setSurfaceCallback(this);
    }

    private String ss() {
        switch (this.mState) {
            case -1: {
                return "STATE_STOPPING";
            }
            case 0: {
                return "STATE_STOPPED";
            }
            case 1: {
                return "STATE_STARTING";
            }
            case 2: {
                return "STATE_STARTED";
            }
        }
        return "null";
    }

    final void start() {
        LOG.i("Start:", "posting runnable. State:", this.ss());
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.i("Start:", "executing. State:", CameraController.this.ss());
                    if (CameraController.this.mState >= 1) {
                        return;
                    }
                    CameraController.this.mState = 1;
                    LOG.i("Start:", "about to call onStart()", CameraController.this.ss());
                    CameraController.this.onStart();
                    LOG.i("Start:", "returned from onStart().", "Dispatching.", CameraController.this.ss());
                    CameraController.this.mState = 2;
                    CameraController.this.mCameraCallbacks.dispatchOnCameraOpened(CameraController.this.mOptions);
                }
                catch (Exception e) {
                    LOG.e("Error while starting the camera engine.", e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    final void stop() {
        LOG.i("Stop:", "posting runnable. State:", this.ss());
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.i("Stop:", "executing. State:", CameraController.this.ss());
                    if (CameraController.this.mState <= 0) {
                        return;
                    }
                    CameraController.this.mState = -1;
                    LOG.i("Stop:", "about to call onStop()");
                    CameraController.this.onStop();
                    LOG.i("Stop:", "returned from onStop().", "Dispatching.");
                    CameraController.this.mState = 0;
                    CameraController.this.mCameraCallbacks.dispatchOnCameraClosed();
                }
                catch (Exception e) {
                    LOG.e("Error while stopping the camera engine.", e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    void stopImmediately() {
        try {
            LOG.i("Stop immediately. State was:", this.ss());
            this.mState = -1;
            this.onStop();
            this.mState = 0;
            LOG.i("Stop immediately. Stopped. State is:", this.ss());
        }
        catch (Exception e) {
            LOG.i("Stop immediately. Exception while stopping.", e);
            this.mState = 0;
        }
    }

    protected final void restart() {
        LOG.i("Restart:", "posting runnable");
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                try {
                    LOG.i("Restart:", "executing. Needs stopping:", CameraController.this.mState > 0, CameraController.this.ss());
                    if (CameraController.this.mState > 0) {
                        CameraController.this.mState = -1;
                        CameraController.this.onStop();
                        CameraController.this.mState = 0;
                        LOG.i("Restart:", "stopped. Dispatching.", CameraController.this.ss());
                        CameraController.this.mCameraCallbacks.dispatchOnCameraClosed();
                    }
                    LOG.i("Restart: about to start. State:", CameraController.this.ss());
                    CameraController.this.mState = 1;
                    CameraController.this.onStart();
                    CameraController.this.mState = 2;
                    LOG.i("Restart: returned from start. Dispatching. State:", CameraController.this.ss());
                    CameraController.this.mCameraCallbacks.dispatchOnCameraOpened(CameraController.this.mOptions);
                }
                catch (Exception e) {
                    LOG.e("Error while restarting the camera engine.", e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @WorkerThread
    abstract void onStart() throws Exception;

    @WorkerThread
    abstract void onStop() throws Exception;

    final int getState() {
        return this.mState;
    }

    void onDisplayOffset(int displayOrientation) {
        this.mDisplayOffset = displayOrientation;
    }

    void onDeviceOrientation(int deviceOrientation) {
        this.mDeviceOrientation = deviceOrientation;
    }

    abstract void setSessionType(SessionType var1);

    abstract void setFacing(Facing var1);

    abstract boolean setZoom(float var1);

    abstract boolean setExposureCorrection(float var1);

    abstract void setFlash(Flash var1);

    abstract void setWhiteBalance(WhiteBalance var1);

    abstract void setHdr(Hdr var1);

    abstract void setLocation(Location var1);

    abstract void setAudio(Audio var1);

    abstract void setVideoQuality(VideoQuality var1);

    abstract boolean capturePicture();

    abstract boolean captureSnapshot();

    abstract boolean startVideo(@NonNull File var1);

    abstract boolean endVideo();

    abstract boolean shouldFlipSizes();

    abstract boolean startAutoFocus(@Nullable Gesture var1, PointF var2);

    @Nullable
    final ExtraProperties getExtraProperties() {
        return this.mExtraProperties;
    }

    @Nullable
    final CameraOptions getCameraOptions() {
        return this.mOptions;
    }

    final Facing getFacing() {
        return this.mFacing;
    }

    final Flash getFlash() {
        return this.mFlash;
    }

    final WhiteBalance getWhiteBalance() {
        return this.mWhiteBalance;
    }

    final VideoQuality getVideoQuality() {
        return this.mVideoQuality;
    }

    final SessionType getSessionType() {
        return this.mSessionType;
    }

    final Hdr getHdr() {
        return this.mHdr;
    }

    final Location getLocation() {
        return this.mLocation;
    }

    final Audio getAudio() {
        return this.mAudio;
    }

    final Size getCaptureSize() {
        return this.mCaptureSize;
    }

    final Size getPreviewSize() {
        return this.mPreviewSize;
    }
}

