/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.graphics.PointF;
import android.graphics.Rect;
import android.graphics.SurfaceTexture;
import android.graphics.YuvImage;
import android.hardware.Camera;
import android.location.Location;
import android.media.CamcorderProfile;
import android.media.MediaRecorder;
import android.os.Build;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.support.annotation.WorkerThread;
import android.view.SurfaceHolder;
import com.otaliastudios.cameraview.AspectRatio;
import com.otaliastudios.cameraview.Audio;
import com.otaliastudios.cameraview.CameraController;
import com.otaliastudios.cameraview.CameraLogger;
import com.otaliastudios.cameraview.CameraOptions;
import com.otaliastudios.cameraview.CameraView;
import com.otaliastudios.cameraview.ExtraProperties;
import com.otaliastudios.cameraview.Facing;
import com.otaliastudios.cameraview.Flash;
import com.otaliastudios.cameraview.Gesture;
import com.otaliastudios.cameraview.Hdr;
import com.otaliastudios.cameraview.Mapper;
import com.otaliastudios.cameraview.RotationHelper;
import com.otaliastudios.cameraview.SessionType;
import com.otaliastudios.cameraview.Size;
import com.otaliastudios.cameraview.VideoQuality;
import com.otaliastudios.cameraview.WhiteBalance;
import com.otaliastudios.cameraview.WorkerHandler;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

class Camera1
extends CameraController {
    private static final String TAG = Camera1.class.getSimpleName();
    private static final CameraLogger LOG = CameraLogger.create(TAG);
    private int mCameraId;
    private Camera mCamera;
    private MediaRecorder mMediaRecorder;
    private File mVideoFile;
    private int mSensorOffset;
    private final int mPostFocusResetDelay = 3000;
    private Runnable mPostFocusResetRunnable = new Runnable(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            if (!Camera1.this.isCameraAvailable()) {
                return;
            }
            Camera1.this.mCamera.cancelAutoFocus();
            Object object = Camera1.this.mLock;
            synchronized (object) {
                Camera.Parameters params = Camera1.this.mCamera.getParameters();
                params.setFocusAreas(null);
                params.setMeteringAreas(null);
                Camera1.this.applyDefaultFocus(params);
                Camera1.this.mCamera.setParameters(params);
            }
        }
    };
    private Mapper mMapper = new Mapper.Mapper1();
    private boolean mIsSetup = false;
    private boolean mIsCapturingImage = false;
    private boolean mIsCapturingVideo = false;
    private final Object mLock = new Object();

    Camera1(CameraView.CameraCallbacks callback) {
        super(callback);
    }

    @Override
    public void onSurfaceAvailable() {
        LOG.i("onSurfaceAvailable:", "Size is", this.mPreview.getSurfaceSize());
        if (!this.shouldSetup()) {
            return;
        }
        this.mHandler.post(new Runnable(){

            @Override
            public void run() {
                if (!Camera1.this.shouldSetup()) {
                    return;
                }
                LOG.i("onSurfaceAvailable:", "Inside handler. About to bind.");
                try {
                    Camera1.this.setup();
                }
                catch (Exception e) {
                    LOG.w("onSurfaceAvailable:", "Exception while binding camera to preview.", e);
                    throw new RuntimeException(e);
                }
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onSurfaceChanged() {
        Size newSize;
        LOG.i("onSurfaceChanged, size is", this.mPreview.getSurfaceSize());
        if (this.mIsSetup && !(newSize = this.computePreviewSize()).equals(this.mPreviewSize)) {
            LOG.i("onSurfaceChanged:", "Computed a new preview size. Dispatching.");
            this.mPreviewSize = newSize;
            this.mCameraCallbacks.onCameraPreviewSizeChanged();
            Object object = this.mLock;
            synchronized (object) {
                LOG.i("onSurfaceChanged:", "Stopping preview.");
                this.mCamera.stopPreview();
                LOG.i("onSurfaceChanged:", "Stopped preview.");
                Camera.Parameters params = this.mCamera.getParameters();
                params.setPreviewSize(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
                this.mCamera.setParameters(params);
            }
            boolean invertPreviewSizes = this.shouldFlipSizes();
            this.mPreview.setDesiredSize(invertPreviewSizes ? this.mPreviewSize.getHeight() : this.mPreviewSize.getWidth(), invertPreviewSizes ? this.mPreviewSize.getWidth() : this.mPreviewSize.getHeight());
            LOG.i("onSurfaceChanged:", "Restarting preview.");
            this.mCamera.startPreview();
            LOG.i("onSurfaceChanged:", "Restarted preview.");
        }
    }

    private boolean shouldSetup() {
        return this.isCameraAvailable() && this.mPreview != null && this.mPreview.isReady() && !this.mIsSetup;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @WorkerThread
    private void setup() throws Exception {
        LOG.i("setup:", "Started");
        Object output = this.mPreview.getOutput();
        if (this.mPreview.getOutputClass() == SurfaceHolder.class) {
            this.mCamera.setPreviewDisplay((SurfaceHolder)output);
        } else {
            this.mCamera.setPreviewTexture((SurfaceTexture)output);
        }
        boolean invertPreviewSizes = this.shouldFlipSizes();
        this.mCaptureSize = this.computeCaptureSize();
        this.mPreviewSize = this.computePreviewSize();
        LOG.i("setup:", "Dispatching onCameraPreviewSizeChanged.");
        this.mCameraCallbacks.onCameraPreviewSizeChanged();
        this.mPreview.setDesiredSize(invertPreviewSizes ? this.mPreviewSize.getHeight() : this.mPreviewSize.getWidth(), invertPreviewSizes ? this.mPreviewSize.getWidth() : this.mPreviewSize.getHeight());
        Object object = this.mLock;
        synchronized (object) {
            Camera.Parameters params = this.mCamera.getParameters();
            params.setPreviewSize(this.mPreviewSize.getWidth(), this.mPreviewSize.getHeight());
            params.setPictureSize(this.mCaptureSize.getWidth(), this.mCaptureSize.getHeight());
            this.mCamera.setParameters(params);
        }
        LOG.i("setup:", "Starting preview with startPreview().");
        this.mCamera.startPreview();
        LOG.i("setup:", "Started preview with startPreview().");
        this.mIsSetup = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @WorkerThread
    void onStart() throws Exception {
        if (this.isCameraAvailable()) {
            LOG.w("onStart:", "Camera not available. Should not happen.");
            this.onStop();
        }
        if (this.collectCameraId()) {
            this.mCamera = Camera.open((int)this.mCameraId);
            Object object = this.mLock;
            synchronized (object) {
                LOG.i("onStart:", "Applying default parameters.");
                Camera.Parameters params = this.mCamera.getParameters();
                this.mExtraProperties = new ExtraProperties(params);
                this.mOptions = new CameraOptions(params);
                this.applyDefaultFocus(params);
                this.mergeFlash(params, Flash.DEFAULT);
                this.mergeLocation(params, null);
                this.mergeWhiteBalance(params, WhiteBalance.DEFAULT);
                params.setRecordingHint(this.mSessionType == SessionType.VIDEO);
                this.mCamera.setParameters(params);
            }
            this.mCamera.setDisplayOrientation(this.computeSensorToDisplayOffset());
            if (this.shouldSetup()) {
                this.setup();
            }
            LOG.i("onStart:", "Ended");
        }
    }

    @Override
    @WorkerThread
    void onStop() throws Exception {
        Exception error = null;
        LOG.i("onStop:", "About to clean up.");
        this.mHandler.get().removeCallbacks(this.mPostFocusResetRunnable);
        if (this.isCameraAvailable()) {
            LOG.i("onStop:", "Clean up.", "Ending video?", this.mIsCapturingVideo);
            if (this.mIsCapturingVideo) {
                this.endVideo();
            }
            try {
                LOG.i("onStop:", "Clean up.", "Stopping preview.");
                this.mCamera.stopPreview();
                LOG.i("onStop:", "Clean up.", "Stopped preview.");
            }
            catch (Exception e) {
                LOG.w("onStop:", "Clean up.", "Exception while stopping preview.");
                error = e;
            }
            try {
                LOG.i("onStop:", "Clean up.", "Releasing camera.");
                this.mCamera.release();
                LOG.i("onStop:", "Clean up.", "Released camera.");
            }
            catch (Exception e) {
                LOG.w("onStop:", "Clean up.", "Exception while releasing camera.");
                error = e;
            }
        }
        this.mExtraProperties = null;
        this.mOptions = null;
        this.mCamera = null;
        this.mPreviewSize = null;
        this.mCaptureSize = null;
        this.mIsSetup = false;
        if (error != null) {
            throw error;
        }
    }

    private boolean collectCameraId() {
        int internalFacing = (Integer)this.mMapper.map(this.mFacing);
        Camera.CameraInfo cameraInfo = new Camera.CameraInfo();
        int count = Camera.getNumberOfCameras();
        for (int i = 0; i < count; ++i) {
            Camera.getCameraInfo((int)i, (Camera.CameraInfo)cameraInfo);
            if (cameraInfo.facing != internalFacing) continue;
            this.mSensorOffset = cameraInfo.orientation;
            this.mCameraId = i;
            return true;
        }
        return false;
    }

    @Override
    void setSessionType(SessionType sessionType) {
        if (sessionType != this.mSessionType) {
            this.mSessionType = sessionType;
            if (this.isCameraAvailable()) {
                this.restart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setLocation(Location location) {
        Location oldLocation = this.mLocation;
        this.mLocation = location;
        if (this.isCameraAvailable()) {
            Object object = this.mLock;
            synchronized (object) {
                Camera.Parameters params = this.mCamera.getParameters();
                if (this.mergeLocation(params, oldLocation)) {
                    this.mCamera.setParameters(params);
                }
            }
        }
    }

    private boolean mergeLocation(Camera.Parameters params, Location oldLocation) {
        if (this.mLocation != null) {
            params.setGpsLatitude(this.mLocation.getLatitude());
            params.setGpsLongitude(this.mLocation.getLongitude());
            params.setGpsAltitude(this.mLocation.getAltitude());
            params.setGpsTimestamp(this.mLocation.getTime());
            params.setGpsProcessingMethod(this.mLocation.getProvider());
            if (this.mIsCapturingVideo && this.mMediaRecorder != null) {
                this.mMediaRecorder.setLocation((float)this.mLocation.getLatitude(), (float)this.mLocation.getLongitude());
            }
        }
        return true;
    }

    @Override
    void setFacing(Facing facing) {
        if (facing != this.mFacing) {
            this.mFacing = facing;
            if (this.collectCameraId() && this.isCameraAvailable()) {
                this.restart();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setWhiteBalance(WhiteBalance whiteBalance) {
        WhiteBalance old = this.mWhiteBalance;
        this.mWhiteBalance = whiteBalance;
        if (this.isCameraAvailable()) {
            Object object = this.mLock;
            synchronized (object) {
                Camera.Parameters params = this.mCamera.getParameters();
                if (this.mergeWhiteBalance(params, old)) {
                    this.mCamera.setParameters(params);
                }
            }
        }
    }

    private boolean mergeWhiteBalance(Camera.Parameters params, WhiteBalance oldWhiteBalance) {
        if (this.mOptions.supports(this.mWhiteBalance)) {
            params.setWhiteBalance((String)this.mMapper.map(this.mWhiteBalance));
            return true;
        }
        this.mWhiteBalance = oldWhiteBalance;
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setHdr(Hdr hdr) {
        Hdr old = this.mHdr;
        this.mHdr = hdr;
        if (this.isCameraAvailable()) {
            Object object = this.mLock;
            synchronized (object) {
                Camera.Parameters params = this.mCamera.getParameters();
                if (this.mergeHdr(params, old)) {
                    this.mCamera.setParameters(params);
                }
            }
        }
    }

    private boolean mergeHdr(Camera.Parameters params, Hdr oldHdr) {
        if (this.mOptions.supports(this.mHdr)) {
            params.setSceneMode((String)this.mMapper.map(this.mHdr));
            return true;
        }
        this.mHdr = oldHdr;
        return false;
    }

    @Override
    void setAudio(Audio audio) {
        if (this.mAudio != audio) {
            if (this.mIsCapturingVideo) {
                LOG.w("Changing audio mode while recording. Changes will take place starting from next video");
            }
            this.mAudio = audio;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setFlash(Flash flash) {
        Flash old = this.mFlash;
        this.mFlash = flash;
        if (this.isCameraAvailable()) {
            Object object = this.mLock;
            synchronized (object) {
                Camera.Parameters params = this.mCamera.getParameters();
                if (this.mergeFlash(params, old)) {
                    this.mCamera.setParameters(params);
                }
            }
        }
    }

    private boolean mergeFlash(Camera.Parameters params, Flash oldFlash) {
        if (this.mOptions.supports(this.mFlash)) {
            params.setFlashMode((String)this.mMapper.map(this.mFlash));
            return true;
        }
        this.mFlash = oldFlash;
        return false;
    }

    private void applyDefaultFocus(Camera.Parameters params) {
        List modes = params.getSupportedFocusModes();
        if (this.mSessionType == SessionType.VIDEO && modes.contains("continuous-video")) {
            params.setFocusMode("continuous-video");
            return;
        }
        if (modes.contains("continuous-picture")) {
            params.setFocusMode("continuous-picture");
            return;
        }
        if (modes.contains("infinity")) {
            params.setFocusMode("infinity");
            return;
        }
        if (modes.contains("fixed")) {
            params.setFocusMode("fixed");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    void setVideoQuality(VideoQuality videoQuality) {
        if (this.mIsCapturingVideo) {
            throw new IllegalStateException("Can't change video quality while recording a video.");
        }
        this.mVideoQuality = videoQuality;
        if (this.isCameraAvailable() && this.mSessionType == SessionType.VIDEO) {
            Size oldSize = this.mCaptureSize;
            this.mCaptureSize = this.computeCaptureSize();
            if (!this.mCaptureSize.equals(oldSize)) {
                Object object = this.mLock;
                synchronized (object) {
                    Camera.Parameters params = this.mCamera.getParameters();
                    params.setPictureSize(this.mCaptureSize.getWidth(), this.mCaptureSize.getHeight());
                    this.mCamera.setParameters(params);
                }
                this.onSurfaceChanged();
            }
            LOG.i("setVideoQuality:", "captureSize:", this.mCaptureSize);
            LOG.i("setVideoQuality:", "previewSize:", this.mPreviewSize);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean capturePicture() {
        if (this.mIsCapturingImage) {
            return false;
        }
        if (!this.isCameraAvailable()) {
            return false;
        }
        if (this.mSessionType == SessionType.VIDEO && this.mIsCapturingVideo && !this.mOptions.isVideoSnapshotSupported()) {
            return false;
        }
        this.mIsCapturingImage = true;
        int exifRotation = this.computeExifRotation();
        final boolean exifFlip = this.computeExifFlip();
        int sensorToDisplay = this.computeSensorToDisplayOffset();
        Object object = this.mLock;
        synchronized (object) {
            Camera.Parameters params = this.mCamera.getParameters();
            params.setRotation(exifRotation);
            this.mCamera.setParameters(params);
        }
        final boolean consistentWithView = (exifRotation + sensorToDisplay + 180) % 180 == 0;
        this.mCamera.takePicture(null, null, null, new Camera.PictureCallback(){

            public void onPictureTaken(byte[] data, final Camera camera) {
                Camera1.this.mIsCapturingImage = false;
                Camera1.this.mHandler.post(new Runnable(){

                    @Override
                    public void run() {
                        camera.startPreview();
                    }
                });
                Camera1.this.mCameraCallbacks.processImage(data, consistentWithView, exifFlip);
            }
        });
        return true;
    }

    @Override
    boolean captureSnapshot() {
        if (!this.isCameraAvailable()) {
            return false;
        }
        if (this.mIsCapturingImage) {
            return false;
        }
        if (this.mIsCapturingVideo) {
            this.capturePicture();
            return false;
        }
        this.mIsCapturingImage = true;
        this.mCamera.setOneShotPreviewCallback(new Camera.PreviewCallback(){

            public void onPreviewFrame(final byte[] data, Camera camera) {
                Camera.Parameters params = Camera1.this.mCamera.getParameters();
                final int sensorToDevice = Camera1.this.computeExifRotation();
                final int sensorToDisplay = Camera1.this.computeSensorToDisplayOffset();
                final boolean exifFlip = Camera1.this.computeExifFlip();
                boolean flip = sensorToDevice % 180 != 0;
                final int preWidth = Camera1.this.mPreviewSize.getWidth();
                final int preHeight = Camera1.this.mPreviewSize.getHeight();
                final int postWidth = flip ? preHeight : preWidth;
                final int postHeight = flip ? preWidth : preHeight;
                final int format = params.getPreviewFormat();
                WorkerHandler.run(new Runnable(){

                    @Override
                    public void run() {
                        boolean consistentWithView = (sensorToDevice + sensorToDisplay + 180) % 180 == 0;
                        byte[] rotatedData = RotationHelper.rotate(data, preWidth, preHeight, sensorToDevice);
                        YuvImage yuv = new YuvImage(rotatedData, format, postWidth, postHeight, null);
                        Camera1.this.mCameraCallbacks.processSnapshot(yuv, consistentWithView, exifFlip);
                        Camera1.this.mIsCapturingImage = false;
                    }
                });
            }
        });
        return true;
    }

    @Override
    boolean shouldFlipSizes() {
        int offset = this.computeSensorToDisplayOffset();
        LOG.i("shouldFlipSizes:", "mDeviceOrientation=", this.mDeviceOrientation, "mSensorOffset=", this.mSensorOffset);
        LOG.i("shouldFlipSizes:", "sensorToDisplay=", offset);
        return offset % 180 != 0;
    }

    private boolean isCameraAvailable() {
        return this.mCamera != null;
    }

    private int computeSensorToDisplayOffset() {
        if (this.mFacing == Facing.FRONT) {
            return (this.mSensorOffset - this.mDisplayOffset + 360 + 180) % 360;
        }
        return (this.mSensorOffset - this.mDisplayOffset + 360) % 360;
    }

    private int computeExifRotation() {
        if (this.mFacing == Facing.FRONT) {
            return (this.mSensorOffset - this.mDeviceOrientation + 360) % 360;
        }
        return (this.mSensorOffset + this.mDeviceOrientation) % 360;
    }

    private boolean computeExifFlip() {
        return this.mFacing == Facing.FRONT;
    }

    private Size computeCaptureSize() {
        Camera.Parameters params = this.mCamera.getParameters();
        if (this.mSessionType == SessionType.PICTURE) {
            List<Size> captureSizes = Camera1.sizesFromList(params.getSupportedPictureSizes());
            Size maxSize = Collections.max(captureSizes);
            LOG.i("size:", "computeCaptureSize:", "computed", maxSize);
            return Collections.max(captureSizes);
        }
        List<Size> captureSizes = Camera1.sizesFromList(params.getSupportedPictureSizes());
        CamcorderProfile profile = this.getCamcorderProfile(this.mVideoQuality);
        AspectRatio targetRatio = AspectRatio.of(profile.videoFrameWidth, profile.videoFrameHeight);
        LOG.i(new Object[]{"size:", "computeCaptureSize:", "videoQuality:", this.mVideoQuality, "targetRatio:", targetRatio});
        return Camera1.matchSize(captureSizes, targetRatio, new Size(0, 0), true);
    }

    private Size computePreviewSize() {
        Camera.Parameters params = this.mCamera.getParameters();
        List<Size> previewSizes = Camera1.sizesFromList(params.getSupportedPreviewSizes());
        AspectRatio targetRatio = AspectRatio.of(this.mCaptureSize.getWidth(), this.mCaptureSize.getHeight());
        Size biggerThan = this.mPreview.getSurfaceSize();
        LOG.i("size:", "computePreviewSize:", "targetRatio:", targetRatio, "surface size:", biggerThan);
        return Camera1.matchSize(previewSizes, targetRatio, biggerThan, false);
    }

    @Override
    boolean startVideo(@NonNull File videoFile) {
        if (this.mIsCapturingVideo) {
            return false;
        }
        if (!this.isCameraAvailable()) {
            return false;
        }
        if (this.mSessionType == SessionType.VIDEO) {
            this.mVideoFile = videoFile;
            this.mIsCapturingVideo = true;
            this.initMediaRecorder();
            try {
                this.mMediaRecorder.prepare();
                this.mMediaRecorder.start();
                return true;
            }
            catch (Exception e) {
                LOG.e("Error while starting MediaRecorder. Swallowing.", e);
                this.mVideoFile = null;
                this.mCamera.lock();
                this.endVideo();
                return false;
            }
        }
        throw new IllegalStateException("Can't record video while session type is picture");
    }

    @Override
    boolean endVideo() {
        if (this.mIsCapturingVideo) {
            this.mIsCapturingVideo = false;
            if (this.mMediaRecorder != null) {
                try {
                    this.mMediaRecorder.stop();
                    this.mMediaRecorder.release();
                }
                catch (Exception e) {
                    LOG.w("Error while closing media recorder. Swallowing", e);
                }
                this.mMediaRecorder = null;
            }
            if (this.mVideoFile != null) {
                this.mCameraCallbacks.dispatchOnVideoTaken(this.mVideoFile);
                this.mVideoFile = null;
            }
            return true;
        }
        return false;
    }

    private void initMediaRecorder() {
        this.mMediaRecorder = new MediaRecorder();
        this.mCamera.unlock();
        this.mMediaRecorder.setCamera(this.mCamera);
        this.mMediaRecorder.setVideoSource(1);
        CamcorderProfile profile = this.getCamcorderProfile(this.mVideoQuality);
        if (this.mAudio == Audio.ON) {
            this.mMediaRecorder.setAudioSource(5);
            this.mMediaRecorder.setProfile(profile);
        } else {
            this.mMediaRecorder.setOutputFormat(profile.fileFormat);
            this.mMediaRecorder.setVideoEncoder(profile.videoCodec);
            this.mMediaRecorder.setVideoEncodingBitRate(profile.videoBitRate);
            this.mMediaRecorder.setVideoFrameRate(profile.videoFrameRate);
            this.mMediaRecorder.setVideoSize(profile.videoFrameWidth, profile.videoFrameHeight);
        }
        if (this.mLocation != null) {
            this.mMediaRecorder.setLocation((float)this.mLocation.getLatitude(), (float)this.mLocation.getLongitude());
        }
        this.mMediaRecorder.setOutputFile(this.mVideoFile.getAbsolutePath());
        this.mMediaRecorder.setOrientationHint(this.computeExifRotation());
    }

    @NonNull
    private CamcorderProfile getCamcorderProfile(VideoQuality videoQuality) {
        switch (videoQuality) {
            case HIGHEST: {
                return CamcorderProfile.get((int)this.mCameraId, (int)1);
            }
            case MAX_2160P: {
                if (Build.VERSION.SDK_INT >= 21 && CamcorderProfile.hasProfile((int)8)) {
                    return CamcorderProfile.get((int)this.mCameraId, (int)8);
                }
            }
            case MAX_1080P: {
                if (CamcorderProfile.hasProfile((int)this.mCameraId, (int)6)) {
                    return CamcorderProfile.get((int)this.mCameraId, (int)6);
                }
            }
            case MAX_720P: {
                if (CamcorderProfile.hasProfile((int)this.mCameraId, (int)5)) {
                    return CamcorderProfile.get((int)this.mCameraId, (int)5);
                }
            }
            case MAX_480P: {
                if (CamcorderProfile.hasProfile((int)this.mCameraId, (int)4)) {
                    return CamcorderProfile.get((int)this.mCameraId, (int)4);
                }
            }
            case MAX_QVGA: {
                if (!CamcorderProfile.hasProfile((int)this.mCameraId, (int)7)) break;
                return CamcorderProfile.get((int)this.mCameraId, (int)7);
            }
        }
        return CamcorderProfile.get((int)this.mCameraId, (int)0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean setZoom(float zoom) {
        if (!this.isCameraAvailable()) {
            return false;
        }
        if (!this.mOptions.isZoomSupported()) {
            return false;
        }
        Object object = this.mLock;
        synchronized (object) {
            Camera.Parameters params = this.mCamera.getParameters();
            float max = params.getMaxZoom();
            params.setZoom((int)(zoom * max));
            this.mCamera.setParameters(params);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean setExposureCorrection(float EVvalue) {
        if (!this.isCameraAvailable()) {
            return false;
        }
        if (!this.mOptions.isExposureCorrectionSupported()) {
            return false;
        }
        float max = this.mOptions.getExposureCorrectionMaxValue();
        float min = this.mOptions.getExposureCorrectionMinValue();
        EVvalue = EVvalue < min ? min : (EVvalue > max ? max : EVvalue);
        Object object = this.mLock;
        synchronized (object) {
            Camera.Parameters params = this.mCamera.getParameters();
            int indexValue = (int)(EVvalue / params.getExposureCompensationStep());
            params.setExposureCompensation(indexValue);
            this.mCamera.setParameters(params);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    boolean startAutoFocus(final @Nullable Gesture gesture, PointF point) {
        if (!this.isCameraAvailable()) {
            return false;
        }
        if (!this.mOptions.isAutoFocusSupported()) {
            return false;
        }
        final PointF p = new PointF(point.x, point.y);
        List<Camera.Area> meteringAreas2 = this.computeMeteringAreas(p.x, p.y);
        List<Camera.Area> meteringAreas1 = meteringAreas2.subList(0, 1);
        Object object = this.mLock;
        synchronized (object) {
            Camera.Parameters params = this.mCamera.getParameters();
            int maxAF = params.getMaxNumFocusAreas();
            int maxAE = params.getMaxNumMeteringAreas();
            if (maxAF > 0) {
                params.setFocusAreas(maxAF > 1 ? meteringAreas2 : meteringAreas1);
            }
            if (maxAE > 0) {
                params.setMeteringAreas(maxAE > 1 ? meteringAreas2 : meteringAreas1);
            }
            params.setFocusMode("auto");
            this.mCamera.setParameters(params);
            this.mCameraCallbacks.dispatchOnFocusStart(gesture, p);
            this.mCamera.autoFocus(new Camera.AutoFocusCallback(){

                public void onAutoFocus(boolean success, Camera camera) {
                    Camera1.this.mCameraCallbacks.dispatchOnFocusEnd(gesture, success, p);
                    Camera1.this.mHandler.get().removeCallbacks(Camera1.this.mPostFocusResetRunnable);
                    Camera1.this.mHandler.get().postDelayed(Camera1.this.mPostFocusResetRunnable, 3000L);
                }
            });
        }
        return true;
    }

    private List<Camera.Area> computeMeteringAreas(double viewClickX, double viewClickY) {
        int displayToSensor = -this.computeSensorToDisplayOffset();
        double viewWidth = this.mPreview.getView().getWidth();
        double viewHeight = this.mPreview.getView().getHeight();
        viewClickX = -1000.0 + viewClickX / viewWidth * 2000.0;
        viewClickY = -1000.0 + viewClickY / viewHeight * 2000.0;
        double theta = (double)displayToSensor * Math.PI / 180.0;
        double sensorClickX = viewClickX * Math.cos(theta) - viewClickY * Math.sin(theta);
        double sensorClickY = viewClickX * Math.sin(theta) + viewClickY * Math.cos(theta);
        LOG.i("focus:", "viewClickX:", viewClickX, "viewClickY:", viewClickY);
        LOG.i("focus:", "sensorClickX:", sensorClickX, "sensorClickY:", sensorClickY);
        Rect rect1 = this.computeMeteringArea(sensorClickX, sensorClickY, 150.0);
        int weight1 = 1000;
        Rect rect2 = this.computeMeteringArea(sensorClickX, sensorClickY, 300.0);
        int weight2 = 100;
        ArrayList<Camera.Area> list = new ArrayList<Camera.Area>(2);
        list.add(new Camera.Area(rect1, weight1));
        list.add(new Camera.Area(rect2, weight2));
        return list;
    }

    private Rect computeMeteringArea(double centerX, double centerY, double size) {
        double delta = size / 2.0;
        int top = (int)Math.max(centerY - delta, -1000.0);
        int bottom = (int)Math.min(centerY + delta, 1000.0);
        int left = (int)Math.max(centerX - delta, -1000.0);
        int right = (int)Math.min(centerX + delta, 1000.0);
        LOG.i("focus:", "computeMeteringArea:", "top:", top, "left:", left, "bottom:", bottom, "right:", right);
        return new Rect(left, top, right, bottom);
    }

    @Nullable
    private static List<Size> sizesFromList(List<Camera.Size> sizes) {
        if (sizes == null) {
            return null;
        }
        ArrayList<Size> result = new ArrayList<Size>(sizes.size());
        for (Camera.Size size : sizes) {
            result.add(new Size(size.width, size.height));
        }
        LOG.i("size:", "sizesFromList:", result);
        return result;
    }

    private static Size matchSize(List<Size> sizes, AspectRatio targetRatio, Size biggerThan, boolean biggestPossible) {
        if (sizes == null) {
            return null;
        }
        ArrayList<Size> consistent = new ArrayList<Size>(5);
        ArrayList<Size> bigEnoughAndConsistent = new ArrayList<Size>(5);
        Size targetSize = biggerThan;
        for (Size size : sizes) {
            AspectRatio ratio = AspectRatio.of(size.getWidth(), size.getHeight());
            if (!ratio.equals(targetRatio)) continue;
            consistent.add(size);
            if (size.getHeight() < targetSize.getHeight() || size.getWidth() < targetSize.getWidth()) continue;
            bigEnoughAndConsistent.add(size);
        }
        LOG.i("size:", "matchSize:", "found consistent:", consistent.size());
        LOG.i("size:", "matchSize:", "found big enough and consistent:", bigEnoughAndConsistent.size());
        Size result = biggestPossible ? (bigEnoughAndConsistent.size() > 0 ? (Size)Collections.max(bigEnoughAndConsistent) : (consistent.size() > 0 ? (Size)Collections.max(consistent) : Collections.max(sizes))) : (bigEnoughAndConsistent.size() > 0 ? (Size)Collections.min(bigEnoughAndConsistent) : (consistent.size() > 0 ? (Size)Collections.max(consistent) : Collections.max(sizes)));
        LOG.i("size", "matchSize:", "returning result", result);
        return result;
    }
}

