/*
 * Decompiled with CFR 0.152.
 */
package com.otaliastudios.cameraview;

import android.os.Parcel;
import android.os.Parcelable;
import android.support.annotation.NonNull;
import android.util.SparseArray;
import com.otaliastudios.cameraview.Size;

public class AspectRatio
implements Comparable<AspectRatio>,
Parcelable {
    static final SparseArray<SparseArray<AspectRatio>> sCache = new SparseArray(16);
    private final int mX;
    private final int mY;
    public static final Parcelable.Creator<AspectRatio> CREATOR = new Parcelable.Creator<AspectRatio>(){

        public AspectRatio createFromParcel(Parcel source) {
            int x = source.readInt();
            int y = source.readInt();
            return AspectRatio.of(x, y);
        }

        public AspectRatio[] newArray(int size) {
            return new AspectRatio[size];
        }
    };

    private AspectRatio(int x, int y) {
        this.mX = x;
        this.mY = y;
    }

    public int getX() {
        return this.mX;
    }

    public int getY() {
        return this.mY;
    }

    public boolean matches(Size size) {
        int gcd = AspectRatio.gcd(size.getWidth(), size.getHeight());
        int x = size.getWidth() / gcd;
        int y = size.getHeight() / gcd;
        return this.mX == x && this.mY == y;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (o instanceof AspectRatio) {
            AspectRatio ratio = (AspectRatio)o;
            return this.mX == ratio.mX && this.mY == ratio.mY;
        }
        return false;
    }

    public String toString() {
        return this.mX + ":" + this.mY;
    }

    public float toFloat() {
        return (float)this.mX / (float)this.mY;
    }

    public int hashCode() {
        return this.mY ^ (this.mX << 16 | this.mX >>> 16);
    }

    @Override
    public int compareTo(@NonNull AspectRatio another) {
        if (this.equals(another)) {
            return 0;
        }
        if (this.toFloat() - another.toFloat() > 0.0f) {
            return 1;
        }
        return -1;
    }

    public AspectRatio inverse() {
        return AspectRatio.of(this.mY, this.mX);
    }

    public static AspectRatio of(int x, int y) {
        int gcd = AspectRatio.gcd(x, y);
        y /= gcd;
        SparseArray arrayX = (SparseArray)sCache.get(x /= gcd);
        if (arrayX == null) {
            AspectRatio ratio = new AspectRatio(x, y);
            arrayX = new SparseArray();
            arrayX.put(y, (Object)ratio);
            sCache.put(x, (Object)arrayX);
            return ratio;
        }
        AspectRatio ratio = (AspectRatio)arrayX.get(y);
        if (ratio == null) {
            ratio = new AspectRatio(x, y);
            arrayX.put(y, (Object)ratio);
        }
        return ratio;
    }

    private static int gcd(int a, int b) {
        while (b != 0) {
            int c = b;
            b = a % b;
            a = c;
        }
        return a;
    }

    public int describeContents() {
        return 0;
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeInt(this.mX);
        dest.writeInt(this.mY);
    }
}

