/*
 * Decompiled with CFR 0.152.
 */
package com.osbcp.cssparser;

import com.osbcp.cssparser.PropertyValue;
import com.osbcp.cssparser.Selector;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class Rule {
    private List<Selector> selectors;
    private List<PropertyValue> propertyValues;

    public Rule(Selector selector) {
        this();
        this.selectors.add(selector);
    }

    public Rule() {
        this(new ArrayList<Selector>());
    }

    public Rule(List<Selector> selectors) {
        this.selectors = selectors;
        this.propertyValues = new ArrayList<PropertyValue>();
    }

    public String toString() {
        StringBuilder out = new StringBuilder();
        out.append(this.implode(this.selectors) + " {\n");
        for (PropertyValue propertyValue : this.propertyValues) {
            out.append("\t" + propertyValue + ";\n");
        }
        out.append("}\n");
        return out.toString();
    }

    public void addPropertyValue(PropertyValue propertyValue) {
        this.propertyValues.add(propertyValue);
    }

    public List<PropertyValue> getPropertyValues() {
        return this.propertyValues;
    }

    public List<Selector> getSelectors() {
        return this.selectors;
    }

    public void addSelectors(List<Selector> selectors) {
        this.selectors.addAll(selectors);
    }

    private String implode(List<Selector> values) {
        StringBuilder sb = new StringBuilder();
        Iterator<Selector> iterator = values.iterator();
        while (iterator.hasNext()) {
            Selector selector = iterator.next();
            sb.append(selector.toString());
            if (!iterator.hasNext()) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public void removePropertyValue(PropertyValue propertyValue) {
        this.propertyValues.remove(propertyValue);
    }

    public void addSelector(Selector selector) {
        this.selectors.add(selector);
    }

    public void removeSelector(Selector selector) {
        this.selectors.remove(selector);
    }
}

