/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * 
 * See the NOTICE file distributed with this work for additional
 * information regarding copyright ownership.
 */

package com.osbcp.cssparser;

/**
 * List of known characters.
 * 
 * @author <a href="mailto:christoffer@christoffer.me">Christoffer Pettersson</a>
 */

final class Chars {

	/**
	 * The character '*'.
	 */

	static final Character STAR = '*';

	/**
	 * The character '/'.
	 */
	static final Character SLASH = '/';

	/**
	 * The character ','.
	 */
	static final Character COMMA = ',';

	/**
	 * The character '{'.
	 */
	static final Character BRACKET_BEG = '{';

	/**
	 * The character '}'.
	 */
	static final Character BRACKET_END = '}';

	/**
	 * The character ':'.
	 */
	static final Character COLON = ':';

	/**
	 * The character ';'.
	 */
	static final Character SEMI_COLON = ';';

	/**
	 * The character '('.
	 */
	static final Character ROUND_BRACKET_BEG = '(';

	/**
	 * The character ')'.
	 */
	static final Character ROUND_BRACKET_END = ')';

}
