/*
 * Decompiled with CFR 0.152.
 */
package com.osacky.flank.gradle;

import com.osacky.flank.gradle.ProjectExtensionsKt;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Project;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.tasks.JavaExec;
import org.gradle.util.GradleVersion;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Flank executions are dependent on resources such as network connection and server and therefore cannot be cached.")
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0017\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u000e\u0010\u0005\u001a\u00020\u00012\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/osacky/flank/gradle/FlankJavaExec;", "Lorg/gradle/api/tasks/JavaExec;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "(Lorg/gradle/api/file/ProjectLayout;)V", "setUpWorkingDir", "configName", "", "fladle"})
public class FlankJavaExec
extends JavaExec {
    @NotNull
    public final JavaExec setUpWorkingDir(@NotNull String configName) {
        Intrinsics.checkNotNullParameter((Object)configName, (String)"configName");
        Project project = this.getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"project");
        ProjectLayout projectLayout = project.getLayout();
        Intrinsics.checkNotNullExpressionValue((Object)projectLayout, (String)"project.layout");
        JavaExec javaExec = this.workingDir(projectLayout.getBuildDirectory().dir("fladle/" + configName));
        Intrinsics.checkNotNullExpressionValue((Object)javaExec, (String)"workingDir(project.layou\u2026ir(\"fladle/$configName\"))");
        return javaExec;
    }

    @Inject
    public FlankJavaExec(@NotNull ProjectLayout projectLayout) {
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        this.setGroup("fladle");
        if (GradleVersion.current().compareTo(GradleVersion.version((String)"6.4")) >= 0) {
            this.getMainClass().set((Object)"ftl.Main");
        } else {
            this.setMain("ftl.Main");
        }
        this.workingDir(ProjectExtensionsKt.getFladleDir(projectLayout));
    }
}

