/*
 * Decompiled with CFR 0.152.
 */
package com.osacky.flank.gradle;

import com.osacky.flank.gradle.FladleConfig;
import com.osacky.flank.gradle.FlankJavaExec;
import javax.inject.Inject;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.Action;
import org.gradle.api.Task;
import org.gradle.api.file.ProjectLayout;
import org.gradle.api.file.RegularFile;
import org.gradle.api.tasks.Nested;
import org.gradle.work.DisableCachingByDefault;
import org.jetbrains.annotations.NotNull;

@DisableCachingByDefault(because="Flank executions are dependent on resources such as network connection and server and therefore cannot be cached.")
@Metadata(mv={1, 4, 3}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0002\b\u0017\u0018\u00002\u00020\u0001B\u0017\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0010\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u0005H\u0002R\u0013\u0010\u0004\u001a\u00020\u00058\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\b\u00a8\u0006\f"}, d2={"Lcom/osacky/flank/gradle/FlankExecutionTask;", "Lcom/osacky/flank/gradle/FlankJavaExec;", "projectLayout", "Lorg/gradle/api/file/ProjectLayout;", "config", "Lcom/osacky/flank/gradle/FladleConfig;", "(Lorg/gradle/api/file/ProjectLayout;Lcom/osacky/flank/gradle/FladleConfig;)V", "getConfig", "()Lcom/osacky/flank/gradle/FladleConfig;", "checkFilesExist", "", "base", "fladle"})
public class FlankExecutionTask
extends FlankJavaExec {
    @NotNull
    private final FladleConfig config;

    private final void checkFilesExist(FladleConfig base) {
        if (base.getServiceAccountCredentials().isPresent()) {
            Object object = base.getServiceAccountCredentials().get();
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"base.serviceAccountCredentials.get()");
            boolean bl = ((RegularFile)object).getAsFile().exists();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "serviceAccountCredential file doesn't exist " + (RegularFile)base.getServiceAccountCredentials().get();
                throw (Throwable)new IllegalStateException(string.toString());
            }
        }
    }

    @Nested
    @NotNull
    public final FladleConfig getConfig() {
        return this.config;
    }

    @Inject
    public FlankExecutionTask(@NotNull ProjectLayout projectLayout, @NotNull FladleConfig config) {
        Intrinsics.checkNotNullParameter((Object)projectLayout, (String)"projectLayout");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        super(projectLayout);
        this.config = config;
        this.doFirst(new Action(){

            public final void execute(@NotNull Task $this$doFirst) {
                Intrinsics.checkNotNullParameter((Object)$this$doFirst, (String)"$receiver");
                this.checkFilesExist(this.getConfig());
            }
        });
    }
}

