package com.ornach.magicicon;


import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.AttributeSet;

public class IconView extends android.support.v7.widget.AppCompatImageView {

	public static final int SHAPE_RECTANGLE = 101;
	public static final int SHAPE_OVAL = 102;

	private static final String TAG = IconView.class.getSimpleName();

	private Typeface iconTypeface = null;

	private Context context;
	private int src = 0;

	private int typefaceCode = 0;
	private int iconColor = 0xFF000000;
	private String fontText = "", fontDefault = "";
	private final int defaultFontSize = 100;
	private int fontSize = defaultFontSize;

	private int fpadding = 30, padding = 30, paddingLeft = 30, paddingTop = 30, paddingRight = 30, paddingBottom = 30;

	private int backgroundColor = 0;
	private int focusColor = Color.GRAY;
	private int disabledColor = Color.GRAY;
	private int shape = SHAPE_RECTANGLE;
	private int borderWidth = 0;
	private int borderColor = Color.TRANSPARENT;
	private float radius = 0;


	public IconView(Context context) {
		super(context);
		this.context = context;
		initializeView();
	}

	public IconView(Context context, AttributeSet attrs) {
		super(context, attrs);
		this.context = context;

		processAttributes(context, attrs);

		initializeView();
	}

	public IconView(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
		this.context = context;

		processAttributes(context, attrs);

		initializeView();
	}

	/*@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
	public IconView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
		super(context, attrs, defStyleAttr, defStyleRes);
	}*/

	private void processAttributes(final Context context, final AttributeSet attrs) {

		if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR1)
			initDefaultAttributes(attrs);
		else
			initDefaultAttributes17(attrs);


		TypedArray attrsArray = context.obtainStyledAttributes(attrs, R.styleable.IconView, 0, 0);
		initAttributes(attrsArray);
		attrsArray.recycle();
	}


	private void initDefaultAttributes(AttributeSet attrs) {
		int[] defAttr = new int[]{
			  android.R.attr.padding,
			  android.R.attr.paddingLeft,
			  android.R.attr.paddingTop,
			  android.R.attr.paddingRight,
			  android.R.attr.paddingBottom,
			  android.R.attr.src
		};

		TypedArray defAttrsArray = context.obtainStyledAttributes(attrs, defAttr);

		padding = defAttrsArray.getDimensionPixelSize(0, padding);
		paddingLeft = paddingTop = paddingRight = paddingBottom = padding;

		paddingLeft = defAttrsArray.getDimensionPixelSize(1, paddingLeft);
		paddingTop = defAttrsArray.getDimensionPixelSize(2, paddingTop);
		paddingRight = defAttrsArray.getDimensionPixelSize(3, paddingRight);
		paddingBottom = defAttrsArray.getDimensionPixelSize(4, paddingBottom);

		src = defAttrsArray.getResourceId(5, src);

		defAttrsArray.recycle();

	}

	@RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR1)
	private void initDefaultAttributes17(AttributeSet attrs) {
		int[] defAttr = new int[]{
			  android.R.attr.padding,
			  android.R.attr.paddingLeft,
			  android.R.attr.paddingTop,
			  android.R.attr.paddingRight,
			  android.R.attr.paddingBottom,
			  android.R.attr.paddingStart,
			  android.R.attr.paddingEnd,
			  android.R.attr.src
		};

		TypedArray defAttrsArray = context.obtainStyledAttributes(attrs, defAttr);

		padding = defAttrsArray.getDimensionPixelSize(0, padding);
		paddingLeft = paddingTop = paddingRight = paddingBottom = padding;

		paddingLeft = defAttrsArray.getDimensionPixelSize(1, paddingLeft);
		paddingTop = defAttrsArray.getDimensionPixelSize(2, paddingTop);
		paddingRight = defAttrsArray.getDimensionPixelSize(3, paddingRight);
		paddingBottom = defAttrsArray.getDimensionPixelSize(4, paddingBottom);
		paddingLeft = defAttrsArray.getDimensionPixelSize(5, paddingLeft);
		paddingRight = defAttrsArray.getDimensionPixelSize(6, paddingRight);

		src = defAttrsArray.getResourceId(7, src);

		defAttrsArray.recycle();

	}


	private void initAttributes(TypedArray attrs) {

		iconColor = attrs.getColor(R.styleable.IconView_mi_iconColor, iconColor);
		fontText = attrs.getString(R.styleable.IconView_mi_fontText);
		typefaceCode = attrs.getInt(R.styleable.IconView_mi_typeface, FontHelper.getDefaultFontCode());

		backgroundColor = attrs.getColor(R.styleable.IconView_mi_backgroundColor, backgroundColor);
		shape = attrs.getInt(R.styleable.IconView_mi_shape, shape);

		borderWidth = attrs.getDimensionPixelSize(R.styleable.IconView_mi_borderWidth, borderWidth);
		borderColor = attrs.getInt(R.styleable.IconView_mi_borderColor, borderColor);

		radius = attrs.getDimension(R.styleable.IconView_mi_radius, radius);

	}


	private void initializeView() {

		if (!isInEditMode()) {
			iconTypeface = FontHelper.getTypeface(context, typefaceCode);
		}

		//Log.e("TAG", "typefaceCode "+typefaceCode);

		setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);

		if (getDrawable() != null) {
			changeBitmapColor();
		} else if (!TextUtils.isEmpty(fontText)) {
			setImageBitmap(textToBitmap(fontText, fontSize, iconColor));
		}


		updateDrawable();

	}


	private void updateDrawable() {
		// setup background
		DrawableHelper helper = new DrawableHelper.Builder()
			  .setBackgroundColor(backgroundColor)
			  //.setFocusColor(focusColor)
			  .setShape(shape)
			  .setDisabledColor(disabledColor)
			  .setBorderWidth(borderWidth)
			  .setBorderColor(borderColor)
			  .setRadius((int) radius)
			  .build();

		helper.setBackground(this, false);
	}


	private Bitmap textToBitmap(String text, int textSize, int textColor) {

		if (text == null || text.isEmpty()) {
			text = fontDefault;
		}
		//Log.e("TAG", "Text "+text);
		float tSize = textSize != 0 ? textSize : this.defaultFontSize;
		Paint paint = new Paint(Paint.ANTI_ALIAS_FLAG);
		paint.setColor(textColor);
		paint.setTextSize(tSize);
		if (iconTypeface != null) {
			paint.setTypeface(iconTypeface);
		} else {
			text = "o";
		}


		paint.setTextAlign(Paint.Align.LEFT);
		float baseline = -paint.ascent(); // ascent() is negative
		/*int width = (int) (paint.measureText(text) + 0.5f); // round
		int height = (int) (baseline + paint.descent() + 0.5f);*/
		int width = (int) (paint.measureText(text) < 1 ? 100 : paint.measureText(text) + 0.5f); // round
		int height = (int) ((baseline + paint.descent()) < 1 ? 100 : baseline + paint.descent() + 0.5f);
		//Log.e("TAG", "IconView TextToBitmap " + width + "  " + height);
		Bitmap image = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
		Canvas canvas = new Canvas(image);
		canvas.drawText(text, 0, baseline, paint);
		//Log.e(TAG, image.getWidth()+"  "+ image.getHeight());
		return image;
	}


	private void changeBitmapColor() {

		if (iconColor == 0) {
			return;
		}


		/*Bitmap sourceBitmap = getBitmap();

		Bitmap resultBitmap = Bitmap.createBitmap(sourceBitmap, 0, 0,
			  sourceBitmap.getWidth() - 1, sourceBitmap.getHeight() - 1);
		Paint p = new Paint();
		//ColorFilter filter = new LightingColorFilter(color, 1);
		ColorFilter filter = new LightingColorFilter(iconColor, iconColor);
		p.setColorFilter(filter);
		p.setAntiAlias(true);
		//setImageBitmap(resultBitmap);

		Canvas canvas = new Canvas(resultBitmap);
		canvas.drawBitmap(resultBitmap, 0, 0, p);

		setImageBitmap(resultBitmap);*/

		setColorFilter(iconColor);

	}



	public void setFontText(String icon) {
		this.fontText = icon;
		setImageBitmap(textToBitmap(fontText, fontSize, iconColor));
	}

	public void setTypeface(int typeface) {
		this.typefaceCode = typeface;
		this.iconTypeface = FontHelper.getTypeface(context, this.typefaceCode);
		setImageBitmap(textToBitmap(fontText, fontSize, iconColor));
	}


	public void setFontSize(int size) {
		this.fontSize = size;
		setImageBitmap(textToBitmap(fontText, fontSize, iconColor));
	}

	public int getFontSize() {
		return this.fontSize;
	}

	public void setIconColor(@ColorInt int color) {
		this.iconColor = color;
		//setImageBitmap(textToBitmap(fontText, fontSize, iconColor));
		changeBitmapColor();
	}

	public int getIconColor() {
		return this.iconColor;
	}

	public void setBackgroundColor(@ColorInt int backgroundColor) {
		this.backgroundColor = backgroundColor;
		updateDrawable();
	}

	public int getBackgroundColor() {
		return this.backgroundColor;
	}

	public void setShape(int shape) {
		this.shape = shape;
		updateDrawable();
	}

	public int getShape() {
		return this.shape;
	}


	public void setBorderWidth(int width) {
		this.borderWidth = width;
		updateDrawable();
	}

	public int getBorderWidth() {
		return this.borderWidth;
	}

	public void setBorderColor(@ColorInt int color) {
		this.borderColor = color;
		updateDrawable();
	}

	public int getBorderColor() {
		return borderColor;
	}

	public void setRadius(int radius) {
		this.radius = radius;
		updateDrawable();
	}

	public float getRadius() {
		return radius;
	}


}
