/*
 * Decompiled with CFR 0.152.
 */
package com.ornach.magicicon;

import android.content.Context;
import android.content.res.AssetManager;
import android.graphics.Typeface;

public class FontHelper {
    private static final String TYPEFACE_MATERIAL_ICON = "fonts/material-icons-regular.ttf";
    private static final String TYPEFACE_AWESOME = "fonts/fontawesome-webfont.ttf";
    private static final String TYPEFACE_IONICONS = "fonts/ionicons.ttf";
    public static final int MATERIAL_ICON = 1001;
    public static final int FONT_AWESOME = 1002;
    public static final int IONICONS = 1003;

    protected static Typeface getMaterialIconTypeface(Context context) {
        return Typeface.createFromAsset((AssetManager)context.getAssets(), (String)TYPEFACE_MATERIAL_ICON);
    }

    protected static Typeface getAwesomeTypeface(Context context) {
        return Typeface.createFromAsset((AssetManager)context.getAssets(), (String)TYPEFACE_AWESOME);
    }

    protected static Typeface getIoniconsTypeface(Context context) {
        return Typeface.createFromAsset((AssetManager)context.getAssets(), (String)TYPEFACE_IONICONS);
    }

    protected static Typeface getTypeface(Context context, int typefaceCode) {
        Typeface iconTypeface = null;
        switch (typefaceCode) {
            case 1003: {
                iconTypeface = FontHelper.getIoniconsTypeface(context);
                break;
            }
            case 1002: {
                iconTypeface = FontHelper.getAwesomeTypeface(context);
                break;
            }
            default: {
                iconTypeface = FontHelper.getMaterialIconTypeface(context);
            }
        }
        return iconTypeface;
    }

    protected static int getDefaultFontCode() {
        return 1001;
    }
}

