/*
 * Decompiled with CFR 0.152.
 */
package com.ornach.magicicon;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.annotation.RequiresApi;
import android.support.v7.widget.AppCompatImageView;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import com.ornach.magicicon.DrawableHelper;
import com.ornach.magicicon.FontHelper;
import com.ornach.magicicon.R;

public class IconButton
extends AppCompatImageView {
    public static final int SHAPE_RECTANGLE = 101;
    public static final int SHAPE_OVAL = 102;
    private static final String TAG = IconButton.class.getSimpleName();
    private Typeface iconTypeface = null;
    private Context context;
    private int src = 0;
    private int typefaceCode = 0;
    private int iconColor = 0;
    private String fontText = "";
    private String fontDefault = "";
    private int fontSize = 100;
    private int fpadding = 30;
    private int padding = 30;
    private int paddingLeft = 30;
    private int paddingTop = 30;
    private int paddingRight = 30;
    private int paddingBottom = 30;
    private int backgroundColor = 0;
    private int focusColor = -3355444;
    private int disabledColor = -7829368;
    private int shape = 101;
    private int borderWidth = 0;
    private int borderColor = 0;
    private float radius = 0.0f;
    private boolean isEnabled = true;

    public IconButton(Context context) {
        super(context);
        this.context = context;
        this.initializeView();
    }

    public IconButton(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.context = context;
        this.processAttributes(context, attrs);
        this.initializeView();
    }

    public IconButton(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.context = context;
        this.processAttributes(context, attrs);
        this.initializeView();
    }

    private void processAttributes(Context context, AttributeSet attrs) {
        if (Build.VERSION.SDK_INT < 17) {
            this.initDefaultAttributes(attrs);
        } else {
            this.initDefaultAttributes17(attrs);
        }
        TypedArray attrsArray = context.obtainStyledAttributes(attrs, R.styleable.IconButton, 0, 0);
        this.initAttributes(attrsArray);
        attrsArray.recycle();
    }

    private void initDefaultAttributes(AttributeSet attrs) {
        int[] defAttr = new int[]{16842965, 16842966, 16842967, 16842968, 16842969, 0x1010119};
        TypedArray defAttrsArray = this.context.obtainStyledAttributes(attrs, defAttr);
        if (defAttrsArray.hasValue(0)) {
            this.paddingRight = this.paddingBottom = (this.padding = defAttrsArray.getDimensionPixelSize(0, this.padding));
            this.paddingTop = this.paddingBottom;
            this.paddingLeft = this.paddingBottom;
        }
        this.paddingLeft = defAttrsArray.getDimensionPixelSize(1, this.paddingLeft);
        this.paddingTop = defAttrsArray.getDimensionPixelSize(2, this.paddingTop);
        this.paddingRight = defAttrsArray.getDimensionPixelSize(3, this.paddingRight);
        this.paddingBottom = defAttrsArray.getDimensionPixelSize(4, this.paddingBottom);
        this.src = defAttrsArray.getResourceId(5, this.src);
        defAttrsArray.recycle();
    }

    @RequiresApi(api=17)
    private void initDefaultAttributes17(AttributeSet attrs) {
        int[] defAttr = new int[]{16842965, 16842966, 16842967, 16842968, 16842969, 16843699, 16843700, 0x1010119};
        TypedArray defAttrsArray = this.context.obtainStyledAttributes(attrs, defAttr);
        this.paddingRight = this.paddingBottom = (this.padding = defAttrsArray.getDimensionPixelSize(0, this.padding));
        this.paddingTop = this.paddingBottom;
        this.paddingLeft = this.paddingBottom;
        this.paddingLeft = defAttrsArray.getDimensionPixelSize(1, this.paddingLeft);
        this.paddingTop = defAttrsArray.getDimensionPixelSize(2, this.paddingTop);
        this.paddingRight = defAttrsArray.getDimensionPixelSize(3, this.paddingRight);
        this.paddingBottom = defAttrsArray.getDimensionPixelSize(4, this.paddingBottom);
        this.paddingLeft = defAttrsArray.getDimensionPixelSize(5, this.paddingLeft);
        this.paddingRight = defAttrsArray.getDimensionPixelSize(6, this.paddingRight);
        this.src = defAttrsArray.getResourceId(7, this.src);
        defAttrsArray.recycle();
    }

    private void initAttributes(TypedArray attrs) {
        this.iconColor = attrs.getColor(R.styleable.IconButton_mi_iconColor, this.iconColor);
        this.fontText = attrs.getString(R.styleable.IconButton_mi_fontText);
        this.typefaceCode = attrs.getInt(R.styleable.IconButton_mi_typeface, FontHelper.getDefaultFontCode());
        this.backgroundColor = attrs.getColor(R.styleable.IconButton_mi_backgroundColor, this.backgroundColor);
        this.disabledColor = attrs.getColor(R.styleable.IconButton_mi_disabledColor, this.disabledColor);
        this.focusColor = attrs.getColor(R.styleable.IconButton_mi_focusColor, this.focusColor);
        this.shape = attrs.getInt(R.styleable.IconButton_mi_shape, this.shape);
        this.borderWidth = attrs.getDimensionPixelSize(R.styleable.IconButton_mi_borderWidth, this.borderWidth);
        this.borderColor = attrs.getInt(R.styleable.IconButton_mi_borderColor, this.borderColor);
        this.radius = attrs.getDimension(R.styleable.IconButton_mi_radius, this.radius);
        this.isEnabled = attrs.getBoolean(R.styleable.IconButton_mi_enabled, this.isEnabled);
    }

    private void initializeView() {
        this.setClickable(true);
        super.setEnabled(this.isEnabled);
        if (!this.isInEditMode()) {
            this.iconTypeface = FontHelper.getTypeface(this.context, this.typefaceCode);
        }
        super.setPadding(this.paddingLeft, this.paddingTop, this.paddingRight, this.paddingBottom);
        if (this.getDrawable() != null) {
            this.changeBitmapColor();
        } else if (!TextUtils.isEmpty((CharSequence)this.fontText)) {
            this.setImageBitmap(this.textToBitmap(this.fontText, this.fontSize, this.iconColor));
        }
        this.updateDrawable();
    }

    private void updateDrawable() {
        DrawableHelper helper = new DrawableHelper.Builder().setBackgroundColor(this.backgroundColor).setFocusColor(this.focusColor).setShape(this.shape).setDisabledColor(this.disabledColor).setBorderWidth(this.borderWidth).setBorderColor(this.borderColor).setRadius((int)this.radius).setEnabled(this.isEnabled).build();
        helper.setBackground((View)this);
    }

    private Bitmap textToBitmap(String text, int textSize, int textColor) {
        if (text == null || text.isEmpty()) {
            text = this.fontDefault;
        }
        float tSize = textSize != 0 ? (float)textSize : 100.0f;
        Paint paint = new Paint(1);
        paint.setColor(textColor);
        paint.setTextSize(tSize);
        if (this.iconTypeface != null) {
            paint.setTypeface(this.iconTypeface);
        } else {
            text = "o";
        }
        paint.setTextAlign(Paint.Align.LEFT);
        float baseline = -paint.ascent();
        int width = (int)(paint.measureText(text) + 0.5f);
        int height = (int)(baseline + paint.descent() + 0.5f);
        Bitmap image = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas canvas = new Canvas(image);
        canvas.drawText(text, 0.0f, baseline, paint);
        return image;
    }

    private void changeBitmapColor() {
        if (this.iconColor == 0) {
            return;
        }
        this.setColorFilter(this.iconColor);
    }

    public void setFontText(String icon) {
        this.fontText = icon;
        this.setImageBitmap(this.textToBitmap(this.fontText, this.fontSize, this.iconColor));
    }

    public void setTypeface(int typeface) {
        this.typefaceCode = typeface;
        this.iconTypeface = FontHelper.getTypeface(this.context, this.typefaceCode);
        this.setImageBitmap(this.textToBitmap(this.fontText, this.fontSize, this.iconColor));
    }

    public void setFontSize(int size) {
        this.fontSize = size;
        this.setImageBitmap(this.textToBitmap(this.fontText, this.fontSize, this.iconColor));
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setIconColor(@ColorInt int color) {
        this.iconColor = color;
        this.setImageBitmap(this.textToBitmap(this.fontText, this.fontSize, this.iconColor));
    }

    public int getIconColor() {
        return this.iconColor;
    }

    public void setBackgroundColor(@ColorInt int backgroundColor) {
        this.backgroundColor = backgroundColor;
        this.updateDrawable();
    }

    public int getBackgroundColor() {
        return this.backgroundColor;
    }

    public void setDisabledColor(@ColorInt int color) {
        this.disabledColor = color;
        this.updateDrawable();
    }

    public int getDisabledColor() {
        return this.disabledColor;
    }

    public void setFocusColor(int focusColor) {
        this.focusColor = focusColor;
        this.updateDrawable();
    }

    public int getFocusColor() {
        return this.focusColor;
    }

    public void setShape(int shape) {
        this.shape = shape;
        this.updateDrawable();
    }

    public int getShape() {
        return this.shape;
    }

    public void setBorderWidth(int width) {
        this.borderWidth = width;
        this.updateDrawable();
    }

    public int getBorderWidth() {
        return this.borderWidth;
    }

    public void setBorderColor(@ColorInt int color) {
        this.borderColor = color;
        this.updateDrawable();
    }

    public int getBorderColor() {
        return this.borderColor;
    }

    public void setRadius(int radius) {
        this.radius = radius;
        this.updateDrawable();
    }

    public float getRadius() {
        return this.radius;
    }
}

