package com.ornach.magicicon;


import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.Paint;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.widget.Button;

public class IconView extends android.support.v7.widget.AppCompatImageView {

	public static final int SHAPE_RECTANGLE = 101;
	public static final int SHAPE_OVAL = 102;

	private static final String TAG = Button.class.getSimpleName();

	private Typeface awesomeIconTypeFace = null;

	private Context context;
	private int src = 0;
	private int iconColor = 0;
	private String fontAwesome = "", fontDefault = "";
	private int fontSize = 100;

	private int fpadding = 30, padding = 30, paddingLeft = 30, paddingTop = 30, paddingRight = 30, paddingBottom = 30;

	private int backgroundColor = 0;
	private int focusColor = Color.GRAY;
	private int disabledColor = Color.GRAY;
	private int shape = SHAPE_RECTANGLE;
	private int borderWidth = 0;
	private int borderColor = Color.TRANSPARENT;
	private float radius = 0;


	public IconView(Context context) {
		super(context);
		this.context = context;
		initializeView();
	}

	public IconView(Context context, AttributeSet attrs) {
		super(context, attrs);
		this.context = context;

		processAttributes(context, attrs);

		initializeView();
	}

	public IconView(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
		this.context = context;

		processAttributes(context, attrs);

		initializeView();
	}

	/*@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
	public IconView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
		super(context, attrs, defStyleAttr, defStyleRes);
	}*/

	private void processAttributes(final Context context, final AttributeSet attrs) {

		if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR1)
			initDefaultAttributes(attrs);
		else
			initDefaultAttributes17(attrs);


		TypedArray attrsArray = context.obtainStyledAttributes(attrs, R.styleable.IconView, 0, 0);
		initAttributes(attrsArray);
		attrsArray.recycle();
	}


	private void initDefaultAttributes(AttributeSet attrs) {
		int[] defAttr = new int[]{
			  android.R.attr.padding,
			  android.R.attr.paddingLeft,
			  android.R.attr.paddingTop,
			  android.R.attr.paddingRight,
			  android.R.attr.paddingBottom,
			  android.R.attr.src
		};

		TypedArray defAttrsArray = context.obtainStyledAttributes(attrs, defAttr);

		padding = defAttrsArray.getDimensionPixelSize(0, padding);
		paddingLeft = paddingTop = paddingRight = paddingBottom = padding;

		paddingLeft = defAttrsArray.getDimensionPixelSize(1, paddingLeft);
		paddingTop = defAttrsArray.getDimensionPixelSize(2, paddingTop);
		paddingRight = defAttrsArray.getDimensionPixelSize(3, paddingRight);
		paddingBottom = defAttrsArray.getDimensionPixelSize(4, paddingBottom);

		src = defAttrsArray.getResourceId(5, src);

		defAttrsArray.recycle();

	}

	@RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR1)
	private void initDefaultAttributes17(AttributeSet attrs) {
		int[] defAttr = new int[]{
			  android.R.attr.padding,
			  android.R.attr.paddingLeft,
			  android.R.attr.paddingTop,
			  android.R.attr.paddingRight,
			  android.R.attr.paddingBottom,
			  android.R.attr.paddingStart,
			  android.R.attr.paddingEnd,
			  android.R.attr.src
		};

		TypedArray defAttrsArray = context.obtainStyledAttributes(attrs, defAttr);

		padding = defAttrsArray.getDimensionPixelSize(0, padding);
		paddingLeft = paddingTop = paddingRight = paddingBottom = padding;

		paddingLeft = defAttrsArray.getDimensionPixelSize(1, paddingLeft);
		paddingTop = defAttrsArray.getDimensionPixelSize(2, paddingTop);
		paddingRight = defAttrsArray.getDimensionPixelSize(3, paddingRight);
		paddingBottom = defAttrsArray.getDimensionPixelSize(4, paddingBottom);
		paddingLeft = defAttrsArray.getDimensionPixelSize(5, paddingLeft);
		paddingRight = defAttrsArray.getDimensionPixelSize(6, paddingRight);

		src = defAttrsArray.getResourceId(7, src);

		defAttrsArray.recycle();

	}


	private void initAttributes(TypedArray attrs) {

		iconColor = attrs.getColor(R.styleable.IconView_mi_iconColor, iconColor);
		fontAwesome = attrs.getString(R.styleable.IconView_mi_fontAwesome);

		backgroundColor = attrs.getColor(R.styleable.IconView_mi_backgroundColor, backgroundColor);
		shape = attrs.getInt(R.styleable.IconView_mi_shape, shape);

		borderWidth = attrs.getDimensionPixelSize(R.styleable.IconView_mi_borderWidth, borderWidth);
		borderColor = attrs.getInt(R.styleable.IconView_mi_borderColor, borderColor);

		radius = attrs.getDimension(R.styleable.IconView_mi_radius, radius);

	}


	private void initializeView() {

		if (!isInEditMode()) {
			awesomeIconTypeFace = FontHelper.getAwesomeTypeface(context);
		}

		setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);

		if (getDrawable() !=null) {
			changeBitmapColor();
		} else if (!TextUtils.isEmpty(fontAwesome)) {
			setImageBitmap(textToBitmap(fontAwesome, fontSize, iconColor));
		}


		// setup background
		DrawableHelper helper = new DrawableHelper.Builder()
			  .setBackgroundColor(backgroundColor)
			  //.setFocusColor(focusColor)
			  .setShape(shape)
			  .setDisabledColor(disabledColor)
			  .setBorderWidth(borderWidth)
			  .setBorderColor(borderColor)
			  .setRadius((int) radius)
			  .build();

		helper.setBackground(this, false);

	}


	private Bitmap textToBitmap(String text, int textSize, int textColor) {

		/*if (awesomeIconTypeFace == null) {
			return null;
		}*/
		if (text == null || text.isEmpty()) {
			text = fontDefault;
		}

		float tSize = textSize != 0 ? textSize : 100;
		Paint paint = new Paint(Paint.ANTI_ALIAS_FLAG);
		paint.setColor(textColor);

		if (awesomeIconTypeFace != null) {
			paint.setTypeface(awesomeIconTypeFace);
			paint.setTextSize(tSize + 5);
		} else {
			text = "o";
			paint.setTextSize(100);
		}


		paint.setTextAlign(Paint.Align.LEFT);
		float baseline = -paint.ascent(); // ascent() is negative
		int width = (int) (paint.measureText(text) + 0.5f); // round
		int height = (int) (baseline + paint.descent() + 0.5f);
		Bitmap image = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
		Canvas canvas = new Canvas(image);
		canvas.drawText(text, 0, baseline, paint);
		//Log.e(TAG, image.getWidth()+"  "+ image.getHeight());
		return image;
	}


	private void changeColor() {

		Bitmap sourceBitmap = ((BitmapDrawable) getDrawable()).getBitmap();
		//changeBitmapColor(sourceBitmap, iconColor);

	}

	private void changeBitmapColor() {

		if (iconColor == 0) {
			return;
		}

		Bitmap sourceBitmap = ((BitmapDrawable) getDrawable()).getBitmap();

		Bitmap resultBitmap = Bitmap.createBitmap(sourceBitmap, 0, 0,
			  sourceBitmap.getWidth() - 1, sourceBitmap.getHeight() - 1);

		// resultBitmap = resultBitmap.copy(Bitmap.Config.ARGB_8888, true);

		Paint p = new Paint();
		//ColorFilter filter = new LightingColorFilter(color, 1);
		ColorFilter filter = new LightingColorFilter(iconColor, iconColor);
		p.setColorFilter(filter);
		p.setAntiAlias(true);
		//setImageBitmap(resultBitmap);

		Canvas canvas = new Canvas(resultBitmap);
		canvas.drawBitmap(resultBitmap, 0, 0, p);

		setImageBitmap(resultBitmap);

	}

	private Bitmap changeColorBitmap() {

		Bitmap sourceBitmap = ((BitmapDrawable) getDrawable()).getBitmap();

		int width = sourceBitmap.getWidth();
		int height = sourceBitmap.getHeight();
		int[] pixels = new int[width * height];
		// get pixel array from source
		sourceBitmap.getPixels(pixels, 0, width, 0, 0, width, height);

		Bitmap bmOut = Bitmap.createBitmap(width, height, sourceBitmap.getConfig());

		int A, R, G, B;
		int pixel;

		// iteration through pixels
		for (int y = 0; y < height; ++y) {
			for (int x = 0; x < width; ++x) {
				// get current index in 2D-matrix
				int index = y * width + x;
				pixel = pixels[index];
				if (pixel != 0)

					//change A-RGB individually
				/*A = Color.alpha(pixel);
				R = Color.red(pixel);
				G = Color.green(pixel);
				B = Color.blue(pixel);
				pixels[index] = Color.argb(A, R, G, B); */
			  /*or change the whole color
			  pixels[index] = colorThatWillReplace;*/

					pixels[index] = iconColor;

			}
		}
		bmOut.setPixels(pixels, 0, width, 0, 0, width, height);
		return bmOut;
	}

}
