package com.ornach.magicicon;


import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.ColorFilter;
import android.graphics.LightingColorFilter;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.Typeface;
import android.graphics.drawable.BitmapDrawable;
import android.os.Build;
import android.support.annotation.RequiresApi;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.util.Log;

public class IconButton extends android.support.v7.widget.AppCompatImageView {

	public static final int SHAPE_RECTANGLE = 101;
	public static final int SHAPE_OVAL = 102;

	private static final String TAG = IconButton.class.getSimpleName();

	private Typeface awesomeIconTypeFace = null;

	private Context context;
	private int src = 0;
	private int iconColor = 0;
	//private String fontAwesome = "\uf03e", fontDefault = "\uf03e";
	private String fontAwesome = "", fontDefault = "";
	private int fontSize = 100;

	private int fpadding = 30, padding = 30, paddingLeft = 30, paddingTop = 30, paddingRight = 30, paddingBottom = 30;

	private int backgroundColor = 0;
	private int focusColor = 0xFFCCCCCC;
	private int disabledColor = Color.TRANSPARENT;
	private int shape = SHAPE_RECTANGLE;
	private int borderWidth = 0;
	private int borderColor = Color.TRANSPARENT;
	private float radius = 0;


	public IconButton(Context context) {
		super(context);
		this.context = context;
		initializeView();
		//Log.e("TAG", "IconView(Context context)");
	}

	public IconButton(Context context, AttributeSet attrs) {
		super(context, attrs);
		this.context = context;

		processAttributes(context, attrs);

		initializeView();
		//Log.e("TAG", "IconView(Context context, @Nullable AttributeSet attrs)");
	}

	public IconButton(Context context, AttributeSet attrs, int defStyleAttr) {
		super(context, attrs, defStyleAttr);
		this.context = context;

		processAttributes(context, attrs);

		initializeView();
		//Log.e("TAG", "IconView(Context context, @Nullable AttributeSet attrs, int defStyleAttr)");
	}

	/*@RequiresApi(api = Build.VERSION_CODES.LOLLIPOP)
	public IconView(Context context, @Nullable AttributeSet attrs, int defStyleAttr, int defStyleRes) {
		super(context, attrs, defStyleAttr, defStyleRes);
	}*/

	private void processAttributes(final Context context, final AttributeSet attrs) {
		if (Build.VERSION.SDK_INT < Build.VERSION_CODES.JELLY_BEAN_MR1)
			initDefaultAttributes(attrs);
		else
			initDefaultAttributes17(attrs);

		TypedArray attrsArray = context.obtainStyledAttributes(attrs, R.styleable.IconButton, 0, 0);
		initAttributes(attrsArray);
		attrsArray.recycle();
	}


	private void initDefaultAttributes(AttributeSet attrs) {
		int[] defAttr = new int[]{
			  android.R.attr.padding,
			  android.R.attr.paddingLeft,
			  android.R.attr.paddingTop,
			  android.R.attr.paddingRight,
			  android.R.attr.paddingBottom,
			  /*android.R.attr.paddingStart,
			  android.R.attr.paddingEnd,*/
			  android.R.attr.src
		};

		TypedArray defAttrsArray = context.obtainStyledAttributes(attrs, defAttr);

		if (defAttrsArray.hasValue(0)){
			padding = defAttrsArray.getDimensionPixelSize(0, padding);
			Log.e(TAG, "Padding " + padding + "");
			paddingLeft = paddingTop = paddingRight = paddingBottom = padding;
		}


		paddingLeft = defAttrsArray.getDimensionPixelSize(1, paddingLeft);
		paddingTop = defAttrsArray.getDimensionPixelSize(2, paddingTop);
		paddingRight = defAttrsArray.getDimensionPixelSize(3, paddingRight);
		paddingBottom = defAttrsArray.getDimensionPixelSize(4, paddingBottom);
		/*paddingLeft = defAttrsArray.getDimensionPixelSize(5, paddingLeft);
		paddingRight = defAttrsArray.getDimensionPixelSize(6, paddingRight);*/

		src = defAttrsArray.getResourceId(5,src);
		//Log.e(TAG, "src "+src+"");

		defAttrsArray.recycle();

	}

	@RequiresApi(api = Build.VERSION_CODES.JELLY_BEAN_MR1)
	private void initDefaultAttributes17(AttributeSet attrs) {
		int[] defAttr = new int[]{
			  android.R.attr.padding,
			  android.R.attr.paddingLeft,
			  android.R.attr.paddingTop,
			  android.R.attr.paddingRight,
			  android.R.attr.paddingBottom,
			  android.R.attr.paddingStart,
			  android.R.attr.paddingEnd,
			  android.R.attr.src
		};

		TypedArray defAttrsArray = context.obtainStyledAttributes(attrs, defAttr);


			padding = defAttrsArray.getDimensionPixelSize(0, padding);
			Log.e(TAG, "Padding " + padding + "");
			paddingLeft = paddingTop = paddingRight = paddingBottom = padding;



		paddingLeft = defAttrsArray.getDimensionPixelSize(1, paddingLeft);
		paddingTop = defAttrsArray.getDimensionPixelSize(2, paddingTop);

		paddingRight = defAttrsArray.getDimensionPixelSize(3, paddingRight);
		paddingBottom = defAttrsArray.getDimensionPixelSize(4, paddingBottom);
		paddingLeft = defAttrsArray.getDimensionPixelSize(5, paddingLeft);
		paddingRight = defAttrsArray.getDimensionPixelSize(6, paddingRight);

		src = defAttrsArray.getResourceId(7,src);
		Log.e(TAG, "src "+src+"");

		defAttrsArray.recycle();

	}


	private void initAttributes(TypedArray attrs) {

		iconColor = attrs.getColor(R.styleable.IconButton_iconColor, iconColor);
		fontAwesome = attrs.getString(R.styleable.IconButton_fontAwesome);

		backgroundColor = attrs.getColor(R.styleable.IconButton_backgroundColor, backgroundColor);
		focusColor = attrs.getColor(R.styleable.IconButton_focusColor, focusColor);
		shape = attrs.getInt(R.styleable.IconButton_shape, shape);

		borderWidth = attrs.getDimensionPixelSize(R.styleable.IconButton_borderWidth, borderWidth);
		borderColor = attrs.getInt(R.styleable.IconButton_borderColor, borderColor);

		radius = attrs.getDimension(R.styleable.IconButton_radius, radius);

	}


	private void initializeView() {
		setClickable(true);

		if (!isInEditMode()) {
			awesomeIconTypeFace = FontHelper.getAwesomeTypeface(context);
		}

		setPadding(paddingLeft, paddingTop, paddingRight, paddingBottom);

		if (getDrawable() !=null) {

			changeBitmapColor();

		} else if (!TextUtils.isEmpty(fontAwesome)) {

			setImageBitmap(textToBitmap(fontAwesome, fontSize, iconColor));
		}


		// setup background
		DrawableHelper helper = new DrawableHelper.Builder()
			  .setBackgroundColor(backgroundColor)
			  .setFocusColor(focusColor)
			  .setShape(shape)
			  .setDisabledColor(disabledColor)
			  .setBorderWidth(borderWidth)
			  .setBorderColor(borderColor)
			  .setRadius((int) radius)
			  .build();

		helper.setBackground(this, true);

	}


	private Bitmap textToBitmap(String text, int textSize, int textColor) {

		/*if (awesomeIconTypeFace == null) {
			return null;
		}*/
		if (text == null || text.isEmpty()) {
			text = fontDefault;
		}

		float tSize = textSize != 0 ? textSize : 100;
		Paint paint = new Paint(Paint.ANTI_ALIAS_FLAG);
		paint.setColor(textColor);

		if (awesomeIconTypeFace != null) {
			paint.setTypeface(awesomeIconTypeFace);
			paint.setTextSize(tSize + 5);
		} else {
			text = "o";
			paint.setTextSize(100);
		}


		paint.setTextAlign(Paint.Align.LEFT);
		float baseline = -paint.ascent(); // ascent() is negative
		int width = (int) (paint.measureText(text) + 0.5f); // round
		int height = (int) (baseline + paint.descent() + 0.5f);
		Bitmap image = Bitmap.createBitmap(width, height, Bitmap.Config.ARGB_8888);
		Canvas canvas = new Canvas(image);
		canvas.drawText(text, 0, baseline, paint);
		//Log.e(TAG, image.getWidth()+"  "+ image.getHeight());
		return image;
	}


	private void changeColor() {

		Bitmap sourceBitmap = ((BitmapDrawable) getDrawable()).getBitmap();
		//changeBitmapColor(sourceBitmap, iconColor);

	}

	private void changeBitmapColor() {

		if (iconColor == 0) {
			return;
		}

		Bitmap sourceBitmap = ((BitmapDrawable) getDrawable()).getBitmap();

		Bitmap resultBitmap = Bitmap.createBitmap(sourceBitmap, 0, 0,
			  sourceBitmap.getWidth() - 1, sourceBitmap.getHeight() - 1);

		// resultBitmap = resultBitmap.copy(Bitmap.Config.ARGB_8888, true);

		Paint p = new Paint();
		//ColorFilter filter = new LightingColorFilter(color, 1);
		ColorFilter filter = new LightingColorFilter(iconColor, iconColor);
		p.setColorFilter(filter);
		p.setAntiAlias(true);
		//setImageBitmap(resultBitmap);

		Canvas canvas = new Canvas(resultBitmap);
		canvas.drawBitmap(resultBitmap, 0, 0, p);

		setImageBitmap(resultBitmap);

	}

	private Bitmap changeColorBitmap() {

		Bitmap sourceBitmap = ((BitmapDrawable) getDrawable()).getBitmap();

		int width = sourceBitmap.getWidth();
		int height = sourceBitmap.getHeight();
		int[] pixels = new int[width * height];
		// get pixel array from source
		sourceBitmap.getPixels(pixels, 0, width, 0, 0, width, height);

		Bitmap bmOut = Bitmap.createBitmap(width, height, sourceBitmap.getConfig());

		int A, R, G, B;
		int pixel;

		// iteration through pixels
		for (int y = 0; y < height; ++y) {
			for (int x = 0; x < width; ++x) {
				// get current index in 2D-matrix
				int index = y * width + x;
				pixel = pixels[index];
				if (pixel != 0)

					//change A-RGB individually
				/*A = Color.alpha(pixel);
				R = Color.red(pixel);
				G = Color.green(pixel);
				B = Color.blue(pixel);
				pixels[index] = Color.argb(A, R, G, B); */
			  /*or change the whole color
			  pixels[index] = colorThatWillReplace;*/

					pixels[index] = iconColor;

			}
		}
		bmOut.setPixels(pixels, 0, width, 0, 0, width, height);
		return bmOut;
	}


	private Bitmap getCroppedBitmap(Bitmap bitmap) {
		Bitmap output = Bitmap.createBitmap(bitmap.getWidth(),
			  bitmap.getHeight(), Bitmap.Config.ARGB_8888);

		Canvas canvas = new Canvas(output);

		final int color = 0xff424242;
		final Paint paint = new Paint();
		final Rect rect = new Rect(0, 0, bitmap.getWidth(), bitmap.getHeight());

		paint.setAntiAlias(true);
		canvas.drawARGB(0, 0, 0, 0);
		paint.setColor(color);
		// canvas.drawRoundRect(rectF, roundPx, roundPx, paint);

		int w = bitmap.getWidth();
		int h = bitmap.getHeight();
		int radius = (h > w ? w : h) / 2;

		//int radius = bitmap.getWidth() > bitmap.getHeight() ? bitmap.getHeight() / 2 : bitmap.getWidth() / 2;

		//canvas.drawCircle(bitmap.getWidth() / 2, bitmap.getHeight() / 2, bitmap.getWidth() / 2, paint);
		canvas.drawCircle(w / 2, h / 2, radius - (borderWidth * 3), paint);

		paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC_IN));
		canvas.drawBitmap(bitmap, rect, rect, paint);
		//Bitmap _bmp = Bitmap.createScaledBitmap(output, 60, 60, false);
		//return _bmp;

		/*Log.e("TAG", "full width "+ h);
		Log.e("TAG", "radius "+ radius);
		Log.e("TAG", "borderWidth "+ borderWidth);

		Log.e("TAG", "output "+ output.getHeight());*/

		return output;
	}
}
