/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.common.io.OIOUtils;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.common.util.OCallable;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OServerCommandConfigurableAbstract;
import com.orientechnologies.orient.server.network.protocol.http.command.get.OStaticContentCachedEntry;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.zip.GZIPOutputStream;

public class OServerCommandGetStaticContent
extends OServerCommandConfigurableAbstract {
    private static final String[] DEF_PATTERN = new String[]{"GET|www", "GET|studio/", "GET|", "GET|*.htm", "GET|*.html", "GET|*.xml", "GET|*.jpeg", "GET|*.jpg", "GET|*.png", "GET|*.gif", "GET|*.js", "GET|*.otf", "GET|*.css", "GET|*.swf", "GET|favicon.ico", "GET|robots.txt"};
    private static final String CONFIG_HTTP_CACHE = "http.cache:";
    private static final String CONFIG_ROOT_PATH = "root.path";
    private static final String CONFIG_FILE_PATH = "file.path";
    private ConcurrentHashMap<String, OStaticContentCachedEntry> cacheContents = new ConcurrentHashMap();
    private Map<String, String> cacheHttp = new HashMap<String, String>();
    private String cacheHttpDefault = "Cache-Control: max-age=3000";
    private String rootPath;
    private String filePath;
    private ConcurrentHashMap<String, OCallable<Object, String>> virtualFolders = new ConcurrentHashMap();

    public OServerCommandGetStaticContent() {
        super(DEF_PATTERN);
    }

    public OServerCommandGetStaticContent(OServerCommandConfiguration iConfiguration) {
        super(iConfiguration.pattern);
        for (OServerEntryConfiguration par : iConfiguration.parameters) {
            if (par.name.startsWith(CONFIG_HTTP_CACHE)) {
                String[] filters;
                String filter = par.name.substring(CONFIG_HTTP_CACHE.length());
                if (filter.equalsIgnoreCase("default")) {
                    this.cacheHttpDefault = par.value;
                    continue;
                }
                if (filter.length() <= 0) continue;
                for (String f : filters = filter.split(" ")) {
                    this.cacheHttp.put(f, par.value);
                }
                continue;
            }
            if (par.name.startsWith(CONFIG_ROOT_PATH)) {
                this.rootPath = par.value;
                continue;
            }
            if (!par.name.startsWith(CONFIG_FILE_PATH)) continue;
            this.filePath = par.value;
        }
    }

    @Override
    public boolean beforeExecute(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        String header = this.cacheHttpDefault;
        if (this.cacheHttp.size() > 0) {
            String resource = this.getResource(iRequest);
            for (Map.Entry<String, String> entry : this.cacheHttp.entrySet()) {
                int wildcardPos = entry.getKey().indexOf(42);
                String partLeft = entry.getKey().substring(0, wildcardPos);
                String partRight = entry.getKey().substring(wildcardPos + 1);
                if (!resource.startsWith(partLeft) || !resource.endsWith(partRight)) continue;
                header = entry.getValue();
                break;
            }
        }
        iResponse.setHeader(header);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        block19: {
            iRequest.getData().commandInfo = "Get static content";
            iRequest.getData().commandDetail = iRequest.getUrl();
            OStaticContent staticContent = null;
            try {
                staticContent = this.getVirtualFolderContent(iRequest);
                if (staticContent == null) {
                    staticContent = new OStaticContent();
                    this.loadStaticContent(iRequest, iResponse, staticContent);
                }
                if (staticContent.is != null && staticContent.contentSize < 0L) {
                    ByteArrayOutputStream bytesOutput = new ByteArrayOutputStream();
                    GZIPOutputStream stream = new GZIPOutputStream((OutputStream)bytesOutput, 16384);
                    try {
                        OIOUtils.copyStream((InputStream)staticContent.is, (OutputStream)stream, (long)-1L);
                        stream.finish();
                        byte[] compressedBytes = bytesOutput.toByteArray();
                        iResponse.sendStream(200, "OK", staticContent.type, new ByteArrayInputStream(compressedBytes), compressedBytes.length, null, (Map<String, String>)new HashMap<String, String>(){
                            {
                                this.put("Content-Encoding", "gzip");
                            }
                        });
                        break block19;
                    }
                    finally {
                        stream.close();
                        bytesOutput.close();
                    }
                }
                if (staticContent.is != null) {
                    iResponse.sendStream(200, "OK", staticContent.type, staticContent.is, staticContent.contentSize);
                } else {
                    iResponse.sendStream(404, "File not found", null, null, 0L);
                }
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on loading resource %s", (Throwable)e, new Object[]{iRequest.getUrl()});
            }
            finally {
                if (staticContent != null && staticContent.is != null) {
                    try {
                        staticContent.is.close();
                    }
                    catch (IOException e) {
                        OLogManager.instance().warn((Object)this, "Error on closing file", (Throwable)e, new Object[0]);
                    }
                }
            }
        }
        return false;
    }

    public void registerVirtualFolder(String iName, OCallable<Object, String> iCallback) {
        this.virtualFolders.put(iName, iCallback);
    }

    public void unregisterVirtualFolder(String iName) {
        this.virtualFolders.remove(iName);
    }

    protected String getResource(OHttpRequest iRequest) {
        int pos;
        String url = "/".equals(iRequest.getUrl()) ? "/www/index.htm" : ((pos = iRequest.getUrl().indexOf(63)) > -1 ? iRequest.getUrl().substring(0, pos) : iRequest.getUrl());
        return url;
    }

    protected OStaticContent getVirtualFolderContent(OHttpRequest iRequest) {
        if (iRequest.getUrl() != null) {
            int beginPos = iRequest.getUrl().startsWith("/") ? 1 : 0;
            int endPos = iRequest.getUrl().indexOf("/", beginPos);
            String firstFolderName = endPos > -1 ? iRequest.getUrl().substring(beginPos, endPos) : iRequest.getUrl().substring(beginPos);
            OCallable<Object, String> virtualFolderCallback = this.virtualFolders.get(firstFolderName);
            if (virtualFolderCallback != null) {
                Object content = virtualFolderCallback.call((Object)(endPos > -1 ? iRequest.getUrl().substring(endPos + 1) : ""));
                if (content == null) {
                    return null;
                }
                if (content instanceof OStaticContent) {
                    return (OStaticContent)content;
                }
                if (content instanceof String) {
                    String contentString = (String)content;
                    OStaticContent sc = new OStaticContent();
                    sc.is = new ByteArrayInputStream(contentString.getBytes());
                    sc.contentSize = contentString.length();
                    sc.type = "text/html";
                }
            }
        }
        return null;
    }

    private void loadStaticContent(OHttpRequest iRequest, OHttpResponse iResponse, OStaticContent staticContent) throws UnsupportedEncodingException, IOException, FileNotFoundException {
        OStaticContentCachedEntry cachedEntry;
        String url;
        if (this.filePath == null && this.rootPath == null) {
            this.rootPath = iRequest.getConfiguration().getValueAsString("orientdb.www.path", "src/site");
            if (this.rootPath == null) {
                OLogManager.instance().warn((Object)this, "No path configured. Specify the 'root.path', 'file.path' or the global 'orientdb.www.path' variable", new Object[]{this.rootPath});
                return;
            }
        }
        if (this.filePath == null) {
            File wwwPathDirectory = new File(this.rootPath);
            if (!wwwPathDirectory.exists()) {
                OLogManager.instance().warn((Object)this, "path variable points to '%s' but it doesn't exists", new Object[]{this.rootPath});
            }
            if (!wwwPathDirectory.isDirectory()) {
                OLogManager.instance().warn((Object)this, "path variable points to '%s' but it isn't a directory", new Object[]{this.rootPath});
            }
        }
        String path = this.filePath != null ? this.filePath : ((url = this.getResource(iRequest)).startsWith("/www") ? this.rootPath + url.substring("/www".length(), url.length()) : this.rootPath + url);
        if ((path = URLDecoder.decode(path, "UTF-8")).contains("..")) {
            iResponse.sendStream(404, "File not found", null, null, 0L);
            return;
        }
        if (this.server.getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.SERVER_CACHE_FILE_STATIC) && (cachedEntry = this.cacheContents.get(path)) != null) {
            staticContent.is = new ByteArrayInputStream(cachedEntry.content);
            staticContent.contentSize = cachedEntry.size;
            staticContent.type = cachedEntry.type;
        }
        if (staticContent.is == null) {
            File inputFile = new File(path);
            if (!inputFile.exists()) {
                OLogManager.instance().debug((Object)this, "Static resource not found: %s", new Object[]{path});
                iResponse.sendStream(404, "File not found", null, null, 0L);
                return;
            }
            if (this.filePath == null && inputFile.isDirectory()) {
                inputFile = new File(path + "/index.htm");
                if (inputFile.exists()) {
                    path = path + "/index.htm";
                } else {
                    inputFile = new File(path + "/index.html");
                    if (inputFile.exists()) {
                        path = path + "/index.html";
                    }
                }
            }
            staticContent.type = OServerCommandGetStaticContent.getContentType(path);
            staticContent.is = new BufferedInputStream(new FileInputStream(inputFile));
            staticContent.contentSize = inputFile.length();
            if (this.server.getContextConfiguration().getValueAsBoolean(OGlobalConfiguration.SERVER_CACHE_FILE_STATIC)) {
                byte[] buffer = new byte[(int)staticContent.contentSize];
                int i = 0;
                while ((long)i < staticContent.contentSize) {
                    buffer[i] = (byte)staticContent.is.read();
                    ++i;
                }
                OStaticContentCachedEntry cachedEntry2 = new OStaticContentCachedEntry();
                cachedEntry2.content = buffer;
                cachedEntry2.size = staticContent.contentSize;
                cachedEntry2.type = staticContent.type;
                this.cacheContents.put(path, cachedEntry2);
                staticContent.is = new ByteArrayInputStream(cachedEntry2.content);
            }
        }
    }

    public static String getContentType(String path) {
        if (path.endsWith(".htm") || path.endsWith(".html")) {
            return "text/html";
        }
        if (path.endsWith(".png")) {
            return "image/png";
        }
        if (path.endsWith(".jpeg")) {
            return "image/jpeg";
        }
        if (path.endsWith(".js")) {
            return "application/x-javascript";
        }
        if (path.endsWith(".css")) {
            return "text/css";
        }
        if (path.endsWith(".ico")) {
            return "image/x-icon";
        }
        if (path.endsWith(".otf")) {
            return "font/opentype";
        }
        return "text/plain";
    }

    public static class OStaticContent {
        public InputStream is = null;
        public long contentSize = 0L;
        public String type = null;
    }
}

