/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.all;

import com.orientechnologies.orient.server.config.OServerCommandConfiguration;
import com.orientechnologies.orient.server.config.OServerEntryConfiguration;
import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAbstract;

public class OServerCommandForward
extends OServerCommandAbstract {
    private final String[] pattern;
    private final String prefix;
    private String forwardTo;

    public OServerCommandForward(OServerCommandConfiguration iConfiguration) {
        this.pattern = new String[]{iConfiguration.pattern};
        this.prefix = iConfiguration.pattern.substring(iConfiguration.pattern.indexOf("|") + 1);
        for (OServerEntryConfiguration par : iConfiguration.parameters) {
            if (!par.name.equals("to")) continue;
            this.forwardTo = par.value;
        }
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        StringBuilder forwardURL = new StringBuilder("/");
        forwardURL.append(this.forwardTo);
        if (this.prefix.endsWith("*")) {
            int prefixLength = this.prefix.length() - 1;
            int postfix = iRequest.getUrl().indexOf(this.prefix.substring(0, prefixLength));
            if (postfix > -1) {
                forwardURL.append(iRequest.getUrl().substring(postfix + prefixLength));
            }
        }
        iRequest.setUrl(forwardURL.toString());
        return true;
    }

    @Override
    public String[] getNames() {
        return this.pattern;
    }
}

