/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.token;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.exception.OSystemException;
import com.orientechnologies.common.util.OCommonConst;
import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.config.OGlobalConfiguration;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.id.ORecordId;
import com.orientechnologies.orient.core.metadata.security.OSecurityUser;
import com.orientechnologies.orient.core.metadata.security.OToken;
import com.orientechnologies.orient.core.metadata.security.OTokenException;
import com.orientechnologies.orient.core.metadata.security.binary.OBinaryToken;
import com.orientechnologies.orient.core.metadata.security.binary.OBinaryTokenPayloadImpl;
import com.orientechnologies.orient.core.metadata.security.binary.OBinaryTokenSerializer;
import com.orientechnologies.orient.core.metadata.security.jwt.OBinaryTokenPayload;
import com.orientechnologies.orient.core.metadata.security.jwt.OJwtPayload;
import com.orientechnologies.orient.core.metadata.security.jwt.OTokenHeader;
import com.orientechnologies.orient.core.metadata.security.jwt.OrientJwtHeader;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.security.OParsedToken;
import com.orientechnologies.orient.core.security.OTokenSign;
import com.orientechnologies.orient.core.security.OTokenSignImpl;
import com.orientechnologies.orient.server.OClientConnection;
import com.orientechnologies.orient.server.OTokenHandler;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.token.JsonWebToken;
import com.orientechnologies.orient.server.token.OrientJwtPayload;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.nio.ByteBuffer;
import java.util.Base64;
import java.util.UUID;

public class OTokenHandlerImpl
implements OTokenHandler {
    protected static final int JWT_DELIMITER = 46;
    private OBinaryTokenSerializer binarySerializer;
    private long sessionInMills = 3600000L;
    private final OTokenSign sign;

    public OTokenHandlerImpl(OContextConfiguration config) {
        this((OTokenSign)new OTokenSignImpl(config), config.getValueAsLong(OGlobalConfiguration.NETWORK_TOKEN_EXPIRE_TIMEOUT));
    }

    protected OTokenHandlerImpl(byte[] key, long sessionLength, String algorithm) {
        this((OTokenSign)new OTokenSignImpl(key, algorithm), sessionLength);
    }

    public OTokenHandlerImpl(OTokenSign sign, OContextConfiguration config) {
        this(sign, config.getValueAsLong(OGlobalConfiguration.NETWORK_TOKEN_EXPIRE_TIMEOUT));
    }

    protected OTokenHandlerImpl(OTokenSign sign, long sessionLength) {
        this.sign = sign;
        this.sessionInMills = sessionLength * 1000L * 60L;
        this.binarySerializer = new OBinaryTokenSerializer(new String[]{"plocal", "memory"}, this.sign.getKeys(), new String[]{this.sign.getAlgorithm()}, new String[]{"OrientDB", "node"});
    }

    protected OTokenHandlerImpl() {
        this.sign = null;
    }

    @Override
    public OToken parseWebToken(byte[] tokenBytes) {
        OParsedToken parsedToken = this.parseOnlyWebToken(tokenBytes);
        OToken token = parsedToken.getToken();
        token.setIsVerified(this.sign.verifyTokenSign(parsedToken));
        return token;
    }

    @Override
    public OParsedToken parseOnlyWebToken(byte[] tokenBytes) {
        JsonWebToken token = null;
        int firstDot = -1;
        int secondDot = -1;
        for (int x = 0; x < tokenBytes.length; ++x) {
            if (tokenBytes[x] != 46) continue;
            if (firstDot == -1) {
                firstDot = x;
                continue;
            }
            secondDot = x;
            break;
        }
        if (firstDot == -1) {
            throw new RuntimeException("Token data too short: missed header");
        }
        if (secondDot == -1) {
            throw new RuntimeException("Token data too short: missed signature");
        }
        byte[] decodedHeader = Base64.getUrlDecoder().decode(ByteBuffer.wrap(tokenBytes, 0, firstDot)).array();
        byte[] decodedPayload = Base64.getUrlDecoder().decode(ByteBuffer.wrap(tokenBytes, firstDot + 1, secondDot - (firstDot + 1))).array();
        byte[] decodedSignature = Base64.getUrlDecoder().decode(ByteBuffer.wrap(tokenBytes, secondDot + 1, tokenBytes.length - (secondDot + 1))).array();
        OrientJwtHeader header = this.deserializeWebHeader(decodedHeader);
        OJwtPayload deserializeWebPayload = this.deserializeWebPayload(header.getType(), decodedPayload);
        token = new JsonWebToken((OTokenHeader)header, deserializeWebPayload);
        byte[] onlyTokenBytes = new byte[secondDot];
        System.arraycopy(tokenBytes, 0, onlyTokenBytes, 0, secondDot);
        return new OParsedToken((OToken)token, onlyTokenBytes, decodedSignature);
    }

    @Override
    public boolean validateToken(OParsedToken token, String command, String database) {
        if (!token.getToken().getIsVerified()) {
            boolean value = this.sign.verifyTokenSign(token);
            token.getToken().setIsVerified(value);
        }
        return token.getToken().getIsVerified() && this.validateToken(token.getToken(), command, database);
    }

    @Override
    public boolean validateToken(OToken token, String command, String database) {
        boolean valid = false;
        if (!(token instanceof JsonWebToken)) {
            return false;
        }
        long curTime = System.currentTimeMillis();
        if (token.getDatabase().equalsIgnoreCase(database) && token.getExpiry() > curTime && token.getExpiry() - (this.sessionInMills + 1L) < curTime) {
            valid = true;
        }
        token.setIsValid(valid);
        return valid;
    }

    @Override
    public boolean validateBinaryToken(OParsedToken token) {
        if (!token.getToken().getIsVerified()) {
            boolean value = this.sign.verifyTokenSign(token);
            token.getToken().setIsVerified(value);
        }
        return token.getToken().getIsVerified() && this.validateBinaryToken(token.getToken());
    }

    @Override
    public boolean validateBinaryToken(OToken token) {
        boolean valid = false;
        if ("node".equals(token.getHeader().getType())) {
            valid = true;
        } else {
            long curTime = System.currentTimeMillis();
            if (token.getExpiry() > curTime && token.getExpiry() - (this.sessionInMills + 1L) < curTime) {
                valid = true;
            }
        }
        token.setIsValid(valid);
        return valid;
    }

    @Override
    public byte[] getSignedWebToken(ODatabaseDocument db, OSecurityUser user) {
        ByteArrayOutputStream tokenByteOS = new ByteArrayOutputStream(1024);
        OrientJwtHeader header = new OrientJwtHeader();
        header.setAlgorithm("HS256");
        header.setKeyId("");
        OJwtPayload payload = this.createPayload(db, user);
        header.setType(this.getPayloadType(payload));
        try {
            byte[] bytes = this.serializeWebHeader((OTokenHeader)header);
            tokenByteOS.write(Base64.getUrlEncoder().encode(ByteBuffer.wrap(bytes, 0, bytes.length)).array());
            tokenByteOS.write(46);
            bytes = this.serializeWebPayload(payload);
            tokenByteOS.write(Base64.getUrlEncoder().encode(ByteBuffer.wrap(bytes, 0, bytes.length)).array());
            byte[] unsignedToken = tokenByteOS.toByteArray();
            tokenByteOS.write(46);
            bytes = this.sign.signToken((OTokenHeader)header, unsignedToken);
            tokenByteOS.write(Base64.getUrlEncoder().encode(ByteBuffer.wrap(bytes, 0, bytes.length)).array());
        }
        catch (Exception ex) {
            throw OException.wrapException((OException)new OSystemException("Error on token parsing"), (Throwable)ex);
        }
        return tokenByteOS.toByteArray();
    }

    @Override
    public byte[] getSignedWebTokenServerUser(OSecurityUser user) {
        ByteArrayOutputStream tokenByteOS = new ByteArrayOutputStream(1024);
        OrientJwtHeader header = new OrientJwtHeader();
        header.setAlgorithm("HS256");
        header.setKeyId("");
        OJwtPayload payload = this.createPayloadServerUser(user);
        header.setType(this.getPayloadType(payload));
        try {
            byte[] bytes = this.serializeWebHeader((OTokenHeader)header);
            tokenByteOS.write(Base64.getUrlEncoder().encode(ByteBuffer.wrap(bytes, 0, bytes.length)).array());
            tokenByteOS.write(46);
            bytes = this.serializeWebPayload(payload);
            tokenByteOS.write(Base64.getUrlEncoder().encode(ByteBuffer.wrap(bytes, 0, bytes.length)).array());
            byte[] unsignedToken = tokenByteOS.toByteArray();
            tokenByteOS.write(46);
            bytes = this.sign.signToken((OTokenHeader)header, unsignedToken);
            tokenByteOS.write(Base64.getUrlEncoder().encode(ByteBuffer.wrap(bytes, 0, bytes.length)).array());
        }
        catch (Exception ex) {
            throw OException.wrapException((OException)new OSystemException("Error on token parsing"), (Throwable)ex);
        }
        return tokenByteOS.toByteArray();
    }

    @Override
    public boolean validateServerUserToken(OToken token, String command, String database) {
        boolean valid = false;
        if (!(token instanceof JsonWebToken)) {
            return false;
        }
        OrientJwtPayload payload = (OrientJwtPayload)((JsonWebToken)token).getPayload();
        if (token.isNowValid()) {
            valid = true;
        }
        token.setIsValid(valid);
        return valid;
    }

    @Override
    public byte[] getSignedBinaryToken(ODatabaseDocumentInternal db, OSecurityUser user, ONetworkProtocolData data) {
        try {
            OBinaryToken token = new OBinaryToken();
            long curTime = System.currentTimeMillis();
            OrientJwtHeader header = new OrientJwtHeader();
            header.setAlgorithm(this.sign.getAlgorithm());
            header.setKeyId(this.sign.getDefaultKey());
            header.setType("OrientDB");
            token.setHeader((OTokenHeader)header);
            OBinaryTokenPayloadImpl payload = new OBinaryTokenPayloadImpl();
            if (db != null) {
                payload.setDatabase(db.getName());
                payload.setDatabaseType(db.getStorage().getType());
            }
            if (data.serverUser) {
                payload.setServerUser(true);
                payload.setUserName(data.serverUsername);
            }
            if (user != null) {
                payload.setUserRid(user.getIdentity().getIdentity());
            }
            payload.setExpiry(curTime + this.sessionInMills);
            payload.setProtocolVersion(data.protocolVersion);
            payload.setSerializer(data.getSerializationImpl());
            payload.setDriverName(data.driverName);
            payload.setDriverVersion(data.driverVersion);
            token.setPayload((OBinaryTokenPayload)payload);
            return this.serializeSignedToken(token);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OSystemException("Error on token parsing"), (Throwable)e);
        }
    }

    private byte[] serializeSignedToken(OBinaryToken token) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        this.binarySerializer.serialize(token, (OutputStream)baos);
        byte[] signature = this.sign.signToken(token.getHeader(), baos.toByteArray());
        baos.write(signature);
        return baos.toByteArray();
    }

    @Override
    public ONetworkProtocolData getProtocolDataFromToken(OClientConnection connection, OToken token) {
        if (token instanceof OBinaryToken) {
            OBinaryToken binary = (OBinaryToken)token;
            ONetworkProtocolData data = new ONetworkProtocolData();
            data.protocolVersion = binary.getProtocolVersion();
            data.setSerializationImpl(binary.getSerializer());
            data.driverName = binary.getDriverName();
            data.driverVersion = binary.getDriverVersion();
            data.serverUser = binary.isServerUser();
            data.serverUsername = binary.getUserName();
            data.serverUsername = binary.getUserName();
            data.supportsLegacyPushMessages = connection.getData().supportsLegacyPushMessages;
            data.collectStats = connection.getData().collectStats;
            return data;
        }
        return null;
    }

    @Override
    public OToken parseNotVerifyBinaryToken(byte[] binaryToken) {
        ByteArrayInputStream bais = new ByteArrayInputStream(binaryToken);
        return this.deserializeBinaryToken(bais);
    }

    @Override
    public OParsedToken parseOnlyBinary(byte[] binaryToken) {
        try {
            ByteArrayInputStream bais = new ByteArrayInputStream(binaryToken);
            OBinaryToken token = this.deserializeBinaryToken(bais);
            int end = binaryToken.length - bais.available();
            byte[] decodedSignature = new byte[bais.available()];
            bais.read(decodedSignature);
            byte[] onlyTokenBytes = new byte[end];
            System.arraycopy(binaryToken, 0, onlyTokenBytes, 0, end);
            return new OParsedToken((OToken)token, onlyTokenBytes, decodedSignature);
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OSystemException("Error on token parsing"), (Throwable)e);
        }
    }

    @Override
    public OToken parseBinaryToken(byte[] binaryToken) {
        OParsedToken parsedToken = this.parseOnlyBinary(binaryToken);
        OToken token = parsedToken.getToken();
        token.setIsVerified(this.sign.verifyTokenSign(parsedToken));
        return token;
    }

    @Override
    public byte[] renewIfNeeded(OToken token) {
        if (token == null) {
            throw new IllegalArgumentException("Token is null");
        }
        long curTime = System.currentTimeMillis();
        if (token.getExpiry() - curTime < this.sessionInMills / 2L && token.getExpiry() >= curTime) {
            long expiryMinutes = this.sessionInMills;
            long currTime = System.currentTimeMillis();
            token.setExpiry(currTime + expiryMinutes);
            try {
                if (token instanceof OBinaryToken) {
                    return this.serializeSignedToken((OBinaryToken)token);
                }
                throw new OTokenException("renew of web token not supported");
            }
            catch (IOException e) {
                throw OException.wrapException((OException)new OSystemException("Error on token parsing"), (Throwable)e);
            }
        }
        return OCommonConst.EMPTY_BYTE_ARRAY;
    }

    public long getSessionInMills() {
        return this.sessionInMills;
    }

    @Override
    public boolean isEnabled() {
        return true;
    }

    protected OrientJwtHeader deserializeWebHeader(byte[] decodedHeader) {
        ODocument doc = new ODocument();
        try {
            doc.fromJSON(new String(decodedHeader, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException((OException)new OSystemException("Header is not encoded in UTF-8 format"), (Throwable)e);
        }
        OrientJwtHeader header = new OrientJwtHeader();
        header.setType((String)doc.field("typ"));
        header.setAlgorithm((String)doc.field("alg"));
        header.setKeyId((String)doc.field("kid"));
        return header;
    }

    protected OJwtPayload deserializeWebPayload(String type, byte[] decodedPayload) {
        if (!"OrientDB".equals(type)) {
            throw new OSystemException("Payload class not registered:" + type);
        }
        ODocument doc = new ODocument();
        try {
            doc.fromJSON(new String(decodedPayload, "UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw OException.wrapException((OException)new OSystemException("Payload encoding format differs from UTF-8"), (Throwable)e);
        }
        OrientJwtPayload payload = new OrientJwtPayload();
        payload.setUserName((String)doc.field("username"));
        payload.setIssuer((String)doc.field("iss"));
        payload.setExpiry((Long)doc.field("exp"));
        payload.setIssuedAt((Long)doc.field("iat"));
        payload.setNotBefore((Long)doc.field("nbf"));
        payload.setDatabase((String)doc.field("sub"));
        payload.setAudience((String)doc.field("aud"));
        payload.setTokenId((String)doc.field("jti"));
        int cluster = (Integer)doc.field("uidc");
        long pos = (Long)doc.field("uidp");
        payload.setUserRid((ORID)new ORecordId(cluster, pos));
        payload.setDatabaseType((String)doc.field("bdtyp"));
        return payload;
    }

    protected byte[] serializeWebHeader(OTokenHeader header) throws Exception {
        if (header == null) {
            throw new IllegalArgumentException("Token header is null");
        }
        ODocument doc = new ODocument();
        doc.field("typ", (Object)header.getType());
        doc.field("alg", (Object)header.getAlgorithm());
        doc.field("kid", (Object)header.getKeyId());
        return doc.toJSON().getBytes("UTF-8");
    }

    protected byte[] serializeWebPayload(OJwtPayload payload) throws Exception {
        if (payload == null) {
            throw new IllegalArgumentException("Token payload is null");
        }
        ODocument doc = new ODocument();
        doc.field("username", (Object)payload.getUserName());
        doc.field("iss", (Object)payload.getIssuer());
        doc.field("exp", (Object)payload.getExpiry());
        doc.field("iat", (Object)payload.getIssuedAt());
        doc.field("nbf", (Object)payload.getNotBefore());
        doc.field("sub", (Object)payload.getDatabase());
        doc.field("aud", (Object)payload.getAudience());
        doc.field("jti", (Object)payload.getTokenId());
        doc.field("uidc", (Object)((OrientJwtPayload)payload).getUserRid().getClusterId());
        doc.field("uidp", (Object)((OrientJwtPayload)payload).getUserRid().getClusterPosition());
        doc.field("bdtyp", (Object)((OrientJwtPayload)payload).getDatabaseType());
        return doc.toJSON().getBytes("UTF-8");
    }

    protected OJwtPayload createPayloadServerUser(OSecurityUser serverUser) {
        if (serverUser == null) {
            throw new IllegalArgumentException("User is null");
        }
        OrientJwtPayload payload = new OrientJwtPayload();
        payload.setAudience("OrientDBServer");
        payload.setDatabase("-");
        payload.setUserRid((ORID)ORecordId.EMPTY_RECORD_ID);
        long expiryMinutes = this.sessionInMills;
        long currTime = System.currentTimeMillis();
        payload.setIssuedAt(currTime);
        payload.setNotBefore(currTime);
        payload.setUserName(serverUser.getName());
        payload.setTokenId(UUID.randomUUID().toString());
        payload.setExpiry(currTime + expiryMinutes);
        return payload;
    }

    protected OJwtPayload createPayload(ODatabaseDocument db, OSecurityUser user) {
        if (user == null) {
            throw new IllegalArgumentException("User is null");
        }
        OrientJwtPayload payload = new OrientJwtPayload();
        payload.setAudience("OrientDB");
        payload.setDatabase(db.getName());
        payload.setUserRid(user.getIdentity().getIdentity());
        long expiryMinutes = this.sessionInMills;
        long currTime = System.currentTimeMillis();
        payload.setIssuedAt(currTime);
        payload.setNotBefore(currTime);
        payload.setUserName(user.getName());
        payload.setTokenId(UUID.randomUUID().toString());
        payload.setExpiry(currTime + expiryMinutes);
        return payload;
    }

    protected String getPayloadType(OJwtPayload payload) {
        return "OrientDB";
    }

    private OBinaryToken deserializeBinaryToken(InputStream bais) {
        try {
            return this.binarySerializer.deserialize(bais);
        }
        catch (Exception e) {
            throw OException.wrapException((OException)new OSystemException("Cannot deserialize binary token"), (Throwable)e);
        }
    }

    public void setSessionInMills(long sessionInMills) {
        this.sessionInMills = sessionInMills;
    }
}

