/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http.command.get;

import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import com.orientechnologies.orient.server.network.protocol.http.OHttpResponse;
import com.orientechnologies.orient.server.network.protocol.http.command.OServerCommandAbstract;
import java.io.IOException;

public class OServerCommandGetDisconnect
extends OServerCommandAbstract {
    private static final String[] NAMES = new String[]{"GET|disconnect"};

    @Override
    public boolean beforeExecute(OHttpRequest iRequest, OHttpResponse iResponse) throws IOException {
        super.beforeExecute(iRequest, iResponse);
        return true;
    }

    @Override
    public boolean execute(OHttpRequest iRequest, OHttpResponse iResponse) throws Exception {
        this.checkSyntax(iRequest.getUrl(), 1, "Syntax error: disconnect");
        iRequest.getData().commandInfo = "Disconnect";
        iRequest.getData().commandDetail = null;
        if (iRequest.getSessionId() != null) {
            this.server.getHttpSessionManager().removeSession(iRequest.getSessionId());
            iRequest.setSessionId("-");
            iResponse.setSessionId(iRequest.getSessionId());
        }
        iResponse.setKeepAlive(false);
        if (this.isJsonResponse(iResponse)) {
            this.sendJsonError(iResponse, 401, "Unauthorized", "text/plain", "Logged out", null);
        } else {
            iResponse.send(401, "Unauthorized", "text/plain", "Logged out", null);
        }
        return false;
    }

    @Override
    public String[] getNames() {
        return NAMES;
    }
}

