/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.orient.server.network.protocol.http.OHttpRequest;
import java.util.Map;

public class OHttpRequestWrapper {
    private final OHttpRequest request;
    private final String[] args;

    public OHttpRequestWrapper(OHttpRequest iRequest) {
        this.request = iRequest;
        this.args = null;
    }

    public OHttpRequestWrapper(OHttpRequest iRequest, String[] iArgs) {
        this.request = iRequest;
        this.args = iArgs;
    }

    public String getContent() {
        return this.request.getContent();
    }

    public String getUser() {
        return this.request.getUser();
    }

    public String getContentType() {
        return this.request.getContentType();
    }

    public String getHttpVersion() {
        return this.request.getHttpVersion();
    }

    public String getHttpMethod() {
        return this.request.getHttpMethod();
    }

    public Map<String, String> getHeaders() {
        return this.request.getHeaders();
    }

    public String getIfMatch() {
        return this.request.getIfMatch();
    }

    public boolean isMultipart() {
        return this.request.isMultipart();
    }

    public String[] getArguments() {
        return this.args;
    }

    public String getArgument(int iPosition) {
        return this.args != null && this.args.length > iPosition ? this.args[iPosition] : null;
    }

    public Map<String, String> getParameters() {
        return this.request.getParameters();
    }

    public String getParameter(String iName) {
        return this.request.getParameters() != null ? this.request.getParameters().get(iName) : null;
    }

    public int hasParameters(String ... iNames) {
        int found = 0;
        if (iNames != null && this.request.getParameters() != null) {
            for (String name : iNames) {
                found += this.request.getParameters().containsKey(name) ? 1 : 0;
            }
        }
        return found;
    }

    public String getSessionId() {
        return this.request.getSessionId();
    }

    public String getURL() {
        return this.request.getUrl();
    }

    public String getRemoteAddress() {
        return this.request.getRemoteAddress();
    }
}

