/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server.network.protocol.http;

import com.orientechnologies.orient.core.config.OContextConfiguration;
import com.orientechnologies.orient.core.security.OParsedToken;
import com.orientechnologies.orient.server.network.protocol.ONetworkProtocolData;
import com.orientechnologies.orient.server.network.protocol.http.ONetworkHttpExecutor;
import com.orientechnologies.orient.server.network.protocol.http.multipart.OHttpMultipartBaseInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;

public abstract class OHttpRequest {
    private final OContextConfiguration configuration;
    private final InputStream in;
    private final ONetworkProtocolData data;
    private final ONetworkHttpExecutor executor;
    protected String content;
    protected Map<String, String> parameters;
    private String sessionId;
    protected String authorization;
    private String databaseName;

    public OHttpRequest(ONetworkHttpExecutor iExecutor, InputStream iInStream, ONetworkProtocolData iData, OContextConfiguration iConfiguration) {
        this.executor = iExecutor;
        this.in = iInStream;
        this.data = iData;
        this.configuration = iConfiguration;
    }

    public String getUser() {
        return this.getAuthorization() != null ? this.getAuthorization().substring(0, this.getAuthorization().indexOf(":")) : null;
    }

    public InputStream getInputStream() {
        return this.getIn();
    }

    public String getParameter(String iName) {
        return this.getParameters() != null ? this.getParameters().get(iName) : null;
    }

    public void addHeader(String h) {
        int pos;
        if (this.getHeaders() == null) {
            this.setHeaders(new HashMap<String, String>());
        }
        if ((pos = h.indexOf(58)) > -1) {
            this.getHeaders().put(h.substring(0, pos).trim().toLowerCase(Locale.ENGLISH), h.substring(pos + 1).trim());
        }
    }

    public Map<String, String> getUrlEncodedContent() {
        if (this.getContent() == null || this.getContent().length() < 1) {
            return null;
        }
        HashMap<String, String> retMap = new HashMap<String, String>();
        try {
            String[] pairs = this.getContent().split("\\&");
            for (int i = 0; i < pairs.length; ++i) {
                String[] fields = pairs[i].split("=");
                if (fields.length != 2) continue;
                String key = URLDecoder.decode(fields[0], "UTF-8");
                String value = URLDecoder.decode(fields[1], "UTF-8");
                retMap.put(key, value);
            }
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            // empty catch block
        }
        return retMap;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public String getHeader(String iName) {
        return this.getHeaders().get(iName.toLowerCase(Locale.ENGLISH));
    }

    public abstract Map<String, String> getHeaders();

    public String getRemoteAddress() {
        if (this.getData().caller != null) {
            return this.getData().caller;
        }
        return this.getExecutor().getRemoteAddress();
    }

    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public abstract String getUrl();

    public OContextConfiguration getConfiguration() {
        return this.configuration;
    }

    public InputStream getIn() {
        return this.in;
    }

    public ONetworkProtocolData getData() {
        return this.data;
    }

    public ONetworkHttpExecutor getExecutor() {
        return this.executor;
    }

    public String getAuthorization() {
        return this.authorization;
    }

    public void setAuthorization(String authorization) {
        this.authorization = authorization;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public abstract void setUrl(String var1);

    public abstract String getHttpMethod();

    public abstract void setHttpMethod(String var1);

    public abstract String getHttpVersion();

    public abstract void setHttpVersion(String var1);

    public abstract String getContentType();

    public abstract void setContentType(String var1);

    public abstract String getContentEncoding();

    public abstract void setContentEncoding(String var1);

    public abstract String getAcceptEncoding();

    public abstract void setAcceptEncoding(String var1);

    public abstract OHttpMultipartBaseInputStream getMultipartStream();

    public abstract void setMultipartStream(OHttpMultipartBaseInputStream var1);

    public abstract String getBoundary();

    public abstract void setBoundary(String var1);

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public abstract boolean isMultipart();

    public abstract void setMultipart(boolean var1);

    public abstract String getIfMatch();

    public abstract void setIfMatch(String var1);

    public abstract String getAuthentication();

    public abstract void setAuthentication(String var1);

    public abstract boolean isKeepAlive();

    public abstract void setKeepAlive(boolean var1);

    public abstract void setHeaders(Map<String, String> var1);

    public abstract String getBearerTokenRaw();

    public abstract void setBearerTokenRaw(String var1);

    public abstract OParsedToken getBearerToken();

    public abstract void setBearerToken(OParsedToken var1);
}

