/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.orient.server;

import com.orientechnologies.common.exception.OErrorCode;
import com.orientechnologies.common.exception.OException;
import com.orientechnologies.orient.client.remote.message.OBinaryPushRequest;
import com.orientechnologies.orient.client.remote.message.OLiveQueryPushRequest;
import com.orientechnologies.orient.client.remote.message.live.OLiveQueryResult;
import com.orientechnologies.orient.core.db.OLiveQueryResultListener;
import com.orientechnologies.orient.core.db.document.ODatabaseDocument;
import com.orientechnologies.orient.core.exception.OCoreException;
import com.orientechnologies.orient.core.exception.OLiveQueryInterruptedException;
import com.orientechnologies.orient.core.sql.executor.OResult;
import com.orientechnologies.orient.server.network.protocol.binary.ONetworkProtocolBinary;
import java.io.IOException;
import java.util.Collections;

class OServerLiveQueryResultListener
implements OLiveQueryResultListener {
    private final ONetworkProtocolBinary protocol;
    private int monitorId;

    public OServerLiveQueryResultListener(ONetworkProtocolBinary protocol) {
        this.protocol = protocol;
    }

    public void setMonitorId(int monitorId) {
        this.monitorId = monitorId;
    }

    private void sendEvent(OLiveQueryResult event) {
        try {
            this.protocol.push((OBinaryPushRequest)new OLiveQueryPushRequest(this.monitorId, 1, Collections.singletonList(event)));
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OLiveQueryInterruptedException("Live query interrupted by socket close"), (Throwable)e);
        }
    }

    public void onCreate(ODatabaseDocument database, OResult data) {
        this.sendEvent(new OLiveQueryResult(1, data, null));
    }

    public void onUpdate(ODatabaseDocument database, OResult before, OResult after) {
        this.sendEvent(new OLiveQueryResult(2, after, before));
    }

    public void onDelete(ODatabaseDocument database, OResult data) {
        this.sendEvent(new OLiveQueryResult(3, data, null));
    }

    public void onError(ODatabaseDocument database, OException exception) {
        try {
            int errorIdentifier = 0;
            OErrorCode code = OErrorCode.GENERIC_ERROR;
            if (exception instanceof OCoreException) {
                code = ((OCoreException)exception).getErrorCode();
            }
            this.protocol.push((OBinaryPushRequest)new OLiveQueryPushRequest(this.monitorId, errorIdentifier, code, exception.getMessage()));
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OLiveQueryInterruptedException("Live query interrupted by socket close"), (Throwable)e);
        }
    }

    public void onEnd(ODatabaseDocument database) {
        try {
            this.protocol.push((OBinaryPushRequest)new OLiveQueryPushRequest(this.monitorId, 2, Collections.emptyList()));
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OLiveQueryInterruptedException("Live query interrupted by socket close"), (Throwable)e);
        }
    }
}

