/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.operator;

import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.serialization.serializer.record.binary.ODocumentSerializer;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.spatial.collections.OSpatialCompositeKey;
import com.orientechnologies.spatial.operator.OLuceneSpatialOperator;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Stream;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.locationtech.spatial4j.shape.Shape;

public class OLuceneOverlapOperator
extends OLuceneSpatialOperator {
    public OLuceneOverlapOperator() {
        super("&&", 5, false);
    }

    public Stream<ORawPair<Object, ORID>> executeIndexQuery(OCommandContext iContext, OIndex index, List<Object> keyParams, boolean ascSortOrder) {
        Object key = keyParams.get(0);
        HashMap<String, Object> queryParams = new HashMap<String, Object>();
        queryParams.put("geo_filter", "&&");
        queryParams.put("shape", key);
        return index.getInternal().getRids(queryParams).map(rid -> new ORawPair((Object)new OSpatialCompositeKey(keyParams), rid));
    }

    @Override
    public Object evaluateRecord(OIdentifiable iRecord, ODocument iCurrentResult, OSQLFilterCondition iCondition, Object iLeft, Object iRight, OCommandContext iContext, ODocumentSerializer serializer) {
        Object shape = this.factory.fromDoc((ODocument)iLeft);
        Object filter = iRight instanceof Collection ? ((Collection)iRight).iterator().next() : iRight;
        Object shape1 = this.factory.fromObject(filter);
        return SpatialOperation.BBoxIntersects.evaluate(shape, (Shape)shape1.getBoundingBox());
    }
}

