/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.collections;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.log.OLogManager;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.engine.OLuceneIndexEngineUtils;
import com.orientechnologies.lucene.exception.OLuceneIndexException;
import com.orientechnologies.lucene.query.OLuceneQueryContext;
import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.id.OContextualRecordId;
import com.orientechnologies.orient.core.record.impl.ODocument;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.highlight.Formatter;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.search.highlight.QueryTermScorer;
import org.apache.lucene.search.highlight.Scorer;
import org.apache.lucene.search.highlight.SimpleHTMLFormatter;
import org.apache.lucene.search.highlight.TextFragment;
import org.apache.lucene.search.highlight.TokenSources;

public class OLuceneResultSet
implements Set<OIdentifiable> {
    private static Integer PAGE_SIZE = 10000;
    private Query query;
    private OLuceneIndexEngine engine;
    private OLuceneQueryContext queryContext;
    private String indexName;
    private Highlighter highlighter;
    private List<String> highlighted;
    private int maxNumFragments;
    private TopDocs topDocs;
    private long deletedMatchCount = 0L;
    private boolean closed = false;

    protected OLuceneResultSet() {
    }

    public OLuceneResultSet(OLuceneIndexEngine engine, OLuceneQueryContext queryContext, ODocument metadata) {
        this.engine = engine;
        this.queryContext = queryContext;
        this.query = queryContext.getQuery();
        this.indexName = engine.indexName();
        this.fetchFirstBatch();
        this.deletedMatchCount = this.calculateDeletedMatch();
        Map highlight = Optional.ofNullable(metadata.getProperty("highlight")).orElse(Collections.emptyMap());
        this.highlighted = Optional.ofNullable((List)highlight.get("fields")).orElse(Collections.emptyList());
        String startElement = Optional.ofNullable(highlight.get("start")).orElse("<B>");
        String endElement = Optional.ofNullable(highlight.get("end")).orElse("</B>");
        QueryTermScorer scorer = new QueryTermScorer(queryContext.getQuery());
        SimpleHTMLFormatter formatter = new SimpleHTMLFormatter(startElement, endElement);
        this.highlighter = new Highlighter((Formatter)formatter, (Scorer)scorer);
        this.maxNumFragments = Optional.ofNullable(highlight.get("maxNumFragments")).orElse(2);
    }

    protected void fetchFirstBatch() {
        try {
            IndexSearcher searcher = this.queryContext.getSearcher();
            this.topDocs = this.queryContext.getSort() == null ? searcher.search(this.query, PAGE_SIZE.intValue()) : searcher.search(this.query, PAGE_SIZE.intValue(), this.queryContext.getSort());
        }
        catch (IOException e) {
            OLogManager.instance().error((Object)this, "Error on fetching document by query '%s' to Lucene index", (Throwable)e, new Object[]{this.query});
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Object[] toArray() {
        throw new UnsupportedOperationException();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean add(OIdentifiable oIdentifiable) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends OIdentifiable> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    public void sendLookupTime(OCommandContext commandContext, long start) {
        OLuceneIndexEngineUtils.sendLookupTime(this.indexName, commandContext, this.topDocs, -1, start);
    }

    protected long calculateDeletedMatch() {
        return this.queryContext.deletedDocs(this.query);
    }

    @Override
    public int size() {
        return (int)Math.max(0L, this.topDocs.totalHits - this.deletedMatchCount);
    }

    @Override
    public Iterator<OIdentifiable> iterator() {
        return new OLuceneResultSetIteratorTx();
    }

    private class OLuceneResultSetIteratorTx
    implements Iterator<OIdentifiable> {
        private ScoreDoc[] scoreDocs;
        private int index;
        private int localIndex;
        private long totalHits;

        public OLuceneResultSetIteratorTx() {
            this.totalHits = ((OLuceneResultSet)OLuceneResultSet.this).topDocs.totalHits;
            this.index = 0;
            this.localIndex = 0;
            this.scoreDocs = ((OLuceneResultSet)OLuceneResultSet.this).topDocs.scoreDocs;
            OLuceneIndexEngineUtils.sendTotalHits(OLuceneResultSet.this.indexName, OLuceneResultSet.this.queryContext.getContext(), ((OLuceneResultSet)OLuceneResultSet.this).topDocs.totalHits - OLuceneResultSet.this.deletedMatchCount);
        }

        @Override
        public boolean hasNext() {
            IndexSearcher searcher;
            boolean hasNext;
            boolean bl = hasNext = (long)this.index < this.totalHits - OLuceneResultSet.this.deletedMatchCount;
            if (!hasNext && !OLuceneResultSet.this.closed && (searcher = OLuceneResultSet.this.queryContext.getSearcher()).getIndexReader().getRefCount() > 1) {
                OLuceneResultSet.this.engine.release(searcher);
                OLuceneResultSet.this.closed = true;
            }
            return hasNext;
        }

        @Override
        public OIdentifiable next() {
            ScoreDoc scoreDoc;
            Document doc;
            OContextualRecordId res;
            while (this.isToSkip(res = this.toRecordId(doc = this.toDocument(scoreDoc = this.fetchNext()), scoreDoc), doc)) {
            }
            ++this.index;
            return res;
        }

        protected ScoreDoc fetchNext() {
            if (this.localIndex == this.scoreDocs.length) {
                this.localIndex = 0;
                this.fetchMoreResult();
            }
            ScoreDoc score = this.scoreDocs[this.localIndex++];
            return score;
        }

        private Document toDocument(ScoreDoc score) {
            try {
                return OLuceneResultSet.this.queryContext.getSearcher().doc(score.doc);
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error during conversion to document", (Throwable)e, new Object[0]);
                return null;
            }
        }

        private OContextualRecordId toRecordId(Document doc, ScoreDoc score) {
            String rId = doc.get("RID");
            OContextualRecordId res = new OContextualRecordId(rId);
            IndexReader indexReader = OLuceneResultSet.this.queryContext.getSearcher().getIndexReader();
            try {
                for (String field : OLuceneResultSet.this.highlighted) {
                    String text = doc.get(field);
                    if (text == null) continue;
                    TokenStream tokenStream = TokenSources.getAnyTokenStream((IndexReader)indexReader, (int)score.doc, (String)field, (Document)doc, (Analyzer)OLuceneResultSet.this.engine.indexAnalyzer());
                    TextFragment[] frag = OLuceneResultSet.this.highlighter.getBestTextFragments(tokenStream, text, true, OLuceneResultSet.this.maxNumFragments);
                    OLuceneResultSet.this.queryContext.addHighlightFragment(field, frag);
                }
                OLuceneResultSet.this.engine.onRecordAddedToResultSet(OLuceneResultSet.this.queryContext, res, doc, score);
                return res;
            }
            catch (IOException | InvalidTokenOffsetsException e) {
                throw OException.wrapException((OException)new OLuceneIndexException("error while highlighting"), (Throwable)e);
            }
        }

        private boolean isToSkip(OContextualRecordId recordId, Document doc) {
            return this.isDeleted((OIdentifiable)recordId, doc) || this.isUpdatedDiskMatch((OIdentifiable)recordId, doc);
        }

        private void fetchMoreResult() {
            TopDocs topDocs = null;
            try {
                IndexSearcher searcher = OLuceneResultSet.this.queryContext.getSearcher();
                topDocs = OLuceneResultSet.this.queryContext.getSort() == null ? searcher.searchAfter(this.scoreDocs[this.scoreDocs.length - 1], OLuceneResultSet.this.query, PAGE_SIZE.intValue()) : searcher.searchAfter(this.scoreDocs[this.scoreDocs.length - 1], OLuceneResultSet.this.query, PAGE_SIZE.intValue(), OLuceneResultSet.this.queryContext.getSort());
                this.scoreDocs = topDocs.scoreDocs;
            }
            catch (IOException e) {
                OLogManager.instance().error((Object)this, "Error on fetching document by query '%s' to Lucene index", (Throwable)e, new Object[]{OLuceneResultSet.this.query});
            }
        }

        private boolean isDeleted(OIdentifiable value, Document doc) {
            return OLuceneResultSet.this.queryContext.isDeleted(doc, null, value);
        }

        private boolean isUpdatedDiskMatch(OIdentifiable value, Document doc) {
            return this.isUpdated(value) && !this.isTempMatch(doc);
        }

        private boolean isUpdated(OIdentifiable value) {
            return OLuceneResultSet.this.queryContext.isUpdated(null, null, value);
        }

        private boolean isTempMatch(Document doc) {
            return doc.get("_tmp_rid") != null;
        }

        @Override
        public void remove() {
        }
    }
}

