/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.builder;

import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndexDefinition;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.lucene.document.DoubleDocValuesField;
import org.apache.lucene.document.DoublePoint;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FloatDocValuesField;
import org.apache.lucene.document.FloatPoint;
import org.apache.lucene.document.IntPoint;
import org.apache.lucene.document.LongPoint;
import org.apache.lucene.document.NumericDocValuesField;
import org.apache.lucene.document.SortedDocValuesField;
import org.apache.lucene.document.StringField;
import org.apache.lucene.document.TextField;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.util.BytesRef;

public class OLuceneIndexType {
    public static Field createField(String fieldName, Object value, Field.Store store) {
        if (fieldName.equalsIgnoreCase("RID")) {
            StringField ridField = new StringField(fieldName, value.toString(), store);
            return ridField;
        }
        if (fieldName.startsWith("_CLASS") || fieldName.startsWith("_CLUSTER")) {
            StringField ridField = new StringField(fieldName, value.toString(), store);
            return ridField;
        }
        return new TextField(fieldName, value.toString(), Field.Store.YES);
    }

    public static List<Field> createFields(String fieldName, Object value, Field.Store store, Boolean sort) {
        ArrayList<Field> fields = new ArrayList<Field>();
        if (value instanceof Number) {
            Number number = (Number)value;
            if (value instanceof Long) {
                fields.add((Field)new NumericDocValuesField(fieldName, number.longValue()));
                fields.add((Field)new LongPoint(fieldName, new long[]{number.longValue()}));
                return fields;
            }
            if (value instanceof Float) {
                fields.add((Field)new FloatDocValuesField(fieldName, number.floatValue()));
                fields.add((Field)new FloatPoint(fieldName, new float[]{number.floatValue()}));
                return fields;
            }
            if (value instanceof Double) {
                fields.add((Field)new DoubleDocValuesField(fieldName, number.doubleValue()));
                fields.add((Field)new DoublePoint(fieldName, new double[]{number.doubleValue()}));
                return fields;
            }
            fields.add((Field)new NumericDocValuesField(fieldName, number.longValue()));
            fields.add((Field)new IntPoint(fieldName, new int[]{number.intValue()}));
            return fields;
        }
        if (value instanceof Date) {
            Date date = (Date)value;
            fields.add((Field)new NumericDocValuesField(fieldName, date.getTime()));
            fields.add((Field)new LongPoint(fieldName, new long[]{date.getTime()}));
            return fields;
        }
        if (Boolean.TRUE.equals(sort)) {
            fields.add((Field)new SortedDocValuesField(fieldName, new BytesRef((CharSequence)value.toString())));
        }
        fields.add((Field)new TextField(fieldName, value.toString(), Field.Store.YES));
        return fields;
    }

    public static Query createExactQuery(OIndexDefinition index, Object key) {
        BooleanQuery query = null;
        if (key instanceof String) {
            BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
            if (index.getFields().size() > 0) {
                for (String idx : index.getFields()) {
                    queryBuilder.add((Query)new TermQuery(new Term(idx, key.toString())), BooleanClause.Occur.SHOULD);
                }
            } else {
                queryBuilder.add((Query)new TermQuery(new Term("KEY", key.toString())), BooleanClause.Occur.SHOULD);
            }
            query = queryBuilder.build();
        } else if (key instanceof OCompositeKey) {
            BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
            int i = 0;
            OCompositeKey keys = (OCompositeKey)key;
            for (String idx : index.getFields()) {
                String val = (String)keys.getKeys().get(i);
                queryBuilder.add((Query)new TermQuery(new Term(idx, val)), BooleanClause.Occur.MUST);
                ++i;
            }
            query = queryBuilder.build();
        }
        return query;
    }

    public static Query createQueryId(OIdentifiable value) {
        return new TermQuery(new Term("RID", value.getIdentity().toString()));
    }

    public static Query createDeleteQuery(OIdentifiable value, List<String> fields, Object key) {
        BooleanQuery.Builder queryBuilder = new BooleanQuery.Builder();
        queryBuilder.add(OLuceneIndexType.createQueryId(value), BooleanClause.Occur.MUST);
        HashMap<String, String> values = new HashMap<String, String>();
        if (!(key instanceof OCompositeKey)) {
            values.put(fields.iterator().next(), key.toString());
        }
        for (String s : values.keySet()) {
            queryBuilder.add((Query)new TermQuery(new Term(s, ((String)values.get(s)).toLowerCase(Locale.ENGLISH))), BooleanClause.Occur.MUST);
        }
        return queryBuilder.build();
    }
}

