/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OPolygonShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeType;
import java.util.ArrayList;
import java.util.List;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.spatial4j.shape.jts.JtsGeometry;

public class OMultiPolygonShapeBuilder
extends OPolygonShapeBuilder {
    @Override
    public String getName() {
        return "OMultiPolygon";
    }

    @Override
    public OShapeType getType() {
        return OShapeType.MULTIPOLYGON;
    }

    @Override
    public void initClazz(ODatabaseInternal db) {
        OSchema schema = db.getMetadata().getSchema();
        OClass polygon = schema.createAbstractClass(this.getName(), this.superClass(db));
        polygon.createProperty("coordinates", OType.EMBEDDEDLIST, OType.EMBEDDEDLIST);
    }

    @Override
    public JtsGeometry fromDoc(ODocument document) {
        this.validate(document);
        List coordinates = (List)document.field("coordinates");
        Polygon[] polygons = new Polygon[coordinates.size()];
        int i = 0;
        for (List coordinate : coordinates) {
            polygons[i] = this.createPolygon(coordinate);
            ++i;
        }
        return this.toShape((Geometry)GEOMETRY_FACTORY.createMultiPolygon(polygons));
    }

    @Override
    public ODocument toDoc(JtsGeometry shape) {
        ODocument doc = new ODocument(this.getName());
        MultiPolygon multiPolygon = (MultiPolygon)shape.getGeom();
        ArrayList<List<List<List<Double>>>> polyCoordinates = new ArrayList<List<List<List<Double>>>>();
        int n = multiPolygon.getNumGeometries();
        for (int i = 0; i < n; ++i) {
            Geometry geom = multiPolygon.getGeometryN(i);
            polyCoordinates.add(this.coordinatesFromPolygon((Polygon)geom));
        }
        doc.field("coordinates", polyCoordinates);
        return doc;
    }
}

