/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.spatial.shape;

import com.orientechnologies.orient.core.db.ODatabaseInternal;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.metadata.schema.OSchema;
import com.orientechnologies.orient.core.metadata.schema.OType;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.spatial.shape.OComplexShapeBuilder;
import com.orientechnologies.spatial.shape.OShapeFactory;
import com.orientechnologies.spatial.shape.OShapeType;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.spatial4j.context.SpatialContext;
import org.locationtech.spatial4j.shape.Shape;
import org.locationtech.spatial4j.shape.ShapeCollection;

public class OGeometryCollectionShapeBuilder
extends OComplexShapeBuilder<ShapeCollection<Shape>> {
    protected OShapeFactory shapeFactory;

    public OGeometryCollectionShapeBuilder(OShapeFactory shapeFactory) {
        this.shapeFactory = shapeFactory;
    }

    @Override
    public String getName() {
        return "OGeometryCollection";
    }

    @Override
    public OShapeType getType() {
        return OShapeType.GEOMETRYCOLLECTION;
    }

    @Override
    public ShapeCollection<Shape> fromMapGeoJson(Map<String, Object> geoJsonMap) {
        ODocument doc = new ODocument(this.getName());
        doc.field("geometries", geoJsonMap.get("geometries"));
        return this.fromDoc(doc);
    }

    @Override
    public ShapeCollection<Shape> fromDoc(ODocument doc) {
        List geometries = (List)doc.field("geometries");
        ArrayList<Shape> shapes = new ArrayList<Shape>();
        Geometry[] geoms = new Geometry[geometries.size()];
        for (ODocument geometry : geometries) {
            Shape shape = this.shapeFactory.fromDoc(geometry);
            shapes.add(shape);
        }
        return new ShapeCollection(shapes, (SpatialContext)SPATIAL_CONTEXT);
    }

    @Override
    public void initClazz(ODatabaseInternal db) {
        OSchema schema = db.getMetadata().getSchema();
        OClass shape = this.superClass(db);
        OClass polygon = schema.createAbstractClass(this.getName(), shape);
        polygon.createProperty("geometries", OType.EMBEDDEDLIST, shape);
    }

    @Override
    public String asText(ShapeCollection<Shape> shapes) {
        Geometry[] geometries = new Geometry[shapes.size()];
        int i = 0;
        for (Shape shape : shapes) {
            geometries[i] = SPATIAL_CONTEXT.getGeometryFrom(shape);
            ++i;
        }
        return GEOMETRY_FACTORY.createGeometryCollection(geometries).toText();
    }

    @Override
    public ODocument toDoc(ShapeCollection<Shape> shapes) {
        ODocument doc = new ODocument(this.getName());
        ArrayList<ODocument> geometries = new ArrayList<ODocument>(shapes.size());
        for (Shape s : shapes) {
            geometries.add(this.shapeFactory.toDoc(s));
        }
        doc.field("geometries", geometries);
        return doc;
    }
}

