/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.tx;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.exception.OLuceneIndexException;
import com.orientechnologies.lucene.tx.OLuceneTxChangesAbstract;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.core.KeywordAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.index.memory.MemoryIndex;
import org.apache.lucene.search.Query;

public class OLuceneTxChangesMultiRid
extends OLuceneTxChangesAbstract {
    private final Map<String, List<String>> deleted = new HashMap<String, List<String>>();
    private final Set<Document> deletedDocs = new HashSet<Document>();

    public OLuceneTxChangesMultiRid(OLuceneIndexEngine engine, IndexWriter writer, IndexWriter deletedIdx) {
        super(engine, writer, deletedIdx);
    }

    @Override
    public void put(Object key, OIdentifiable value, Document doc) {
        try {
            this.writer.addDocument((Iterable)doc);
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OLuceneIndexException("unable to add document to changes index"), (Throwable)e);
        }
    }

    @Override
    public void remove(Object key, OIdentifiable value) {
        try {
            if (value.getIdentity().isTemporary()) {
                this.writer.deleteDocuments(new Query[]{this.engine.deleteQuery(key, value)});
            } else {
                this.deleted.putIfAbsent(value.getIdentity().toString(), new ArrayList());
                this.deleted.get(value.getIdentity().toString()).add(key.toString());
                Document doc = this.engine.buildDocument(key, value);
                this.deletedDocs.add(doc);
                this.deletedIdx.addDocument((Iterable)doc);
            }
        }
        catch (IOException e) {
            throw OException.wrapException((OException)new OLuceneIndexException("Error while deleting documents in transaction from lucene index"), (Throwable)e);
        }
    }

    @Override
    public long numDocs() {
        return this.searcher().getIndexReader().numDocs() - this.deletedDocs.size();
    }

    @Override
    public Set<Document> getDeletedDocs() {
        return this.deletedDocs;
    }

    @Override
    public boolean isDeleted(Document document, Object key, OIdentifiable value) {
        boolean match = false;
        List<String> strings = this.deleted.get(value.getIdentity().toString());
        if (strings != null) {
            MemoryIndex memoryIndex = new MemoryIndex();
            for (String string : strings) {
                Query q = this.engine.deleteQuery(string, value);
                memoryIndex.reset();
                for (IndexableField field : document.getFields()) {
                    memoryIndex.addField(field.name(), field.stringValue(), (Analyzer)new KeywordAnalyzer());
                }
                match = match || memoryIndex.search(q) > 0.0f;
            }
            return match;
        }
        return match;
    }

    @Override
    public boolean isUpdated(Document document, Object key, OIdentifiable value) {
        return false;
    }
}

