/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.operator;

import com.orientechnologies.orient.core.command.OCommandContext;
import com.orientechnologies.orient.core.metadata.schema.OClass;
import com.orientechnologies.orient.core.sql.OIndexSearchResult;
import com.orientechnologies.orient.core.sql.OSQLHelper;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterCondition;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemField;
import com.orientechnologies.orient.core.sql.filter.OSQLFilterItemVariable;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorBetween;
import com.orientechnologies.orient.core.sql.operator.OQueryOperatorIn;
import java.util.Collection;
import java.util.List;

public class OLuceneOperatorUtil {
    public static OIndexSearchResult buildOIndexSearchResult(OClass iSchemaClass, OSQLFilterCondition iCondition, List<OIndexSearchResult> iIndexSearchResults, OCommandContext context) {
        if (iCondition.getLeft() instanceof Collection) {
            OIndexSearchResult lastResult = null;
            Collection left = (Collection)iCondition.getLeft();
            int i = 0;
            Object lastValue = null;
            for (Object obj : left) {
                List right;
                Object value;
                OSQLFilterItemField item;
                if (obj instanceof OSQLFilterItemField) {
                    item = (OSQLFilterItemField)obj;
                    value = null;
                    if (iCondition.getRight() instanceof Collection) {
                        right = (List)iCondition.getRight();
                        value = right.get(i);
                    } else {
                        value = iCondition.getRight();
                    }
                    lastResult = lastResult == null ? new OIndexSearchResult(iCondition.getOperator(), item.getFieldChain(), value) : lastResult.merge(new OIndexSearchResult(iCondition.getOperator(), item.getFieldChain(), value));
                } else if (obj instanceof OSQLFilterItemVariable) {
                    item = (OSQLFilterItemVariable)obj;
                    value = null;
                    if (iCondition.getRight() instanceof Collection) {
                        right = (List)iCondition.getRight();
                        value = right.get(i);
                    } else {
                        value = iCondition.getRight();
                    }
                    context.setVariable(item.toString(), value);
                }
                ++i;
            }
            if (lastResult != null && OLuceneOperatorUtil.checkIndexExistence(iSchemaClass, lastResult)) {
                iIndexSearchResults.add(lastResult);
            }
            return lastResult;
        }
        OIndexSearchResult result = OLuceneOperatorUtil.createIndexedProperty(iCondition, iCondition.getLeft());
        if (result == null) {
            result = OLuceneOperatorUtil.createIndexedProperty(iCondition, iCondition.getRight());
        }
        if (result == null) {
            return null;
        }
        if (OLuceneOperatorUtil.checkIndexExistence(iSchemaClass, result)) {
            iIndexSearchResults.add(result);
        }
        return result;
    }

    public static boolean checkIndexExistence(OClass iSchemaClass, OIndexSearchResult result) {
        if (!iSchemaClass.areIndexed((Collection)result.fields())) {
            return false;
        }
        if (result.lastField.isLong()) {
            int fieldCount = result.lastField.getItemCount();
            OClass cls = iSchemaClass.getProperty(result.lastField.getItemName(0)).getLinkedClass();
            for (int i = 1; i < fieldCount; ++i) {
                if (cls == null || !cls.areIndexed(new String[]{result.lastField.getItemName(i)})) {
                    return false;
                }
                cls = cls.getProperty(result.lastField.getItemName(i)).getLinkedClass();
            }
        }
        return true;
    }

    public static OIndexSearchResult createIndexedProperty(OSQLFilterCondition iCondition, Object iItem) {
        Object origValue;
        if (iItem == null || !(iItem instanceof OSQLFilterItemField)) {
            return null;
        }
        if (iCondition.getLeft() instanceof OSQLFilterItemField && iCondition.getRight() instanceof OSQLFilterItemField) {
            return null;
        }
        OSQLFilterItemField item = (OSQLFilterItemField)iItem;
        if (item.hasChainOperators() && !item.isFieldChain()) {
            return null;
        }
        Object object = origValue = iCondition.getLeft() == iItem ? iCondition.getRight() : iCondition.getLeft();
        if (iCondition.getOperator() instanceof OQueryOperatorBetween || iCondition.getOperator() instanceof OQueryOperatorIn) {
            return new OIndexSearchResult(iCondition.getOperator(), item.getFieldChain(), origValue);
        }
        Object value = OSQLHelper.getValue((Object)origValue);
        if (value == null) {
            return null;
        }
        return new OIndexSearchResult(iCondition.getOperator(), item.getFieldChain(), value);
    }
}

