/*
 * Decompiled with CFR 0.152.
 */
package com.orientechnologies.lucene.index;

import com.orientechnologies.common.exception.OException;
import com.orientechnologies.common.listener.OProgressListener;
import com.orientechnologies.common.serialization.types.OBinarySerializer;
import com.orientechnologies.common.util.ORawPair;
import com.orientechnologies.lucene.OLuceneIndex;
import com.orientechnologies.lucene.OLuceneTxOperations;
import com.orientechnologies.lucene.engine.OLuceneIndexEngine;
import com.orientechnologies.lucene.tx.OLuceneTxChanges;
import com.orientechnologies.orient.core.db.ODatabaseDocumentInternal;
import com.orientechnologies.orient.core.db.record.OIdentifiable;
import com.orientechnologies.orient.core.exception.OInvalidIndexEngineIdException;
import com.orientechnologies.orient.core.id.ORID;
import com.orientechnologies.orient.core.index.IndexStreamSecurityDecorator;
import com.orientechnologies.orient.core.index.OCompositeKey;
import com.orientechnologies.orient.core.index.OIndex;
import com.orientechnologies.orient.core.index.OIndexAbstract;
import com.orientechnologies.orient.core.index.OIndexException;
import com.orientechnologies.orient.core.record.impl.ODocument;
import com.orientechnologies.orient.core.storage.OStorage;
import com.orientechnologies.orient.core.storage.impl.local.OAbstractPaginatedStorage;
import com.orientechnologies.orient.core.storage.impl.local.paginated.atomicoperations.OAtomicOperation;
import com.orientechnologies.orient.core.tx.OTransaction;
import com.orientechnologies.orient.core.tx.OTransactionIndexChanges;
import com.orientechnologies.orient.core.tx.OTransactionIndexChangesPerKey;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.lucene.document.Document;
import org.apache.lucene.search.IndexSearcher;

public class OLuceneIndexNotUnique
extends OIndexAbstract
implements OLuceneIndex {
    public OLuceneIndexNotUnique(String name, String typeId, String algorithm, int version, OAbstractPaginatedStorage storage, String valueContainerAlgorithm, ODocument metadata, int binaryFormatVersion) {
        super(name, typeId, algorithm, valueContainerAlgorithm, metadata, version, (OStorage)storage, binaryFormatVersion);
    }

    public long rebuild(OProgressListener iProgressListener) {
        return super.rebuild(iProgressListener);
    }

    public boolean remove(Object key, OIdentifiable rid) {
        if (key != null) {
            OTransaction transaction = OLuceneIndexNotUnique.getDatabase().getTransaction();
            if (transaction.isActive()) {
                transaction.addIndexEntry((OIndex)this, super.getName(), OTransactionIndexChanges.OPERATION.REMOVE, this.encodeKey(key), rid);
                OLuceneTxChanges transactionChanges = this.getTransactionChanges(transaction);
                transactionChanges.remove(key, rid);
                return true;
            }
            while (true) {
                try {
                    return (Boolean)this.storage.callIndexEngine(false, this.indexId, engine -> {
                        OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                        return indexEngine.remove(key, rid);
                    });
                }
                catch (OInvalidIndexEngineIdException e) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
        }
        return true;
    }

    public OIndexAbstract removeCluster(String iClusterName) {
        this.acquireExclusiveLock();
        try {
            if (this.clustersToIndex.remove(iClusterName)) {
                this.updateConfiguration();
                this.remove("_CLUSTER:" + this.storage.getClusterIdByName(iClusterName));
            }
            OLuceneIndexNotUnique oLuceneIndexNotUnique = this;
            return oLuceneIndexNotUnique;
        }
        finally {
            this.releaseExclusiveLock();
        }
    }

    protected OBinarySerializer determineValueSerializer() {
        return this.storage.getComponentsFactory().binarySerializerFactory.getObjectSerializer((byte)21);
    }

    public Iterable<OTransactionIndexChangesPerKey.OTransactionIndexEntry> interpretTxKeyChanges(OTransactionIndexChangesPerKey changes) {
        return changes.interpret(OTransactionIndexChangesPerKey.Interpretation.NonUnique);
    }

    public void doPut(OAbstractPaginatedStorage storage, Object key, ORID rid) {
        while (true) {
            try {
                storage.callIndexEngine(false, this.indexId, engine -> {
                    try {
                        OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                        OAtomicOperation atomicOperation = storage.getAtomicOperationsManager().getCurrentOperation();
                        HashSet<ORID> set = new HashSet<ORID>();
                        set.add(rid);
                        indexEngine.put(atomicOperation, this.decodeKey(key), set);
                        return null;
                    }
                    catch (IOException e) {
                        throw OException.wrapException((OException)new OIndexException("Error during commit of index changes"), (Throwable)e);
                    }
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public Object getCollatingValue(Object key) {
        return key;
    }

    protected void commitSnapshot(Map<Object, Object> snapshot) {
        while (true) {
            try {
                this.storage.callIndexEngine(false, this.indexId, engine -> {
                    OLuceneTxOperations operations;
                    Object key;
                    OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                    for (Map.Entry snapshotEntry : snapshot.entrySet()) {
                        key = snapshotEntry.getKey();
                        operations = (OLuceneTxOperations)snapshotEntry.getValue();
                        for (OIdentifiable oIdentifiable : operations.removed) {
                            if (oIdentifiable == null) {
                                indexEngine.remove(this.decodeKey(key));
                                continue;
                            }
                            indexEngine.remove(this.decodeKey(key), oIdentifiable);
                        }
                    }
                    try {
                        for (Map.Entry snapshotEntry : snapshot.entrySet()) {
                            key = snapshotEntry.getKey();
                            operations = (OLuceneTxOperations)snapshotEntry.getValue();
                            OAtomicOperation atomicOperation = this.storage.getAtomicOperationsManager().getCurrentOperation();
                            indexEngine.put(atomicOperation, this.decodeKey(key), operations.added);
                        }
                        OTransaction transaction = OLuceneIndexNotUnique.getDatabase().getTransaction();
                        this.resetTransactionChanges(transaction);
                        return null;
                    }
                    catch (IOException e) {
                        throw OException.wrapException((OException)new OIndexException("Error during commit of index changes"), (Throwable)e);
                    }
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public void doDelete() {
        while (true) {
            try {
                this.storage.deleteIndexEngine(this.indexId);
            }
            catch (OInvalidIndexEngineIdException ignore) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    protected Object decodeKey(Object key) {
        return key;
    }

    private void resetTransactionChanges(OTransaction transaction) {
        transaction.setCustomData(this.getName(), null);
    }

    protected void putInSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        OLuceneTxOperations operations = (OLuceneTxOperations)snapshot.get(key = this.getCollatingValue(key));
        if (operations == null) {
            operations = new OLuceneTxOperations();
            snapshot.put(key, operations);
        }
        operations.added.add((OIdentifiable)value.getIdentity());
        snapshot.put(key, operations);
    }

    protected void removeFromSnapshot(Object key, OIdentifiable value, Map<Object, Object> snapshot) {
        OLuceneTxOperations operations = (OLuceneTxOperations)snapshot.get(key = this.getCollatingValue(key));
        if (operations == null) {
            operations = new OLuceneTxOperations();
            snapshot.put(key, operations);
        }
        operations.removed.add((OIdentifiable)value.getIdentity());
        snapshot.put(key, operations);
    }

    protected void removeFromSnapshot(Object key, Map<Object, Object> snapshot) {
        OLuceneTxOperations operations = (OLuceneTxOperations)snapshot.get(key = this.getCollatingValue(key));
        if (operations == null) {
            operations = new OLuceneTxOperations();
            snapshot.put(key, operations);
        }
        operations.removed.add(null);
        snapshot.put(key, operations);
    }

    protected void clearSnapshot(OIndexAbstract.IndexTxSnapshot indexTxSnapshot) {
        indexTxSnapshot.clear = true;
        indexTxSnapshot.indexSnapshot.clear();
    }

    protected void populateIndex(ODocument doc, Object fieldValue) {
        if (fieldValue instanceof Collection) {
            for (Object fieldValueItem : (Collection)fieldValue) {
                this.put(fieldValueItem, (OIdentifiable)doc);
            }
        } else {
            this.put(fieldValue, (OIdentifiable)doc);
        }
    }

    protected void onIndexEngineChange(int indexId) {
        while (true) {
            try {
                this.storage.callIndexEngine(false, indexId, engine -> {
                    OLuceneIndexEngine oIndexEngine = (OLuceneIndexEngine)engine;
                    oIndexEngine.init(this.getName(), this.getType(), this.getDefinition(), this.isAutomatic(), this.getMetadata());
                    return null;
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    protected Object encodeKey(Object key) {
        return key;
    }

    private OLuceneTxChanges getTransactionChanges(OTransaction transaction) {
        OLuceneTxChanges changes = (OLuceneTxChanges)transaction.getCustomData(this.getName());
        if (changes == null) {
            while (true) {
                try {
                    changes = (OLuceneTxChanges)this.storage.callIndexEngine(false, this.indexId, engine -> {
                        OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                        try {
                            return indexEngine.buildTxChanges();
                        }
                        catch (IOException e) {
                            throw OException.wrapException((OException)new OIndexException("Cannot get searcher from index " + this.getName()), (Throwable)e);
                        }
                    });
                }
                catch (OInvalidIndexEngineIdException e) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
            transaction.setCustomData(this.getName(), (Object)changes);
        }
        return changes;
    }

    @Deprecated
    public Collection<OIdentifiable> get(Object key) {
        try (Stream<ORID> stream = this.getRids(key);){
            Collection collection = stream.collect(Collectors.toList());
            return collection;
        }
    }

    public Stream<ORID> getRids(Object key) {
        OTransaction transaction = OLuceneIndexNotUnique.getDatabase().getTransaction();
        if (transaction.isActive()) {
            while (true) {
                try {
                    return ((Set)this.storage.callIndexEngine(false, this.indexId, engine -> {
                        OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                        return indexEngine.getInTx(key, this.getTransactionChanges(transaction));
                    })).stream().map(OIdentifiable::getIdentity);
                }
                catch (OInvalidIndexEngineIdException e) {
                    this.doReloadIndexEngine();
                    continue;
                }
                break;
            }
        }
        while (true) {
            try {
                Set result = (Set)this.storage.getIndexValue(this.indexId, key);
                return result.stream().map(OIdentifiable::getIdentity);
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public OLuceneIndexNotUnique put(Object key, OIdentifiable value) {
        if (key != null) {
            ODatabaseDocumentInternal db = OLuceneIndexNotUnique.getDatabase();
            OTransaction transaction = db.getTransaction();
            if (transaction.isActive()) {
                Document luceneDoc;
                OLuceneTxChanges transactionChanges = this.getTransactionChanges(transaction);
                transaction.addIndexEntry((OIndex)this, super.getName(), OTransactionIndexChanges.OPERATION.PUT, this.encodeKey(key), value);
                while (true) {
                    try {
                        luceneDoc = (Document)this.storage.callIndexEngine(false, this.indexId, engine -> {
                            OLuceneIndexEngine oIndexEngine = (OLuceneIndexEngine)engine;
                            return oIndexEngine.buildDocument(key, value);
                        });
                    }
                    catch (OInvalidIndexEngineIdException e) {
                        this.doReloadIndexEngine();
                        continue;
                    }
                    break;
                }
                transactionChanges.put(key, value, luceneDoc);
            } else {
                db.begin();
                OTransaction singleTx = db.getTransaction();
                singleTx.addIndexEntry((OIndex)this, super.getName(), OTransactionIndexChanges.OPERATION.PUT, this.encodeKey(key), value);
                db.commit();
            }
        }
        return this;
    }

    public long size() {
        while (true) {
            try {
                return (Long)this.storage.callIndexEngine(false, this.indexId, engine -> {
                    OTransaction transaction = OLuceneIndexNotUnique.getDatabase().getTransaction();
                    OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                    return indexEngine.sizeInTx(this.getTransactionChanges(transaction));
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public Stream<ORawPair<Object, ORID>> streamEntries(Collection<?> keys, boolean ascSortOrder) {
        String query = keys.stream().findFirst().map(k -> (OCompositeKey)k).map(OCompositeKey::getKeys).orElse(Collections.singletonList("q=*:*")).get(0);
        return IndexStreamSecurityDecorator.decorateStream((OIndex)this, this.getRids(query).map(rid -> new ORawPair((Object)query, rid)));
    }

    public Stream<ORawPair<Object, ORID>> streamEntriesBetween(Object fromKey, boolean fromInclusive, Object toKey, boolean toInclusive, boolean ascOrder) {
        while (true) {
            try {
                return IndexStreamSecurityDecorator.decorateStream((OIndex)this, (Stream)this.storage.iterateIndexEntriesBetween(this.indexId, fromKey, fromInclusive, toKey, toInclusive, ascOrder, null));
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public Stream<ORawPair<Object, ORID>> streamEntriesMajor(Object fromKey, boolean fromInclusive, boolean ascOrder) {
        while (true) {
            try {
                return IndexStreamSecurityDecorator.decorateStream((OIndex)this, (Stream)this.storage.iterateIndexEntriesMajor(this.indexId, fromKey, fromInclusive, ascOrder, null));
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public Stream<ORawPair<Object, ORID>> streamEntriesMinor(Object toKey, boolean toInclusive, boolean ascOrder) {
        while (true) {
            try {
                return IndexStreamSecurityDecorator.decorateStream((OIndex)this, (Stream)this.storage.iterateIndexEntriesMinor(this.indexId, toKey, toInclusive, ascOrder, null));
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public boolean isNativeTxSupported() {
        return false;
    }

    public Stream<ORawPair<Object, ORID>> stream() {
        while (true) {
            try {
                return IndexStreamSecurityDecorator.decorateStream((OIndex)this, (Stream)this.storage.getIndexStream(this.indexId, null));
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public Stream<ORawPair<Object, ORID>> descStream() {
        while (true) {
            try {
                return IndexStreamSecurityDecorator.decorateStream((OIndex)this, (Stream)this.storage.getIndexStream(this.indexId, null));
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public boolean supportsOrderedIterations() {
        return false;
    }

    @Override
    public IndexSearcher searcher() {
        while (true) {
            try {
                return (IndexSearcher)this.storage.callIndexEngine(false, this.indexId, engine -> {
                    OLuceneIndexEngine indexEngine = (OLuceneIndexEngine)engine;
                    return indexEngine.searcher();
                });
            }
            catch (OInvalidIndexEngineIdException e) {
                this.doReloadIndexEngine();
                continue;
            }
            break;
        }
    }

    public boolean canBeUsedInEqualityOperators() {
        return false;
    }
}

